/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.Polynomial;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRMath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\"R \u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0#0#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020 0#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/QRUtil;", "", "<init>", "()V", "", "data", "getBCHDigit", "(I)I", "getBCHTypeInfo", "getBCHTypeNumber", "", "s", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "getDataType", "(Ljava/lang/String;)Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "errorCorrectLength", "Lio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial;", "getErrorCorrectPolynomial", "(I)Lio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial;", "Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;", "maskPattern", "i", "j", "", "getMask", "(Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;II)Z", "typeNumber", "dataType", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "errorCorrectionLevel", "getMaxLength", "(ILio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;)I", "", "getPatternPosition", "(I)[I", "", "MAX_LENGTH", "[[[I", "PATTERN_POSITION_TABLE", "[[I"})
@StabilityInferred(parameters=0)
public final class QRUtil {
    public static final QRUtil INSTANCE = new QRUtil();
    private static final int[][] PATTERN_POSITION_TABLE;
    private static final int[][][] MAX_LENGTH;
    public static final int $stable;

    private QRUtil() {
    }

    public static int[] getPatternPosition(int typeNumber) {
        int n;
        return PATTERN_POSITION_TABLE[n - 1];
    }

    /*
     * WARNING - void declaration
     */
    public static int getMaxLength(int typeNumber, QRCodeDataType dataType, ErrorCorrectionLevel errorCorrectionLevel) {
        void var1_1;
        void var2_2;
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        return MAX_LENGTH[n - 1][var2_2.ordinal()][var1_1.ordinal()];
    }

    /*
     * WARNING - void declaration
     */
    public static Polynomial getErrorCorrectPolynomial(int errorCorrectLength) {
        void var1_3;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        Object a = new Polynomial(nArray2, 0, 2, null);
        for (int i = 0; i < errorCorrectLength; ++i) {
            Polynomial polynomial = a;
            int[] nArray3 = new int[2];
            a = nArray3;
            nArray3[0] = 1;
            a[1] = QRMath.gexp(i);
            a = polynomial.multiply(new Polynomial((int[])a, 0, 2, null));
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getMask(MaskPattern maskPattern, int i, int j) {
        MaskPattern maskPattern2;
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        switch (WhenMappings.$EnumSwitchMapping$0[maskPattern2.ordinal()]) {
            case 1: {
                return (i + j) % 2 == 0;
            }
            case 2: {
                return i % 2 == 0;
            }
            case 3: {
                return j % 3 == 0;
            }
            case 4: {
                return (i + j) % 3 == 0;
            }
            case 5: {
                return (i / 2 + j / 3) % 2 == 0;
            }
            case 6: {
                return i * j % 2 + i * j % 3 == 0;
            }
            case 7: {
                return (i * j % 2 + i * j % 3) % 2 == 0;
            }
            case 8: {
                void var2_2;
                void var1_1;
                return (i * j % 3 + (var1_1 + var2_2) % 2) % 2 == 0;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final QRCodeDataType getDataType(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s;
        charSequence = charSequence;
        if (new Regex("^[0-9A-Z $%*+\\-./:]+$").matches(charSequence)) {
            void var1_1;
            charSequence = var1_1;
            if (new Regex("^\\d+$").matches(charSequence = (CharSequence)charSequence)) {
                return QRCodeDataType.NUMBERS;
            }
            return QRCodeDataType.UPPER_ALPHA_NUM;
        }
        return QRCodeDataType.DEFAULT;
    }

    /*
     * WARNING - void declaration
     */
    public final int getBCHTypeInfo(int data) {
        void var2_2;
        void var1_1;
        int d = data << 10;
        while (QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(1335) >= 0) {
            d ^= 1335 << QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(1335);
        }
        return (var1_1 << 10 | var2_2) ^ 0x5412;
    }

    /*
     * WARNING - void declaration
     */
    public final int getBCHTypeNumber(int data) {
        void var2_2;
        void var1_1;
        int d = data << 12;
        while (QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(7973) >= 0) {
            d ^= 7973 << QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(7973);
        }
        return var1_1 << 12 | var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int getBCHDigit(int data) {
        void var1_1;
        int digit = 0;
        for (int i = data; i != 0; i >>>= 1) {
            ++digit;
        }
        return (int)var1_1;
    }

    static {
        int[][] nArrayArray = new int[40][];
        Object object = nArrayArray;
        nArrayArray[0] = new int[0];
        int[] nArray = new int[2];
        Object object2 = nArray;
        nArray[0] = 6;
        object2[1] = 18;
        object[1] = object2;
        int[] nArray2 = new int[2];
        object2 = nArray2;
        nArray2[0] = 6;
        object2[1] = 22;
        object[2] = object2;
        int[] nArray3 = new int[2];
        object2 = nArray3;
        nArray3[0] = 6;
        object2[1] = 26;
        object[3] = object2;
        int[] nArray4 = new int[2];
        object2 = nArray4;
        nArray4[0] = 6;
        object2[1] = 30;
        object[4] = object2;
        int[] nArray5 = new int[2];
        object2 = nArray5;
        nArray5[0] = 6;
        object2[1] = 34;
        object[5] = object2;
        int[] nArray6 = new int[3];
        object2 = nArray6;
        nArray6[0] = 6;
        object2[1] = 22;
        object2[2] = 38;
        object[6] = object2;
        int[] nArray7 = new int[3];
        object2 = nArray7;
        nArray7[0] = 6;
        object2[1] = 24;
        object2[2] = 42;
        object[7] = object2;
        int[] nArray8 = new int[3];
        object2 = nArray8;
        nArray8[0] = 6;
        object2[1] = 26;
        object2[2] = 46;
        object[8] = object2;
        int[] nArray9 = new int[3];
        object2 = nArray9;
        nArray9[0] = 6;
        object2[1] = 28;
        object2[2] = 50;
        object[9] = object2;
        int[] nArray10 = new int[3];
        object2 = nArray10;
        nArray10[0] = 6;
        object2[1] = 30;
        object2[2] = 54;
        object[10] = object2;
        int[] nArray11 = new int[3];
        object2 = nArray11;
        nArray11[0] = 6;
        object2[1] = 32;
        object2[2] = 58;
        object[11] = object2;
        int[] nArray12 = new int[3];
        object2 = nArray12;
        nArray12[0] = 6;
        object2[1] = 34;
        object2[2] = 62;
        object[12] = object2;
        int[] nArray13 = new int[4];
        object2 = nArray13;
        nArray13[0] = 6;
        object2[1] = 26;
        object2[2] = 46;
        object2[3] = 66;
        object[13] = object2;
        int[] nArray14 = new int[4];
        object2 = nArray14;
        nArray14[0] = 6;
        object2[1] = 26;
        object2[2] = 48;
        object2[3] = 70;
        object[14] = object2;
        int[] nArray15 = new int[4];
        object2 = nArray15;
        nArray15[0] = 6;
        object2[1] = 26;
        object2[2] = 50;
        object2[3] = 74;
        object[15] = object2;
        int[] nArray16 = new int[4];
        object2 = nArray16;
        nArray16[0] = 6;
        object2[1] = 30;
        object2[2] = 54;
        object2[3] = 78;
        object[16] = object2;
        int[] nArray17 = new int[4];
        object2 = nArray17;
        nArray17[0] = 6;
        object2[1] = 30;
        object2[2] = 56;
        object2[3] = 82;
        object[17] = object2;
        int[] nArray18 = new int[4];
        object2 = nArray18;
        nArray18[0] = 6;
        object2[1] = 30;
        object2[2] = 58;
        object2[3] = 86;
        object[18] = object2;
        int[] nArray19 = new int[4];
        object2 = nArray19;
        nArray19[0] = 6;
        object2[1] = 34;
        object2[2] = 62;
        object2[3] = 90;
        object[19] = object2;
        int[] nArray20 = new int[5];
        object2 = nArray20;
        nArray20[0] = 6;
        object2[1] = 28;
        object2[2] = 50;
        object2[3] = 72;
        object2[4] = 94;
        object[20] = object2;
        int[] nArray21 = new int[5];
        object2 = nArray21;
        nArray21[0] = 6;
        object2[1] = 26;
        object2[2] = 50;
        object2[3] = 74;
        object2[4] = 98;
        object[21] = object2;
        int[] nArray22 = new int[5];
        object2 = nArray22;
        nArray22[0] = 6;
        object2[1] = 30;
        object2[2] = 54;
        object2[3] = 78;
        object2[4] = 102;
        object[22] = object2;
        int[] nArray23 = new int[5];
        object2 = nArray23;
        nArray23[0] = 6;
        object2[1] = 28;
        object2[2] = 54;
        object2[3] = 80;
        object2[4] = 106;
        object[23] = object2;
        int[] nArray24 = new int[5];
        object2 = nArray24;
        nArray24[0] = 6;
        object2[1] = 32;
        object2[2] = 58;
        object2[3] = 84;
        object2[4] = 110;
        object[24] = object2;
        int[] nArray25 = new int[5];
        object2 = nArray25;
        nArray25[0] = 6;
        object2[1] = 30;
        object2[2] = 58;
        object2[3] = 86;
        object2[4] = 114;
        object[25] = object2;
        int[] nArray26 = new int[5];
        object2 = nArray26;
        nArray26[0] = 6;
        object2[1] = 34;
        object2[2] = 62;
        object2[3] = 90;
        object2[4] = 118;
        object[26] = object2;
        int[] nArray27 = new int[6];
        object2 = nArray27;
        nArray27[0] = 6;
        object2[1] = 26;
        object2[2] = 50;
        object2[3] = 74;
        object2[4] = 98;
        object2[5] = 122;
        object[27] = object2;
        int[] nArray28 = new int[6];
        object2 = nArray28;
        nArray28[0] = 6;
        object2[1] = 30;
        object2[2] = 54;
        object2[3] = 78;
        object2[4] = 102;
        object2[5] = 126;
        object[28] = object2;
        int[] nArray29 = new int[6];
        object2 = nArray29;
        nArray29[0] = 6;
        object2[1] = 26;
        object2[2] = 52;
        object2[3] = 78;
        object2[4] = 104;
        object2[5] = 130;
        object[29] = object2;
        int[] nArray30 = new int[6];
        object2 = nArray30;
        nArray30[0] = 6;
        object2[1] = 30;
        object2[2] = 56;
        object2[3] = 82;
        object2[4] = 108;
        object2[5] = 134;
        object[30] = object2;
        int[] nArray31 = new int[6];
        object2 = nArray31;
        nArray31[0] = 6;
        object2[1] = 34;
        object2[2] = 60;
        object2[3] = 86;
        object2[4] = 112;
        object2[5] = 138;
        object[31] = object2;
        int[] nArray32 = new int[6];
        object2 = nArray32;
        nArray32[0] = 6;
        object2[1] = 30;
        object2[2] = 58;
        object2[3] = 86;
        object2[4] = 114;
        object2[5] = 142;
        object[32] = object2;
        int[] nArray33 = new int[6];
        object2 = nArray33;
        nArray33[0] = 6;
        object2[1] = 34;
        object2[2] = 62;
        object2[3] = 90;
        object2[4] = 118;
        object2[5] = 146;
        object[33] = object2;
        int[] nArray34 = new int[7];
        object2 = nArray34;
        nArray34[0] = 6;
        object2[1] = 30;
        object2[2] = 54;
        object2[3] = 78;
        object2[4] = 102;
        object2[5] = 126;
        object2[6] = 150;
        object[34] = object2;
        int[] nArray35 = new int[7];
        object2 = nArray35;
        nArray35[0] = 6;
        object2[1] = 24;
        object2[2] = 50;
        object2[3] = 76;
        object2[4] = 102;
        object2[5] = 128;
        object2[6] = 154;
        object[35] = object2;
        int[] nArray36 = new int[7];
        object2 = nArray36;
        nArray36[0] = 6;
        object2[1] = 28;
        object2[2] = 54;
        object2[3] = 80;
        object2[4] = 106;
        object2[5] = 132;
        object2[6] = 158;
        object[36] = object2;
        int[] nArray37 = new int[7];
        object2 = nArray37;
        nArray37[0] = 6;
        object2[1] = 32;
        object2[2] = 58;
        object2[3] = 84;
        object2[4] = 110;
        object2[5] = 136;
        object2[6] = 162;
        object[37] = object2;
        int[] nArray38 = new int[7];
        object2 = nArray38;
        nArray38[0] = 6;
        object2[1] = 26;
        object2[2] = 54;
        object2[3] = 82;
        object2[4] = 110;
        object2[5] = 138;
        object2[6] = 166;
        object[38] = object2;
        int[] nArray39 = new int[7];
        object2 = nArray39;
        nArray39[0] = 6;
        object2[1] = 30;
        object2[2] = 58;
        object2[3] = 86;
        object2[4] = 114;
        object2[5] = 142;
        object2[6] = 170;
        object[39] = object2;
        PATTERN_POSITION_TABLE = object;
        int[][][] nArrayArray2 = new int[34][][];
        object = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        object2 = nArrayArray3;
        int[] nArray40 = new int[4];
        int[] nArray41 = nArray40;
        nArray40[0] = 41;
        nArray41[1] = 25;
        nArray41[2] = 17;
        nArray41[3] = 10;
        nArrayArray3[0] = nArray41;
        int[] nArray42 = new int[4];
        nArray41 = nArray42;
        nArray42[0] = 34;
        nArray41[1] = 20;
        nArray41[2] = 14;
        nArray41[3] = 8;
        object2[1] = (int)nArray41;
        int[] nArray43 = new int[4];
        nArray41 = nArray43;
        nArray43[0] = 27;
        nArray41[1] = 16;
        nArray41[2] = 11;
        nArray41[3] = 7;
        object2[2] = (int)nArray41;
        int[] nArray44 = new int[4];
        nArray41 = nArray44;
        nArray44[0] = 17;
        nArray41[1] = 10;
        nArray41[2] = 7;
        nArray41[3] = 4;
        object2[3] = (int)nArray41;
        nArrayArray2[0] = (int[][])object2;
        int[][] nArrayArray4 = new int[4][];
        object2 = nArrayArray4;
        int[] nArray45 = new int[4];
        nArray41 = nArray45;
        nArray45[0] = 77;
        nArray41[1] = 47;
        nArray41[2] = 32;
        nArray41[3] = 20;
        nArrayArray4[0] = nArray41;
        int[] nArray46 = new int[4];
        nArray41 = nArray46;
        nArray46[0] = 63;
        nArray41[1] = 38;
        nArray41[2] = 26;
        nArray41[3] = 16;
        object2[1] = (int)nArray41;
        int[] nArray47 = new int[4];
        nArray41 = nArray47;
        nArray47[0] = 48;
        nArray41[1] = 29;
        nArray41[2] = 20;
        nArray41[3] = 12;
        object2[2] = (int)nArray41;
        int[] nArray48 = new int[4];
        nArray41 = nArray48;
        nArray48[0] = 34;
        nArray41[1] = 20;
        nArray41[2] = 14;
        nArray41[3] = 8;
        object2[3] = (int)nArray41;
        object[1] = object2;
        int[][] nArrayArray5 = new int[4][];
        object2 = nArrayArray5;
        int[] nArray49 = new int[4];
        nArray41 = nArray49;
        nArray49[0] = 127;
        nArray41[1] = 77;
        nArray41[2] = 53;
        nArray41[3] = 32;
        nArrayArray5[0] = nArray41;
        int[] nArray50 = new int[4];
        nArray41 = nArray50;
        nArray50[0] = 101;
        nArray41[1] = 61;
        nArray41[2] = 42;
        nArray41[3] = 26;
        object2[1] = (int)nArray41;
        int[] nArray51 = new int[4];
        nArray41 = nArray51;
        nArray51[0] = 77;
        nArray41[1] = 47;
        nArray41[2] = 32;
        nArray41[3] = 20;
        object2[2] = (int)nArray41;
        int[] nArray52 = new int[4];
        nArray41 = nArray52;
        nArray52[0] = 58;
        nArray41[1] = 35;
        nArray41[2] = 24;
        nArray41[3] = 15;
        object2[3] = (int)nArray41;
        object[2] = object2;
        int[][] nArrayArray6 = new int[4][];
        object2 = nArrayArray6;
        int[] nArray53 = new int[4];
        nArray41 = nArray53;
        nArray53[0] = 187;
        nArray41[1] = 114;
        nArray41[2] = 78;
        nArray41[3] = 48;
        nArrayArray6[0] = nArray41;
        int[] nArray54 = new int[4];
        nArray41 = nArray54;
        nArray54[0] = 149;
        nArray41[1] = 90;
        nArray41[2] = 62;
        nArray41[3] = 38;
        object2[1] = (int)nArray41;
        int[] nArray55 = new int[4];
        nArray41 = nArray55;
        nArray55[0] = 111;
        nArray41[1] = 67;
        nArray41[2] = 46;
        nArray41[3] = 28;
        object2[2] = (int)nArray41;
        int[] nArray56 = new int[4];
        nArray41 = nArray56;
        nArray56[0] = 82;
        nArray41[1] = 50;
        nArray41[2] = 34;
        nArray41[3] = 21;
        object2[3] = (int)nArray41;
        object[3] = object2;
        int[][] nArrayArray7 = new int[4][];
        object2 = nArrayArray7;
        int[] nArray57 = new int[4];
        nArray41 = nArray57;
        nArray57[0] = 255;
        nArray41[1] = 154;
        nArray41[2] = 106;
        nArray41[3] = 65;
        nArrayArray7[0] = nArray41;
        int[] nArray58 = new int[4];
        nArray41 = nArray58;
        nArray58[0] = 202;
        nArray41[1] = 122;
        nArray41[2] = 84;
        nArray41[3] = 52;
        object2[1] = (int)nArray41;
        int[] nArray59 = new int[4];
        nArray41 = nArray59;
        nArray59[0] = 144;
        nArray41[1] = 87;
        nArray41[2] = 60;
        nArray41[3] = 37;
        object2[2] = (int)nArray41;
        int[] nArray60 = new int[4];
        nArray41 = nArray60;
        nArray60[0] = 106;
        nArray41[1] = 64;
        nArray41[2] = 44;
        nArray41[3] = 27;
        object2[3] = (int)nArray41;
        object[4] = object2;
        int[][] nArrayArray8 = new int[4][];
        object2 = nArrayArray8;
        int[] nArray61 = new int[4];
        nArray41 = nArray61;
        nArray61[0] = 322;
        nArray41[1] = 195;
        nArray41[2] = 134;
        nArray41[3] = 82;
        nArrayArray8[0] = nArray41;
        int[] nArray62 = new int[4];
        nArray41 = nArray62;
        nArray62[0] = 255;
        nArray41[1] = 154;
        nArray41[2] = 106;
        nArray41[3] = 65;
        object2[1] = (int)nArray41;
        int[] nArray63 = new int[4];
        nArray41 = nArray63;
        nArray63[0] = 178;
        nArray41[1] = 108;
        nArray41[2] = 74;
        nArray41[3] = 45;
        object2[2] = (int)nArray41;
        int[] nArray64 = new int[4];
        nArray41 = nArray64;
        nArray64[0] = 139;
        nArray41[1] = 84;
        nArray41[2] = 58;
        nArray41[3] = 36;
        object2[3] = (int)nArray41;
        object[5] = object2;
        int[][] nArrayArray9 = new int[4][];
        object2 = nArrayArray9;
        int[] nArray65 = new int[4];
        nArray41 = nArray65;
        nArray65[0] = 370;
        nArray41[1] = 224;
        nArray41[2] = 154;
        nArray41[3] = 95;
        nArrayArray9[0] = nArray41;
        int[] nArray66 = new int[4];
        nArray41 = nArray66;
        nArray66[0] = 293;
        nArray41[1] = 178;
        nArray41[2] = 122;
        nArray41[3] = 75;
        object2[1] = (int)nArray41;
        int[] nArray67 = new int[4];
        nArray41 = nArray67;
        nArray67[0] = 207;
        nArray41[1] = 125;
        nArray41[2] = 86;
        nArray41[3] = 53;
        object2[2] = (int)nArray41;
        int[] nArray68 = new int[4];
        nArray41 = nArray68;
        nArray68[0] = 154;
        nArray41[1] = 93;
        nArray41[2] = 64;
        nArray41[3] = 39;
        object2[3] = (int)nArray41;
        object[6] = object2;
        int[][] nArrayArray10 = new int[4][];
        object2 = nArrayArray10;
        int[] nArray69 = new int[4];
        nArray41 = nArray69;
        nArray69[0] = 461;
        nArray41[1] = 279;
        nArray41[2] = 192;
        nArray41[3] = 118;
        nArrayArray10[0] = nArray41;
        int[] nArray70 = new int[4];
        nArray41 = nArray70;
        nArray70[0] = 365;
        nArray41[1] = 221;
        nArray41[2] = 152;
        nArray41[3] = 93;
        object2[1] = (int)nArray41;
        int[] nArray71 = new int[4];
        nArray41 = nArray71;
        nArray71[0] = 259;
        nArray41[1] = 157;
        nArray41[2] = 108;
        nArray41[3] = 66;
        object2[2] = (int)nArray41;
        int[] nArray72 = new int[4];
        nArray41 = nArray72;
        nArray72[0] = 202;
        nArray41[1] = 122;
        nArray41[2] = 84;
        nArray41[3] = 52;
        object2[3] = (int)nArray41;
        object[7] = object2;
        int[][] nArrayArray11 = new int[4][];
        object2 = nArrayArray11;
        int[] nArray73 = new int[4];
        nArray41 = nArray73;
        nArray73[0] = 552;
        nArray41[1] = 335;
        nArray41[2] = 230;
        nArray41[3] = 141;
        nArrayArray11[0] = nArray41;
        int[] nArray74 = new int[4];
        nArray41 = nArray74;
        nArray74[0] = 432;
        nArray41[1] = 262;
        nArray41[2] = 180;
        nArray41[3] = 111;
        object2[1] = (int)nArray41;
        int[] nArray75 = new int[4];
        nArray41 = nArray75;
        nArray75[0] = 312;
        nArray41[1] = 189;
        nArray41[2] = 130;
        nArray41[3] = 80;
        object2[2] = (int)nArray41;
        int[] nArray76 = new int[4];
        nArray41 = nArray76;
        nArray76[0] = 235;
        nArray41[1] = 143;
        nArray41[2] = 98;
        nArray41[3] = 60;
        object2[3] = (int)nArray41;
        object[8] = object2;
        int[][] nArrayArray12 = new int[4][];
        object2 = nArrayArray12;
        int[] nArray77 = new int[4];
        nArray41 = nArray77;
        nArray77[0] = 652;
        nArray41[1] = 395;
        nArray41[2] = 271;
        nArray41[3] = 167;
        nArrayArray12[0] = nArray41;
        int[] nArray78 = new int[4];
        nArray41 = nArray78;
        nArray78[0] = 513;
        nArray41[1] = 311;
        nArray41[2] = 213;
        nArray41[3] = 131;
        object2[1] = (int)nArray41;
        int[] nArray79 = new int[4];
        nArray41 = nArray79;
        nArray79[0] = 364;
        nArray41[1] = 221;
        nArray41[2] = 151;
        nArray41[3] = 93;
        object2[2] = (int)nArray41;
        int[] nArray80 = new int[4];
        nArray41 = nArray80;
        nArray80[0] = 288;
        nArray41[1] = 174;
        nArray41[2] = 119;
        nArray41[3] = 74;
        object2[3] = (int)nArray41;
        object[9] = object2;
        int[][] nArrayArray13 = new int[4][];
        object2 = nArrayArray13;
        int[] nArray81 = new int[4];
        nArray41 = nArray81;
        nArray81[0] = 772;
        nArray41[1] = 468;
        nArray41[2] = 321;
        nArray41[3] = 198;
        nArrayArray13[0] = nArray41;
        int[] nArray82 = new int[4];
        nArray41 = nArray82;
        nArray82[0] = 604;
        nArray41[1] = 366;
        nArray41[2] = 251;
        nArray41[3] = 155;
        object2[1] = (int)nArray41;
        int[] nArray83 = new int[4];
        nArray41 = nArray83;
        nArray83[0] = 427;
        nArray41[1] = 259;
        nArray41[2] = 177;
        nArray41[3] = 109;
        object2[2] = (int)nArray41;
        int[] nArray84 = new int[4];
        nArray41 = nArray84;
        nArray84[0] = 331;
        nArray41[1] = 200;
        nArray41[2] = 137;
        nArray41[3] = 85;
        object2[3] = (int)nArray41;
        object[10] = object2;
        int[][] nArrayArray14 = new int[4][];
        object2 = nArrayArray14;
        int[] nArray85 = new int[4];
        nArray41 = nArray85;
        nArray85[0] = 883;
        nArray41[1] = 535;
        nArray41[2] = 367;
        nArray41[3] = 226;
        nArrayArray14[0] = nArray41;
        int[] nArray86 = new int[4];
        nArray41 = nArray86;
        nArray86[0] = 691;
        nArray41[1] = 419;
        nArray41[2] = 287;
        nArray41[3] = 177;
        object2[1] = (int)nArray41;
        int[] nArray87 = new int[4];
        nArray41 = nArray87;
        nArray87[0] = 489;
        nArray41[1] = 296;
        nArray41[2] = 203;
        nArray41[3] = 125;
        object2[2] = (int)nArray41;
        int[] nArray88 = new int[4];
        nArray41 = nArray88;
        nArray88[0] = 374;
        nArray41[1] = 227;
        nArray41[2] = 155;
        nArray41[3] = 96;
        object2[3] = (int)nArray41;
        object[11] = object2;
        int[][] nArrayArray15 = new int[4][];
        object2 = nArrayArray15;
        int[] nArray89 = new int[4];
        nArray41 = nArray89;
        nArray89[0] = 1022;
        nArray41[1] = 619;
        nArray41[2] = 425;
        nArray41[3] = 262;
        nArrayArray15[0] = nArray41;
        int[] nArray90 = new int[4];
        nArray41 = nArray90;
        nArray90[0] = 796;
        nArray41[1] = 483;
        nArray41[2] = 331;
        nArray41[3] = 204;
        object2[1] = (int)nArray41;
        int[] nArray91 = new int[4];
        nArray41 = nArray91;
        nArray91[0] = 580;
        nArray41[1] = 352;
        nArray41[2] = 241;
        nArray41[3] = 149;
        object2[2] = (int)nArray41;
        int[] nArray92 = new int[4];
        nArray41 = nArray92;
        nArray92[0] = 427;
        nArray41[1] = 259;
        nArray41[2] = 177;
        nArray41[3] = 109;
        object2[3] = (int)nArray41;
        object[12] = object2;
        int[][] nArrayArray16 = new int[4][];
        object2 = nArrayArray16;
        int[] nArray93 = new int[4];
        nArray41 = nArray93;
        nArray93[0] = 1101;
        nArray41[1] = 667;
        nArray41[2] = 458;
        nArray41[3] = 282;
        nArrayArray16[0] = nArray41;
        int[] nArray94 = new int[4];
        nArray41 = nArray94;
        nArray94[0] = 871;
        nArray41[1] = 528;
        nArray41[2] = 362;
        nArray41[3] = 223;
        object2[1] = (int)nArray41;
        int[] nArray95 = new int[4];
        nArray41 = nArray95;
        nArray95[0] = 621;
        nArray41[1] = 376;
        nArray41[2] = 258;
        nArray41[3] = 159;
        object2[2] = (int)nArray41;
        int[] nArray96 = new int[4];
        nArray41 = nArray96;
        nArray96[0] = 468;
        nArray41[1] = 283;
        nArray41[2] = 194;
        nArray41[3] = 120;
        object2[3] = (int)nArray41;
        object[13] = object2;
        int[][] nArrayArray17 = new int[4][];
        object2 = nArrayArray17;
        int[] nArray97 = new int[4];
        nArray41 = nArray97;
        nArray97[0] = 1250;
        nArray41[1] = 758;
        nArray41[2] = 520;
        nArray41[3] = 320;
        nArrayArray17[0] = nArray41;
        int[] nArray98 = new int[4];
        nArray41 = nArray98;
        nArray98[0] = 991;
        nArray41[1] = 600;
        nArray41[2] = 412;
        nArray41[3] = 254;
        object2[1] = (int)nArray41;
        int[] nArray99 = new int[4];
        nArray41 = nArray99;
        nArray99[0] = 703;
        nArray41[1] = 426;
        nArray41[2] = 292;
        nArray41[3] = 180;
        object2[2] = (int)nArray41;
        int[] nArray100 = new int[4];
        nArray41 = nArray100;
        nArray100[0] = 530;
        nArray41[1] = 321;
        nArray41[2] = 220;
        nArray41[3] = 136;
        object2[3] = (int)nArray41;
        object[14] = object2;
        int[][] nArrayArray18 = new int[4][];
        object2 = nArrayArray18;
        int[] nArray101 = new int[4];
        nArray41 = nArray101;
        nArray101[0] = 1408;
        nArray41[1] = 854;
        nArray41[2] = 586;
        nArray41[3] = 361;
        nArrayArray18[0] = nArray41;
        int[] nArray102 = new int[4];
        nArray41 = nArray102;
        nArray102[0] = 1082;
        nArray41[1] = 656;
        nArray41[2] = 450;
        nArray41[3] = 277;
        object2[1] = (int)nArray41;
        int[] nArray103 = new int[4];
        nArray41 = nArray103;
        nArray103[0] = 775;
        nArray41[1] = 470;
        nArray41[2] = 322;
        nArray41[3] = 198;
        object2[2] = (int)nArray41;
        int[] nArray104 = new int[4];
        nArray41 = nArray104;
        nArray104[0] = 602;
        nArray41[1] = 365;
        nArray41[2] = 250;
        nArray41[3] = 154;
        object2[3] = (int)nArray41;
        object[15] = object2;
        int[][] nArrayArray19 = new int[4][];
        object2 = nArrayArray19;
        int[] nArray105 = new int[4];
        nArray41 = nArray105;
        nArray105[0] = 1548;
        nArray41[1] = 938;
        nArray41[2] = 644;
        nArray41[3] = 397;
        nArrayArray19[0] = nArray41;
        int[] nArray106 = new int[4];
        nArray41 = nArray106;
        nArray106[0] = 1212;
        nArray41[1] = 734;
        nArray41[2] = 504;
        nArray41[3] = 310;
        object2[1] = (int)nArray41;
        int[] nArray107 = new int[4];
        nArray41 = nArray107;
        nArray107[0] = 876;
        nArray41[1] = 531;
        nArray41[2] = 364;
        nArray41[3] = 224;
        object2[2] = (int)nArray41;
        int[] nArray108 = new int[4];
        nArray41 = nArray108;
        nArray108[0] = 674;
        nArray41[1] = 408;
        nArray41[2] = 280;
        nArray41[3] = 173;
        object2[3] = (int)nArray41;
        object[16] = object2;
        int[][] nArrayArray20 = new int[4][];
        object2 = nArrayArray20;
        int[] nArray109 = new int[4];
        nArray41 = nArray109;
        nArray109[0] = 1725;
        nArray41[1] = 1046;
        nArray41[2] = 718;
        nArray41[3] = 442;
        nArrayArray20[0] = nArray41;
        int[] nArray110 = new int[4];
        nArray41 = nArray110;
        nArray110[0] = 1346;
        nArray41[1] = 816;
        nArray41[2] = 560;
        nArray41[3] = 345;
        object2[1] = (int)nArray41;
        int[] nArray111 = new int[4];
        nArray41 = nArray111;
        nArray111[0] = 948;
        nArray41[1] = 574;
        nArray41[2] = 394;
        nArray41[3] = 243;
        object2[2] = (int)nArray41;
        int[] nArray112 = new int[4];
        nArray41 = nArray112;
        nArray112[0] = 746;
        nArray41[1] = 452;
        nArray41[2] = 310;
        nArray41[3] = 191;
        object2[3] = (int)nArray41;
        object[17] = object2;
        int[][] nArrayArray21 = new int[4][];
        object2 = nArrayArray21;
        int[] nArray113 = new int[4];
        nArray41 = nArray113;
        nArray113[0] = 1903;
        nArray41[1] = 1153;
        nArray41[2] = 792;
        nArray41[3] = 488;
        nArrayArray21[0] = nArray41;
        int[] nArray114 = new int[4];
        nArray41 = nArray114;
        nArray114[0] = 1500;
        nArray41[1] = 909;
        nArray41[2] = 624;
        nArray41[3] = 384;
        object2[1] = (int)nArray41;
        int[] nArray115 = new int[4];
        nArray41 = nArray115;
        nArray115[0] = 1063;
        nArray41[1] = 644;
        nArray41[2] = 442;
        nArray41[3] = 272;
        object2[2] = (int)nArray41;
        int[] nArray116 = new int[4];
        nArray41 = nArray116;
        nArray116[0] = 813;
        nArray41[1] = 493;
        nArray41[2] = 338;
        nArray41[3] = 208;
        object2[3] = (int)nArray41;
        object[18] = object2;
        int[][] nArrayArray22 = new int[4][];
        object2 = nArrayArray22;
        int[] nArray117 = new int[4];
        nArray41 = nArray117;
        nArray117[0] = 2061;
        nArray41[1] = 1249;
        nArray41[2] = 858;
        nArray41[3] = 528;
        nArrayArray22[0] = nArray41;
        int[] nArray118 = new int[4];
        nArray41 = nArray118;
        nArray118[0] = 1600;
        nArray41[1] = 970;
        nArray41[2] = 666;
        nArray41[3] = 410;
        object2[1] = (int)nArray41;
        int[] nArray119 = new int[4];
        nArray41 = nArray119;
        nArray119[0] = 1159;
        nArray41[1] = 702;
        nArray41[2] = 482;
        nArray41[3] = 297;
        object2[2] = (int)nArray41;
        int[] nArray120 = new int[4];
        nArray41 = nArray120;
        nArray120[0] = 919;
        nArray41[1] = 557;
        nArray41[2] = 382;
        nArray41[3] = 235;
        object2[3] = (int)nArray41;
        object[19] = object2;
        int[][] nArrayArray23 = new int[4][];
        object2 = nArrayArray23;
        int[] nArray121 = new int[4];
        nArray41 = nArray121;
        nArray121[0] = 2232;
        nArray41[1] = 1352;
        nArray41[2] = 929;
        nArray41[3] = 572;
        nArrayArray23[0] = nArray41;
        int[] nArray122 = new int[4];
        nArray41 = nArray122;
        nArray122[0] = 1708;
        nArray41[1] = 1035;
        nArray41[2] = 711;
        nArray41[3] = 438;
        object2[1] = (int)nArray41;
        int[] nArray123 = new int[4];
        nArray41 = nArray123;
        nArray123[0] = 1224;
        nArray41[1] = 742;
        nArray41[2] = 509;
        nArray41[3] = 314;
        object2[2] = (int)nArray41;
        int[] nArray124 = new int[4];
        nArray41 = nArray124;
        nArray124[0] = 969;
        nArray41[1] = 587;
        nArray41[2] = 403;
        nArray41[3] = 248;
        object2[3] = (int)nArray41;
        object[20] = object2;
        int[][] nArrayArray24 = new int[4][];
        object2 = nArrayArray24;
        int[] nArray125 = new int[4];
        nArray41 = nArray125;
        nArray125[0] = 2409;
        nArray41[1] = 1460;
        nArray41[2] = 1003;
        nArray41[3] = 618;
        nArrayArray24[0] = nArray41;
        int[] nArray126 = new int[4];
        nArray41 = nArray126;
        nArray126[0] = 1872;
        nArray41[1] = 1134;
        nArray41[2] = 779;
        nArray41[3] = 480;
        object2[1] = (int)nArray41;
        int[] nArray127 = new int[4];
        nArray41 = nArray127;
        nArray127[0] = 1358;
        nArray41[1] = 823;
        nArray41[2] = 565;
        nArray41[3] = 348;
        object2[2] = (int)nArray41;
        int[] nArray128 = new int[4];
        nArray41 = nArray128;
        nArray128[0] = 1056;
        nArray41[1] = 640;
        nArray41[2] = 439;
        nArray41[3] = 270;
        object2[3] = (int)nArray41;
        object[21] = object2;
        int[][] nArrayArray25 = new int[4][];
        object2 = nArrayArray25;
        int[] nArray129 = new int[4];
        nArray41 = nArray129;
        nArray129[0] = 2620;
        nArray41[1] = 1588;
        nArray41[2] = 1091;
        nArray41[3] = 672;
        nArrayArray25[0] = nArray41;
        int[] nArray130 = new int[4];
        nArray41 = nArray130;
        nArray130[0] = 2059;
        nArray41[1] = 1248;
        nArray41[2] = 857;
        nArray41[3] = 528;
        object2[1] = (int)nArray41;
        int[] nArray131 = new int[4];
        nArray41 = nArray131;
        nArray131[0] = 1468;
        nArray41[1] = 890;
        nArray41[2] = 611;
        nArray41[3] = 376;
        object2[2] = (int)nArray41;
        int[] nArray132 = new int[4];
        nArray41 = nArray132;
        nArray132[0] = 1108;
        nArray41[1] = 672;
        nArray41[2] = 461;
        nArray41[3] = 284;
        object2[3] = (int)nArray41;
        object[22] = object2;
        int[][] nArrayArray26 = new int[4][];
        object2 = nArrayArray26;
        int[] nArray133 = new int[4];
        nArray41 = nArray133;
        nArray133[0] = 2812;
        nArray41[1] = 1704;
        nArray41[2] = 1171;
        nArray41[3] = 721;
        nArrayArray26[0] = nArray41;
        int[] nArray134 = new int[4];
        nArray41 = nArray134;
        nArray134[0] = 2188;
        nArray41[1] = 1326;
        nArray41[2] = 911;
        nArray41[3] = 561;
        object2[1] = (int)nArray41;
        int[] nArray135 = new int[4];
        nArray41 = nArray135;
        nArray135[0] = 1588;
        nArray41[1] = 963;
        nArray41[2] = 661;
        nArray41[3] = 407;
        object2[2] = (int)nArray41;
        int[] nArray136 = new int[4];
        nArray41 = nArray136;
        nArray136[0] = 1228;
        nArray41[1] = 744;
        nArray41[2] = 511;
        nArray41[3] = 315;
        object2[3] = (int)nArray41;
        object[23] = object2;
        int[][] nArrayArray27 = new int[4][];
        object2 = nArrayArray27;
        int[] nArray137 = new int[4];
        nArray41 = nArray137;
        nArray137[0] = 3057;
        nArray41[1] = 1853;
        nArray41[2] = 1273;
        nArray41[3] = 784;
        nArrayArray27[0] = nArray41;
        int[] nArray138 = new int[4];
        nArray41 = nArray138;
        nArray138[0] = 2395;
        nArray41[1] = 1451;
        nArray41[2] = 997;
        nArray41[3] = 614;
        object2[1] = (int)nArray41;
        int[] nArray139 = new int[4];
        nArray41 = nArray139;
        nArray139[0] = 1718;
        nArray41[1] = 1041;
        nArray41[2] = 715;
        nArray41[3] = 440;
        object2[2] = (int)nArray41;
        int[] nArray140 = new int[4];
        nArray41 = nArray140;
        nArray140[0] = 1286;
        nArray41[1] = 779;
        nArray41[2] = 535;
        nArray41[3] = 330;
        object2[3] = (int)nArray41;
        object[24] = object2;
        int[][] nArrayArray28 = new int[4][];
        object2 = nArrayArray28;
        int[] nArray141 = new int[4];
        nArray41 = nArray141;
        nArray141[0] = 3283;
        nArray41[1] = 1990;
        nArray41[2] = 1367;
        nArray41[3] = 842;
        nArrayArray28[0] = nArray41;
        int[] nArray142 = new int[4];
        nArray41 = nArray142;
        nArray142[0] = 2544;
        nArray41[1] = 1542;
        nArray41[2] = 1059;
        nArray41[3] = 652;
        object2[1] = (int)nArray41;
        int[] nArray143 = new int[4];
        nArray41 = nArray143;
        nArray143[0] = 1804;
        nArray41[1] = 1094;
        nArray41[2] = 751;
        nArray41[3] = 462;
        object2[2] = (int)nArray41;
        int[] nArray144 = new int[4];
        nArray41 = nArray144;
        nArray144[0] = 1425;
        nArray41[1] = 864;
        nArray41[2] = 593;
        nArray41[3] = 365;
        object2[3] = (int)nArray41;
        object[25] = object2;
        int[][] nArrayArray29 = new int[4][];
        object2 = nArrayArray29;
        int[] nArray145 = new int[4];
        nArray41 = nArray145;
        nArray145[0] = 3517;
        nArray41[1] = 2132;
        nArray41[2] = 1465;
        nArray41[3] = 902;
        nArrayArray29[0] = nArray41;
        int[] nArray146 = new int[4];
        nArray41 = nArray146;
        nArray146[0] = 2701;
        nArray41[1] = 1637;
        nArray41[2] = 1125;
        nArray41[3] = 692;
        object2[1] = (int)nArray41;
        int[] nArray147 = new int[4];
        nArray41 = nArray147;
        nArray147[0] = 1933;
        nArray41[1] = 1172;
        nArray41[2] = 805;
        nArray41[3] = 496;
        object2[2] = (int)nArray41;
        int[] nArray148 = new int[4];
        nArray41 = nArray148;
        nArray148[0] = 1501;
        nArray41[1] = 910;
        nArray41[2] = 625;
        nArray41[3] = 385;
        object2[3] = (int)nArray41;
        object[26] = object2;
        int[][] nArrayArray30 = new int[4][];
        object2 = nArrayArray30;
        int[] nArray149 = new int[4];
        nArray41 = nArray149;
        nArray149[0] = 3669;
        nArray41[1] = 2223;
        nArray41[2] = 1528;
        nArray41[3] = 940;
        nArrayArray30[0] = nArray41;
        int[] nArray150 = new int[4];
        nArray41 = nArray150;
        nArray150[0] = 2857;
        nArray41[1] = 1732;
        nArray41[2] = 1190;
        nArray41[3] = 732;
        object2[1] = (int)nArray41;
        int[] nArray151 = new int[4];
        nArray41 = nArray151;
        nArray151[0] = 2085;
        nArray41[1] = 1263;
        nArray41[2] = 868;
        nArray41[3] = 534;
        object2[2] = (int)nArray41;
        int[] nArray152 = new int[4];
        nArray41 = nArray152;
        nArray152[0] = 1581;
        nArray41[1] = 958;
        nArray41[2] = 658;
        nArray41[3] = 405;
        object2[3] = (int)nArray41;
        object[27] = object2;
        int[][] nArrayArray31 = new int[4][];
        object2 = nArrayArray31;
        int[] nArray153 = new int[4];
        nArray41 = nArray153;
        nArray153[0] = 3909;
        nArray41[1] = 2369;
        nArray41[2] = 1628;
        nArray41[3] = 1002;
        nArrayArray31[0] = nArray41;
        int[] nArray154 = new int[4];
        nArray41 = nArray154;
        nArray154[0] = 3035;
        nArray41[1] = 1839;
        nArray41[2] = 1264;
        nArray41[3] = 778;
        object2[1] = (int)nArray41;
        int[] nArray155 = new int[4];
        nArray41 = nArray155;
        nArray155[0] = 2181;
        nArray41[1] = 1322;
        nArray41[2] = 908;
        nArray41[3] = 559;
        object2[2] = (int)nArray41;
        int[] nArray156 = new int[4];
        nArray41 = nArray156;
        nArray156[0] = 1677;
        nArray41[1] = 1016;
        nArray41[2] = 698;
        nArray41[3] = 430;
        object2[3] = (int)nArray41;
        object[28] = object2;
        int[][] nArrayArray32 = new int[4][];
        object2 = nArrayArray32;
        int[] nArray157 = new int[4];
        nArray41 = nArray157;
        nArray157[0] = 4158;
        nArray41[1] = 2520;
        nArray41[2] = 1732;
        nArray41[3] = 1066;
        nArrayArray32[0] = nArray41;
        int[] nArray158 = new int[4];
        nArray41 = nArray158;
        nArray158[0] = 3289;
        nArray41[1] = 1994;
        nArray41[2] = 1370;
        nArray41[3] = 843;
        object2[1] = (int)nArray41;
        int[] nArray159 = new int[4];
        nArray41 = nArray159;
        nArray159[0] = 2358;
        nArray41[1] = 1429;
        nArray41[2] = 982;
        nArray41[3] = 604;
        object2[2] = (int)nArray41;
        int[] nArray160 = new int[4];
        nArray41 = nArray160;
        nArray160[0] = 1782;
        nArray41[1] = 1080;
        nArray41[2] = 742;
        nArray41[3] = 457;
        object2[3] = (int)nArray41;
        object[29] = object2;
        int[][] nArrayArray33 = new int[4][];
        object2 = nArrayArray33;
        int[] nArray161 = new int[4];
        nArray41 = nArray161;
        nArray161[0] = 4417;
        nArray41[1] = 2677;
        nArray41[2] = 1840;
        nArray41[3] = 1132;
        nArrayArray33[0] = nArray41;
        int[] nArray162 = new int[4];
        nArray41 = nArray162;
        nArray162[0] = 3486;
        nArray41[1] = 2113;
        nArray41[2] = 1452;
        nArray41[3] = 894;
        object2[1] = (int)nArray41;
        int[] nArray163 = new int[4];
        nArray41 = nArray163;
        nArray163[0] = 2473;
        nArray41[1] = 1499;
        nArray41[2] = 1030;
        nArray41[3] = 634;
        object2[2] = (int)nArray41;
        int[] nArray164 = new int[4];
        nArray41 = nArray164;
        nArray164[0] = 1897;
        nArray41[1] = 1150;
        nArray41[2] = 790;
        nArray41[3] = 486;
        object2[3] = (int)nArray41;
        object[30] = object2;
        int[][] nArrayArray34 = new int[4][];
        object2 = nArrayArray34;
        int[] nArray165 = new int[4];
        nArray41 = nArray165;
        nArray165[0] = 4686;
        nArray41[1] = 2840;
        nArray41[2] = 1952;
        nArray41[3] = 1201;
        nArrayArray34[0] = nArray41;
        int[] nArray166 = new int[4];
        nArray41 = nArray166;
        nArray166[0] = 3693;
        nArray41[1] = 2238;
        nArray41[2] = 1538;
        nArray41[3] = 947;
        object2[1] = (int)nArray41;
        int[] nArray167 = new int[4];
        nArray41 = nArray167;
        nArray167[0] = 2670;
        nArray41[1] = 1618;
        nArray41[2] = 1112;
        nArray41[3] = 684;
        object2[2] = (int)nArray41;
        int[] nArray168 = new int[4];
        nArray41 = nArray168;
        nArray168[0] = 2022;
        nArray41[1] = 1226;
        nArray41[2] = 842;
        nArray41[3] = 518;
        object2[3] = (int)nArray41;
        object[31] = object2;
        int[][] nArrayArray35 = new int[4][];
        object2 = nArrayArray35;
        int[] nArray169 = new int[4];
        nArray41 = nArray169;
        nArray169[0] = 4965;
        nArray41[1] = 3009;
        nArray41[2] = 2068;
        nArray41[3] = 1273;
        nArrayArray35[0] = nArray41;
        int[] nArray170 = new int[4];
        nArray41 = nArray170;
        nArray170[0] = 3909;
        nArray41[1] = 2369;
        nArray41[2] = 1628;
        nArray41[3] = 1002;
        object2[1] = (int)nArray41;
        int[] nArray171 = new int[4];
        nArray41 = nArray171;
        nArray171[0] = 2805;
        nArray41[1] = 1700;
        nArray41[2] = 1168;
        nArray41[3] = 719;
        object2[2] = (int)nArray41;
        int[] nArray172 = new int[4];
        nArray41 = nArray172;
        nArray172[0] = 2157;
        nArray41[1] = 1307;
        nArray41[2] = 898;
        nArray41[3] = 553;
        object2[3] = (int)nArray41;
        object[32] = object2;
        int[][] nArrayArray36 = new int[4][];
        object2 = nArrayArray36;
        int[] nArray173 = new int[4];
        nArray41 = nArray173;
        nArray173[0] = 5253;
        nArray41[1] = 3183;
        nArray41[2] = 2188;
        nArray41[3] = 1347;
        nArrayArray36[0] = nArray41;
        int[] nArray174 = new int[4];
        nArray41 = nArray174;
        nArray174[0] = 4134;
        nArray41[1] = 2506;
        nArray41[2] = 1722;
        nArray41[3] = 1060;
        object2[1] = (int)nArray41;
        int[] nArray175 = new int[4];
        nArray41 = nArray175;
        nArray175[0] = 2949;
        nArray41[1] = 1787;
        nArray41[2] = 1228;
        nArray41[3] = 756;
        object2[2] = (int)nArray41;
        int[] nArray176 = new int[4];
        nArray41 = nArray176;
        nArray176[0] = 2301;
        nArray41[1] = 1394;
        nArray41[2] = 958;
        nArray41[3] = 590;
        object2[3] = (int)nArray41;
        object[33] = object2;
        MAX_LENGTH = (int[][][])object;
        $stable = 8;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MaskPattern.values().length];
            try {
                nArray[MaskPattern.PATTERN000.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN001.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN010.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN011.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN100.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN101.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN110.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[MaskPattern.PATTERN111.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

