/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeRegion;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquare;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquareInfo;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquareType;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ'\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001dJ=\u0010!\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00192\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\nH\u0002\u00a2\u0006\u0004\b!\u0010\"J+\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n\u00a2\u0006\u0004\b$\u0010%J;\u0010&\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n2\u0006\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0004\b&\u0010'J+\u0010(\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n\u00a2\u0006\u0004\b(\u0010%J;\u0010+\u001a\u00020\r2\u0006\u0010*\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n\u00a2\u0006\u0004\b+\u0010,J3\u0010-\u001a\u00020\r2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\n\u00a2\u0006\u0004\b-\u0010."}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSetup;", "", "<init>", "()V", "", "data", "Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;", "maskPattern", "", "moduleCount", "", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;", "modules", "", "applyMaskPattern", "([ILio/github/alexzhirkevich/qrose/qrcode/MaskPattern;I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "row", "col", "probeSize", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeRegion;", "findSquareRegion", "(III)Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeRegion;", "rowOffset", "colOffset", "modulesSize", "", "isInsideModules", "(IIIII)Z", "isLeftRightColSquare", "(III)Z", "isMidSquare", "isTopBottomRowSquare", "value", "set", "(IIZ[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "type", "setupPositionAdjustPattern", "(I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "setupPositionProbePattern", "(II[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;I)V", "setupTimingPattern", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "errorCorrectionLevel", "setupTypeInfo", "(Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "setupTypeNumber", "(II[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V"})
@StabilityInferred(parameters=1)
public final class QRCodeSetup {
    public static final QRCodeSetup INSTANCE = new QRCodeSetup();

    private QRCodeSetup() {
    }

    public static /* synthetic */ void setupTopLeftPositionProbePattern$default$73e5a9a3(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2) {
        n = 7;
        Intrinsics.checkNotNullParameter((Object)qRCodeSquareArray, (String)"modules");
        qRCodeSetup.setupPositionProbePattern(0, 0, qRCodeSquareArray, n);
    }

    public static /* synthetic */ void setupTopRightPositionProbePattern$default$73e5a9a3(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2) {
        n = 7;
        Intrinsics.checkNotNullParameter((Object)qRCodeSquareArray, (String)"modules");
        qRCodeSetup.setupPositionProbePattern(((Object[])qRCodeSquareArray).length - n, 0, qRCodeSquareArray, n);
    }

    public static /* synthetic */ void setupBottomLeftPositionProbePattern$default$73e5a9a3(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2) {
        n = 7;
        Intrinsics.checkNotNullParameter((Object)qRCodeSquareArray, (String)"modules");
        qRCodeSetup.setupPositionProbePattern(0, ((Object[])qRCodeSquareArray).length - n, qRCodeSquareArray, n);
    }

    private void setupPositionProbePattern(int rowOffset, int colOffset, QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int modulesSize = ((Object[])modules).length;
        int row = -1;
        if (-1 <= probeSize) {
            while (true) {
                int col = -1;
                if (-1 <= probeSize) {
                    while (true) {
                        if (QRCodeSetup.isInsideModules(row, rowOffset, col, colOffset, modulesSize)) {
                            boolean isDark = QRCodeSetup.isTopBottomRowSquare(row, col, probeSize) || QRCodeSetup.isLeftRightColSquare(row, col, probeSize) || QRCodeSetup.isMidSquare(row, col, probeSize);
                            QRCodeRegion region = QRCodeSetup.findSquareRegion(row, col, probeSize);
                            int n = row + rowOffset;
                            int n2 = col + colOffset;
                            QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_PROBE, region);
                            modules[row + rowOffset][col + colOffset] = new QRCodeSquare(isDark, n, n2, modulesSize, qRCodeSquareInfo);
                        }
                        if (col == probeSize) break;
                        ++col;
                    }
                }
                if (row == probeSize) break;
                ++row;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInsideModules(int row, int rowOffset, int col, int colOffset, int modulesSize) {
        void var1_1;
        int n = row + var1_1;
        boolean bl = n >= 0 ? n < modulesSize : false;
        if (bl) {
            void var3_3;
            void var2_2;
            n = var2_2 + var3_3;
            boolean bl2 = n >= 0 ? n < modulesSize : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isTopBottomRowSquare(int row, int col, int probeSize) {
        void var2_2;
        int n;
        void var1_1;
        return (col >= 0 ? var1_1 < probeSize : false) && (row == 0 || n == var2_2 - true);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isLeftRightColSquare(int row, int col, int probeSize) {
        void var2_2;
        void var1_1;
        int n;
        return (row >= 0 ? n < probeSize : false) && (col == 0 || var1_1 == var2_2 - true);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isMidSquare(int row, int col, int probeSize) {
        void var2_2;
        void var1_1;
        int n;
        return (2 <= row ? n < probeSize - 2 : false) && 2 <= col && var1_1 <= var2_2 - 3;
    }

    /*
     * WARNING - void declaration
     */
    private static QRCodeRegion findSquareRegion(int row, int col, int probeSize) {
        void var2_2;
        void var1_1;
        int n = row;
        if (n == 0) {
            n = col;
            if (n == 0) {
                return QRCodeRegion.TOP_LEFT_CORNER;
            }
            if (n == probeSize - 1) {
                return QRCodeRegion.TOP_RIGHT_CORNER;
            }
            if (n == probeSize) {
                return QRCodeRegion.MARGIN;
            }
            return QRCodeRegion.TOP_MID;
        }
        if (n == probeSize - 1) {
            n = col;
            if (n == 0) {
                return QRCodeRegion.BOTTOM_LEFT_CORNER;
            }
            if (n == probeSize - 1) {
                return QRCodeRegion.BOTTOM_RIGHT_CORNER;
            }
            if (n == probeSize) {
                return QRCodeRegion.MARGIN;
            }
            return QRCodeRegion.BOTTOM_MID;
        }
        if (n == probeSize) {
            return QRCodeRegion.MARGIN;
        }
        n = var1_1;
        if (n == 0) {
            return QRCodeRegion.LEFT_MID;
        }
        if (n == probeSize - 1) {
            return QRCodeRegion.RIGHT_MID;
        }
        if (n == var2_2) {
            return QRCodeRegion.MARGIN;
        }
        return QRCodeRegion.CENTER;
    }

    public static void setupPositionAdjustPattern(int type, QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int[] pos = QRUtil.getPatternPosition(type);
        int n = pos.length;
        for (int i = 0; i < n; ++i) {
            int n2 = pos.length;
            for (int j = 0; j < n2; ++j) {
                int row = pos[i];
                int col = pos[j];
                if (modules[row][col] != null) continue;
                for (int r = -2; r < 3; ++r) {
                    for (int c = -2; c < 3; ++c) {
                        boolean bl = r == -2 || r == 2 || c == -2 || c == 2 || r == 0 && c == 0;
                        int n3 = row + r;
                        int n4 = col + c;
                        QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_ADJUST, QRCodeRegion.UNKNOWN);
                        int n5 = ((Object[])modules).length;
                        modules[row + r][col + c] = new QRCodeSquare(bl, n3, n4, n5, qRCodeSquareInfo);
                    }
                }
            }
        }
    }

    public static void setupTimingPattern(int moduleCount, QRCodeSquare[][] modules) {
        int n;
        int n2;
        QRCodeSquareInfo qRCodeSquareInfo;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int n3 = moduleCount - 8;
        for (int r = 8; r < n3; ++r) {
            if (modules[r][6] != null) continue;
            bl = r % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n2 = ((Object[])modules).length;
            modules[r][6] = new QRCodeSquare(bl, r, 6, n2, qRCodeSquareInfo);
        }
        n3 = n - 8;
        for (int c = 8; c < n3; ++c) {
            if (modules[6][c] != null) continue;
            int n4 = c;
            bl = n4 % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n2 = ((Object[])modules).length;
            modules[6][n4] = new QRCodeSquare(bl, 6, c, n2, qRCodeSquareInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setupTypeInfo(ErrorCorrectionLevel errorCorrectionLevel, MaskPattern maskPattern, int moduleCount, QRCodeSquare[][] modules) {
        void var3_5;
        boolean mod;
        int i;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int data = errorCorrectionLevel.getValue() << 3 | maskPattern.ordinal();
        int bits = QRUtil.INSTANCE.getBCHTypeInfo(data);
        for (i = 0; i < 15; ++i) {
            boolean bl = mod = (bits >> i & 1) == 1;
            if (i < 6) {
                QRCodeSetup.set(i, 8, mod, modules);
                continue;
            }
            if (i < 8) {
                QRCodeSetup.set(i + 1, 8, mod, modules);
                continue;
            }
            QRCodeSetup.set(moduleCount - 15 + i, 8, mod, modules);
        }
        for (i = 0; i < 15; ++i) {
            boolean bl = mod = (bits >> i & 1) == 1;
            if (i < 8) {
                QRCodeSetup.set(8, moduleCount - i - 1, mod, modules);
                continue;
            }
            if (i < 9) {
                QRCodeSetup.set(8, 15 - i, mod, modules);
                continue;
            }
            QRCodeSetup.set(8, 15 - i - 1, mod, modules);
        }
        QRCodeSetup.set((int)(var3_5 - 8), 8, true, modules);
    }

    public final void setupTypeNumber(int type, int moduleCount, QRCodeSquare[][] modules) {
        boolean mod;
        int i;
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int bits = QRUtil.INSTANCE.getBCHTypeNumber(type);
        for (i = 0; i < 18; ++i) {
            mod = (bits >> i & 1) == 1;
            QRCodeSetup.set(i / 3, i % 3 + moduleCount - 8 - 3, mod, modules);
        }
        for (i = 0; i < 18; ++i) {
            mod = (bits >> i & 1) == 1;
            QRCodeSetup.set(i % 3 + moduleCount - 8 - 3, i / 3, mod, modules);
        }
    }

    public final void applyMaskPattern(int[] data, MaskPattern maskPattern, int moduleCount, QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int inc = -1;
        int bitIndex = 7;
        int byteIndex = 0;
        int row = moduleCount - 1;
        for (int col = moduleCount - 1; col > 0; col -= 2) {
            if (col == 6) {
                --col;
            }
            do {
                for (int c = 0; c < 2; ++c) {
                    boolean bl;
                    if (modules[row][col - c] != null) continue;
                    boolean dark = false;
                    if (byteIndex < data.length) {
                        dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                    }
                    if (bl = QRUtil.getMask(maskPattern, row, col - c)) {
                        dark = !dark;
                    }
                    QRCodeSetup.set(row, col - c, dark, modules);
                    if (--bitIndex != -1) continue;
                    ++byteIndex;
                    bitIndex = 7;
                }
            } while ((row += inc) >= 0 && moduleCount > row);
            row -= inc;
            inc = -inc;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void set(int row, int col, boolean value, QRCodeSquare[][] modules) {
        void var3_3;
        void var1_1;
        int n;
        void var2_2;
        QRCodeSquare qrCodeSquare = modules[row][col];
        if (qrCodeSquare != null) {
            qrCodeSquare.setDark(value);
            return;
        }
        modules[row][col] = new QRCodeSquare((boolean)var2_2, n, (int)var1_1, ((Object[])var3_3).length, null, 16, null);
    }
}

