/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=0)
public final class BitBuffer {
    private int[] buffer;
    private int lengthInBits;
    private final int increments;
    public static final int $stable = 8;

    public BitBuffer() {
        this.increments = 32;
        this.buffer = new int[this.increments];
        this.lengthInBits = 0;
    }

    public final int[] getBuffer() {
        return this.buffer;
    }

    public final int getLengthInBits() {
        return this.lengthInBits;
    }

    public final void put(int num, int length) {
        for (int i = 0; i < length; ++i) {
            this.put((num >>> length - i - 1 & 1) == 1);
        }
    }

    public final void put(boolean bit) {
        int n;
        if (this.lengthInBits == this.buffer.length * 8) {
            int[] nArray = Arrays.copyOf(this.buffer, this.buffer.length + this.increments);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.buffer = nArray;
        }
        if (n != 0) {
            this.buffer[this.lengthInBits / 8] = this.buffer[this.lengthInBits / 8] | 128 >>> this.lengthInBits % 8;
        }
        n = this.lengthInBits;
        this.lengthInBits = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        int n = this.lengthInBits;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            BitBuffer bitBuffer = this;
            buffer.append((bitBuffer.buffer[n2 / 8] >>> 7 - n2 % 8 & 1) == 1 ? (char)'1' : '0');
        }
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

