/*
 * Decompiled with CFR 0.152.
 */
package application.desktop.main;

import androidx.compose.runtime.internal.StabilityInferred;
import application.desktop.main.DesktopApplicationVersionKt;
import application.desktop.main.DesktopUpdatesKt;
import application.shared.desktop.platform.ConveyorProperties;
import application.shared.desktop.platform.ConveyorPropertiesKt;
import dev.hydraulic.conveyor.control.SoftwareUpdateController;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLUtilsKt;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import services.client.StagingSslSettings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lapplication/desktop/main/DesktopUpdates;", "", "Ldev/hydraulic/conveyor/control/SoftwareUpdateController;", "controller", "<init>", "(Ldev/hydraulic/conveyor/control/SoftwareUpdateController;)V", "", "queryAvailableUpdateVersion", "()Ljava/lang/String;", "", "startUpdateProcess", "()V", "Ldev/hydraulic/conveyor/control/SoftwareUpdateController;", "getDownloadUrl", "downloadUrl", "getCurrentVersion", "currentVersion", "", "isCanTriggerUpdateUi", "()Z"})
@StabilityInferred(parameters=0)
public final class DesktopUpdates {
    private final SoftwareUpdateController controller;
    public static final int $stable = 8;

    private DesktopUpdates(SoftwareUpdateController controller) {
        DesktopUpdates desktopUpdates;
        this.controller = desktopUpdates;
        DesktopUpdatesKt.access$getLogger$p().info(() -> DesktopUpdates._init_$lambda$1(this));
        desktopUpdates = this;
        String string = DesktopUpdates.getDownloadUrl();
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"downloads.flechette.app", (boolean)false, (int)2, null) : false;
        boolean bl2 = !bl;
        if (bl2) {
            HttpsURLConnection.setDefaultSSLSocketFactory(StagingSslSettings.INSTANCE.getSslContext().getSocketFactory());
        }
    }

    public /* synthetic */ DesktopUpdates(SoftwareUpdateController softwareUpdateController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            softwareUpdateController = SoftwareUpdateController.getInstance();
        }
        this(softwareUpdateController);
    }

    public static String getDownloadUrl() {
        Object object = ConveyorPropertiesKt.getConveyorProperties();
        if (object != null && (object = object.getAppRepositoryUrl()) != null) {
            Object object2 = object;
            URLBuilder $this$_get_downloadUrl__u24lambda_u243_u24lambda_u242 = URLUtilsKt.URLBuilder((String)object);
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = "download.html";
            URLBuilderKt.path((URLBuilder)$this$_get_downloadUrl__u24lambda_u243_u24lambda_u242, (String[])stringArray2);
            return object2.buildString();
        }
        return null;
    }

    public final String getCurrentVersion() {
        Object object = this.controller;
        if (object == null || (object = object.getCurrentVersion()) == null || (object = object.getVersion()) == null) {
            object = DesktopApplicationVersionKt.getApplicationVersion();
        }
        return object;
    }

    public final boolean isCanTriggerUpdateUi() {
        SoftwareUpdateController softwareUpdateController = this.controller;
        return (softwareUpdateController != null ? softwareUpdateController.canTriggerUpdateCheckUI() : null) == SoftwareUpdateController.Availability.AVAILABLE;
    }

    /*
     * WARNING - void declaration
     */
    public final String queryAvailableUpdateVersion() {
        try {
            SoftwareUpdateController softwareUpdateController = this.controller;
            Object remoteVersion = softwareUpdateController != null ? softwareUpdateController.getCurrentVersionFromRepository() : null;
            if (remoteVersion == null) {
                DesktopUpdatesKt.access$getLogger$p().info(DesktopUpdates::queryAvailableUpdateVersion$lambda$4);
                return null;
            }
            SoftwareUpdateController softwareUpdateController2 = this.controller;
            if (remoteVersion.compareTo((SoftwareUpdateController.Version)(softwareUpdateController2 != null ? softwareUpdateController2.getCurrentVersion() : null)) > 0) {
                DesktopUpdatesKt.access$getLogger$p().info(() -> DesktopUpdates.queryAvailableUpdateVersion$lambda$5(this, (SoftwareUpdateController.Version)remoteVersion));
                return remoteVersion.getVersion();
            }
            DesktopUpdatesKt.access$getLogger$p().info(() -> DesktopUpdates.queryAvailableUpdateVersion$lambda$6(this));
            return null;
        }
        catch (SoftwareUpdateController.UpdateCheckException ex) {
            void var1_2;
            DesktopUpdatesKt.access$getLogger$p().warn(() -> DesktopUpdates.queryAvailableUpdateVersion$lambda$7((SoftwareUpdateController.UpdateCheckException)var1_2));
            return null;
        }
    }

    public final void startUpdateProcess() {
        if (this.isCanTriggerUpdateUi()) {
            SoftwareUpdateController softwareUpdateController = this.controller;
            if (softwareUpdateController != null) {
                softwareUpdateController.triggerUpdateCheckUI();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object _init_$lambda$1(DesktopUpdates this$0) {
        void var2_2;
        DesktopUpdates desktopUpdates;
        StringBuilder stringBuilder;
        StringBuilder $this$lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
        stringBuilder.append("Current version " + this$0.getCurrentVersion() + " - ");
        ConveyorProperties conveyorProperties = ConveyorPropertiesKt.getConveyorProperties();
        $this$lambda_u241_u24lambda_u240.append("Repository " + (conveyorProperties != null ? conveyorProperties.getAppRepositoryUrl() : null) + " - ");
        $this$lambda_u241_u24lambda_u240.append("Update application is ");
        SoftwareUpdateController softwareUpdateController = desktopUpdates.controller;
        Object object = softwareUpdateController != null ? softwareUpdateController.canTriggerUpdateCheckUI() : null;
        var2_2.append(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> "possible";
            case 2 -> "unavailable on this platform";
            case 3 -> "unavailable for this packaging";
            case 4 -> "unavailable for non-gui apps";
            case 5 -> "unavailable for unknown reason";
            case -1 -> "unavailable";
            default -> throw new NoWhenBranchMatchedException();
        });
        return stringBuilder.toString();
    }

    private static final Object queryAvailableUpdateVersion$lambda$4() {
        return "No remote version available";
    }

    /*
     * WARNING - void declaration
     */
    private static final Object queryAvailableUpdateVersion$lambda$5(DesktopUpdates this$0, SoftwareUpdateController.Version $remoteVersion) {
        void var1_1;
        return "Update from " + this$0.getCurrentVersion() + " to " + var1_1.getVersion() + " available!";
    }

    private static final Object queryAvailableUpdateVersion$lambda$6(DesktopUpdates this$0) {
        return "Current version is the latest (" + this$0.getCurrentVersion() + ")";
    }

    private static final Object queryAvailableUpdateVersion$lambda$7(SoftwareUpdateController.UpdateCheckException $ex) {
        return "Unable to check for updates: " + $ex.getMessage();
    }

    public DesktopUpdates() {
        this(null, 1, null);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftwareUpdateController.Availability.values().length];
            try {
                nArray[SoftwareUpdateController.Availability.AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SoftwareUpdateController.Availability.UNIMPLEMENTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SoftwareUpdateController.Availability.UNSUPPORTED_PACKAGE_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SoftwareUpdateController.Availability.NON_GUI_APP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SoftwareUpdateController.Availability.OTHER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

