/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.internal.Debug;

public final class TagInfoGpsText
extends TagInfo {
    private static final TextEncoding TEXT_ENCODING_ASCII = new TextEncoding(new byte[]{65, 83, 67, 73, 73, 0, 0, 0}, StandardCharsets.US_ASCII.name());
    private static final TextEncoding TEXT_ENCODING_JIS = new TextEncoding(new byte[]{74, 73, 83, 0, 0, 0, 0, 0}, "JIS");
    private static final TextEncoding TEXT_ENCODING_UNICODE_LE = new TextEncoding(new byte[]{85, 78, 73, 67, 79, 68, 69, 0}, StandardCharsets.UTF_16LE.name());
    private static final TextEncoding TEXT_ENCODING_UNICODE_BE = new TextEncoding(new byte[]{85, 78, 73, 67, 79, 68, 69, 0}, StandardCharsets.UTF_16BE.name());
    private static final TextEncoding TEXT_ENCODING_UNDEFINED = new TextEncoding(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, StandardCharsets.ISO_8859_1.name());
    private static final TextEncoding[] TEXT_ENCODINGS = new TextEncoding[]{TEXT_ENCODING_ASCII, TEXT_ENCODING_JIS, TEXT_ENCODING_UNICODE_LE, TEXT_ENCODING_UNICODE_BE, TEXT_ENCODING_UNDEFINED};

    /*
     * WARNING - void declaration
     */
    public TagInfoGpsText(String name, int tag, TiffDirectoryType exifDirectory) {
        super((String)var1_1, (int)var2_2, AbstractFieldType.UNDEFINED, -1, (TiffDirectoryType)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    private static String getValue(TiffField entry) throws ImagingException {
        Object object;
        Object object2;
        if (entry.getFieldType() == AbstractFieldType.ASCII) {
            object2 = ((AbstractFieldType)AbstractFieldType.ASCII).getValue(entry);
            if (object2 instanceof String) {
                return (String)object2;
            }
            if (object2 instanceof String[]) {
                return ((String[])object2)[0];
            }
            throw new ImagingException("Unexpected ASCII type decoded");
        }
        if (((TiffField)object2).getFieldType() != AbstractFieldType.UNDEFINED && ((TiffField)object2).getFieldType() != AbstractFieldType.BYTE) {
            Debug.debug("entry.type: " + ((TiffField)object2).getFieldType());
            Debug.debug("entry.directoryType: " + ((TiffField)object2).getDirectoryType());
            Debug.debug("entry.type: " + ((TiffField)object2).getDescriptionWithoutValue());
            Debug.debug("entry.type: " + ((TiffField)object2).getFieldType());
            throw new ImagingException("GPS text field not encoded as bytes.");
        }
        byte[] byArray = ((TiffField)object2).getByteArrayValue();
        Object bytes = byArray;
        if (byArray.length < 8) {
            return new String((byte[])bytes, StandardCharsets.US_ASCII);
        }
        TextEncoding[] textEncodingArray = TEXT_ENCODINGS;
        int n = TEXT_ENCODINGS.length;
        for (int i = 0; i < n; ++i) {
            TextEncoding encoding = textEncodingArray[i];
            if (!BinaryFunctions.compareBytes((byte[])bytes, 0, encoding.prefix, 0, encoding.prefix.length)) continue;
            try {
                String decodedString = new String((byte[])bytes, encoding.prefix.length, ((Object)bytes).length - encoding.prefix.length, encoding.encodingName);
                byte[] reEncodedBytes = decodedString.getBytes(encoding.encodingName);
                if (!BinaryFunctions.compareBytes((byte[])bytes, encoding.prefix.length, reEncodedBytes, 0, reEncodedBytes.length)) continue;
                return decodedString;
            }
            catch (UnsupportedEncodingException e) {
                throw new ImagingException(e.getMessage(), e);
            }
        }
        return new String((byte[])object, StandardCharsets.US_ASCII);
    }

    private static final class TextEncoding {
        final byte[] prefix;
        public final String encodingName;

        /*
         * WARNING - void declaration
         */
        TextEncoding(byte[] prefix, String encodingName) {
            void var2_2;
            void var1_1;
            this.prefix = var1_1;
            this.encodingName = var2_2;
        }
    }
}

