/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public final class PhotometricInterpreterYCbCr
extends PhotometricInterpreter {
    private static int limit(int value, int min, int max) {
        int n;
        return Math.min(255, Math.max(0, n));
    }

    /*
     * WARNING - void declaration
     */
    public PhotometricInterpreterYCbCr(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height) {
        super((int)var1_1, (int[])var2_2, (int)var3_3, width, height);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        void var2_3;
        void var3_4;
        void var1_1;
        int Y = samples[0];
        int cb = samples[1];
        int cr = samples[2];
        double r = (double)Y + 1.402 * ((double)cr - 128.0);
        double g = (double)Y - 0.34414 * ((double)cb - 128.0) - 0.71414 * ((double)cr - 128.0);
        double b = (double)Y + 1.772 * ((double)cb - 128.0);
        int red = PhotometricInterpreterYCbCr.limit((int)r, 0, 255);
        int green = PhotometricInterpreterYCbCr.limit((int)g, 0, 255);
        int blue = PhotometricInterpreterYCbCr.limit((int)b, 0, 255);
        int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        var1_1.setRgb((int)var3_4, y, (int)var2_3);
    }
}

