/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingFormatException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public final class PhotometricInterpreterPalette
extends PhotometricInterpreter {
    private final int[] indexColorMap;
    private final int bitsPerPixelMask;

    /*
     * WARNING - void declaration
     */
    public PhotometricInterpreterPalette(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height, int[] colorMap) {
        super(samplesPerPixel, bitsPerSample, predictor, width, height);
        void var2_3;
        int maxI;
        int colorMapScaleX2;
        int bitsPerPixel = this.getBitsPerSample(0);
        int colorMapScale = 1 << bitsPerPixel;
        try {
            colorMapScaleX2 = Math.multiplyExact(2, colorMapScale);
        }
        catch (ArithmeticException e) {
            throw new ImagingFormatException("bitsPerPixel is too large or colorMap is too small", e);
        }
        try {
            maxI = Math.addExact(colorMapScaleX2, colorMapScale - 1);
        }
        catch (ArithmeticException e) {
            throw new ImagingFormatException("bitsPerPixel is too large or colorMap is too small", e);
        }
        if (maxI >= colorMap.length) {
            throw new ImagingFormatException("bitsPerPixel %,d (maxI = %,d) is too large or colorMap is too small %,d", bitsPerPixel, maxI, colorMap.length);
        }
        this.indexColorMap = Allocator.intArray((int)e);
        Arrays.setAll(this.indexColorMap, arg_0 -> PhotometricInterpreterPalette.lambda$new$0(colorMap, (int)e, colorMapScaleX2, arg_0));
        int temp = 0;
        for (int i = 0; i < bitsPerPixel; ++i) {
            temp = temp << 1 | 1;
        }
        this.bitsPerPixelMask = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        void var2_2;
        void var3_3;
        imageBuilder.setRgb((int)var3_3, y, this.indexColorMap[var2_2[0] & this.bitsPerPixelMask]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$new$0(int[] colorMap, int colorMapScale, int colorMapScaleX2, int i) {
        void var0_1;
        void var1_2;
        void var2_3;
        void var3_4;
        int red = colorMap[i] >> 8 & 0xFF;
        int green = colorMap[i + colorMapScale] >> 8 & 0xFF;
        int blue = colorMap[var3_4 + var2_3] >> 8 & 0xFF;
        return 0xFF000000 | red << 16 | var1_2 << 8 | var0_1;
    }
}

