/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.PackBits;
import org.apache.commons.imaging.common.ZlibDeflate;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.itu_t4.T4AndT6Compression;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.mylzw.MyLzwDecompressor;

public abstract class ImageDataReader {
    protected final TiffDirectory directory;
    protected final PhotometricInterpreter photometricInterpreter;
    private final int[] bitsPerSample;
    protected final int bitsPerSampleLength;
    private final int[] last;
    protected final int predictor;
    protected final int samplesPerPixel;
    protected final int width;
    protected final int height;
    protected final int sampleFormat;
    protected final TiffPlanarConfiguration planarConfiguration;

    /*
     * WARNING - void declaration
     */
    public ImageDataReader(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int[] bitsPerSample, int predictor, int samplesPerPixel, int sampleFormat, int width, int height, TiffPlanarConfiguration planarConfiguration) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.directory = var1_1;
        this.photometricInterpreter = var2_2;
        this.bitsPerSample = bitsPerSample;
        this.bitsPerSampleLength = ((void)var3_3).length;
        this.samplesPerPixel = samplesPerPixel;
        this.sampleFormat = sampleFormat;
        this.predictor = predictor;
        this.width = width;
        this.height = height;
        this.planarConfiguration = planarConfiguration;
        this.last = Allocator.intArray(samplesPerPixel);
    }

    /*
     * WARNING - void declaration
     */
    protected final int[] applyPredictor(int[] samples) {
        void var1_1;
        if (this.predictor == 2) {
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = 0xFF & samples[i] + this.last[i];
                this.last[i] = samples[i];
            }
        }
        return var1_1;
    }

    protected static void applyPredictorToBlock(int width, int height, int nSamplesPerPixel, byte[] p) {
        int k = width * nSamplesPerPixel;
        for (int i = 0; i < height; ++i) {
            int j0 = i * k + nSamplesPerPixel;
            int j1 = (i + 1) * k;
            for (int j = j0; j < j1; ++j) {
                int n = j;
                p[n] = (byte)(p[n] + p[j - nSamplesPerPixel]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final byte[] decompress(byte[] compressedInput, int compression, int expectedSize, int tileWidth, int tileHeight) throws ImagingException, IOException {
        void var2_4;
        int i;
        byte[] compressedOrdered;
        TiffField fillOrderField = this.directory.findField(TiffTagConstants.TIFF_TAG_FILL_ORDER);
        int fillOrder = 1;
        if (fillOrderField != null) {
            fillOrder = fillOrderField.getIntValue();
        }
        if (fillOrder == 1) {
            compressedOrdered = compressedInput;
        } else if (fillOrder == 2) {
            compressedOrdered = new byte[compressedInput.length];
            for (i = 0; i < compressedInput.length; ++i) {
                compressedOrdered[i] = (byte)(Integer.reverse(0xFF & compressedInput[i]) >>> 24);
            }
        } else {
            throw new ImagingException("TIFF FillOrder=" + i + " is invalid");
        }
        switch (compression) {
            case 1: {
                return compressedOrdered;
            }
            case 2: {
                return T4AndT6Compression.decompressModifiedHuffman(compressedOrdered, tileWidth, tileHeight);
            }
            case 3: {
                boolean hasFillBitsBeforeEOL;
                int t4Options = 0;
                TiffField field = this.directory.findField(TiffTagConstants.TIFF_TAG_T4_OPTIONS);
                if (field != null) {
                    t4Options = field.getIntValue();
                }
                boolean is2D = (t4Options & 1) != 0;
                compression = (t4Options & 2) != 0 ? 1 : 0;
                if (compression != 0) {
                    throw new ImagingException("T.4 compression with the uncompressed mode extension is not yet supported");
                }
                boolean bl = hasFillBitsBeforeEOL = (t4Options & 4) != 0;
                if (is2D) {
                    return T4AndT6Compression.decompressT4_2D(compressedOrdered, tileWidth, tileHeight, hasFillBitsBeforeEOL);
                }
                return T4AndT6Compression.decompressT4_1D(compressedOrdered, tileWidth, tileHeight, (boolean)var2_4);
            }
            case 4: {
                boolean bl;
                void var1_1;
                int t6Options = 0;
                TiffField field = this.directory.findField(TiffTagConstants.TIFF_TAG_T6_OPTIONS);
                if (field != null) {
                    t6Options = var1_1.getIntValue();
                }
                if (bl = (t6Options & 2) != 0) {
                    throw new ImagingException("T.6 compression with the uncompressed mode extension is not yet supported");
                }
                return T4AndT6Compression.decompressT6(compressedOrdered, tileWidth, tileHeight);
            }
            case 5: {
                ByteArrayInputStream is = new ByteArrayInputStream(compressedOrdered);
                return new MyLzwDecompressor(8, ByteOrder.BIG_ENDIAN, true).decompress(is, expectedSize);
            }
            case 32773: {
                return PackBits.decompress(compressedOrdered, expectedSize);
            }
            case 8: 
            case 32946: {
                void var3_5;
                void var1_1;
                return ZlibDeflate.decompress((byte[])var1_1, (int)var3_5);
            }
        }
        throw new ImagingException("Tiff: unknown/unsupported compression: " + (int)var2_4);
    }

    final void getSamplesAsBytes(BitInputStream bis, int[] result) throws IOException {
        for (int i = 0; i < this.bitsPerSample.length; ++i) {
            int bits = this.bitsPerSample[i];
            int sample = bis.readBits(bits);
            if (bits < 8) {
                int sign = sample & 1;
                sample <<= 8 - bits;
                if (sign > 0) {
                    sample |= (1 << 8 - bits) - 1;
                }
            } else if (bits > 8) {
                sample >>= bits - 8;
            }
            result[i] = sample;
        }
    }

    protected final boolean isHomogenous(int size) {
        int[] nArray = this.bitsPerSample;
        int n = this.bitsPerSample.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 8) continue;
            return false;
        }
        return true;
    }

    public abstract ImageBuilder readImageData(Rectangle var1, boolean var2, boolean var3) throws IOException, ImagingException;

    protected final void resetPredictor() {
        Arrays.fill(this.last, 0);
    }

    /*
     * WARNING - void declaration
     */
    protected final int[] unpackFloatingPointSamples(int width, int height, int scanSize, byte[] bytes, int bitsPerPixel, ByteOrder byteOrder) throws ImagingException {
        void var2_4;
        int i;
        int index;
        int k;
        int iPlane;
        int bitsPerSample = bitsPerPixel / this.samplesPerPixel;
        int bytesPerSample = bitsPerSample / 8;
        int bytesPerScan = scanSize * this.samplesPerPixel * bytesPerSample;
        int nBytes = bytesPerScan * height;
        int length = bytes.length < nBytes ? nBytes / bytesPerScan : height;
        int[] samples = Allocator.intArray(scanSize * this.samplesPerPixel * height);
        if (this.predictor == 3) {
            int bytesInRow;
            if (bitsPerPixel / this.samplesPerPixel != 32) {
                throw new ImagingException("Imaging does not yet support floating-point data with predictor type 3 for " + bitsPerPixel + " bits per sample");
            }
            if (this.planarConfiguration == TiffPlanarConfiguration.CHUNKY) {
                bytesInRow = scanSize * 4 * this.samplesPerPixel;
                for (int i2 = 0; i2 < length; ++i2) {
                    int aOffset = i2 * bytesInRow;
                    int bOffset = aOffset + scanSize * this.samplesPerPixel;
                    int cOffset = bOffset + scanSize * this.samplesPerPixel;
                    int dOffset = cOffset + scanSize * this.samplesPerPixel;
                    for (int j = 1; j < bytesInRow; ++j) {
                        int n = aOffset + j;
                        bytes[n] = (byte)(bytes[n] + bytes[aOffset + j - 1]);
                    }
                    int index2 = i2 * scanSize;
                    for (int j = 0; j < width * this.samplesPerPixel; ++j) {
                        byte a = bytes[aOffset + j];
                        byte b = bytes[bOffset + j];
                        byte c = bytes[cOffset + j];
                        byte d = bytes[dOffset + j];
                        samples[index2++] = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
                    }
                }
            } else {
                bytesInRow = scanSize * 4;
                for (iPlane = 0; iPlane < this.samplesPerPixel; ++iPlane) {
                    int planarIntOffset = iPlane * length * scanSize;
                    int planarByteOffset = planarIntOffset * 4;
                    for (int i3 = 0; i3 < length; ++i3) {
                        int aOffset = i3 * bytesInRow + planarByteOffset;
                        int bOffset = aOffset + scanSize;
                        int cOffset = bOffset + scanSize;
                        int dOffset = cOffset + scanSize;
                        for (int j = 1; j < bytesInRow; ++j) {
                            int n = aOffset + j;
                            bytes[n] = (byte)(bytes[n] + bytes[aOffset + j - 1]);
                        }
                        int index3 = planarIntOffset + i3 * scanSize;
                        for (int j = 0; j < width; ++j) {
                            byte a = bytes[aOffset + j];
                            byte b = bytes[bOffset + j];
                            byte c = bytes[cOffset + j];
                            byte d = bytes[dOffset + j];
                            samples[index3++] = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
                        }
                    }
                }
            }
            return samples;
        }
        if (iPlane == 64) {
            k = 0;
            index = 0;
            for (i = 0; i < length; ++i) {
                for (int j = 0; j < scanSize; ++j) {
                    void var1_2;
                    long b0 = (long)bytes[k++] & 0xFFL;
                    long b1 = (long)bytes[k++] & 0xFFL;
                    long b2 = (long)bytes[k++] & 0xFFL;
                    long b3 = (long)bytes[k++] & 0xFFL;
                    long b4 = (long)bytes[k++] & 0xFFL;
                    long b5 = (long)bytes[k++] & 0xFFL;
                    long b6 = (long)bytes[k++] & 0xFFL;
                    long b7 = (long)bytes[k++] & 0xFFL;
                    long sbits = byteOrder == ByteOrder.LITTLE_ENDIAN ? b7 << 56 | b6 << 48 | b5 << 40 | b4 << 32 | b3 << 24 | b2 << 16 | b1 << 8 | b0 : b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
                    float f = (float)Double.longBitsToDouble(sbits);
                    samples[index++] = Float.floatToRawIntBits((float)var1_2);
                }
            }
        } else if (index == 32) {
            k = 0;
            index = 0;
            for (i = 0; i < length; ++i) {
                for (int j = 0; j < scanSize * this.samplesPerPixel; ++j) {
                    int b0 = bytes[k++] & 0xFF;
                    int b1 = bytes[k++] & 0xFF;
                    int b2 = bytes[k++] & 0xFF;
                    int b3 = bytes[k++] & 0xFF;
                    int sbits = byteOrder == ByteOrder.LITTLE_ENDIAN ? b3 << 24 | b2 << 16 | b1 << 8 | b0 : b0 << 24 | b1 << 16 | b2 << 8 | b3;
                    samples[index++] = sbits;
                }
            }
        } else {
            void var5_7;
            throw new ImagingException("Imaging does not support floating-point samples with " + (int)var5_7 + " bits per sample");
        }
        return var2_4;
    }
}

