/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.DataInterpreterJpeg;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderStrips
extends ImageDataReader {
    private final int bitsPerPixel;
    private final int compression;
    private final int rowsPerStrip;
    private final TiffPlanarConfiguration planarConfiguration;
    private final ByteOrder byteOrder;
    private int x;
    private int y;
    private final AbstractTiffImageData.Strips imageData;

    /*
     * WARNING - void declaration
     */
    public DataReaderStrips(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int sampleFormat, int width, int height, int compression, TiffPlanarConfiguration planarConfiguration, ByteOrder byteOrder, int rowsPerStrip, AbstractTiffImageData.Strips imageData) {
        super((TiffDirectory)var1_1, (PhotometricInterpreter)var2_2, bitsPerSample, predictor, samplesPerPixel, sampleFormat, width, height, planarConfiguration);
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitsPerPixel = var3_3;
        this.compression = compression;
        this.rowsPerStrip = rowsPerStrip;
        this.planarConfiguration = planarConfiguration;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    /*
     * WARNING - void declaration
     */
    private void interpretStrip(ImageBuilder imageBuilder, byte[] bytes, int pixelsPerStrip, int yLimit) throws ImagingException, IOException {
        void var2_2;
        int i1;
        if (this.y >= yLimit) {
            return;
        }
        if (this.sampleFormat == 3) {
            int k = 0;
            int nRows = pixelsPerStrip / this.width;
            if (this.y + nRows > yLimit) {
                nRows = yLimit - this.y;
            }
            int i0 = this.y;
            int i12 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            int[] samples = new int[1];
            DataReaderStrips dataReaderStrips = this;
            int[] b = dataReaderStrips.unpackFloatingPointSamples(dataReaderStrips.width, i12 - i0, this.width, bytes, this.bitsPerPixel, this.byteOrder);
            for (int i = i0; i < i12; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    samples[0] = b[k];
                    k += this.samplesPerPixel;
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, j, i);
                }
            }
            return;
        }
        boolean allSamplesAreOneByte = this.isHomogenous(8);
        if (this.predictor != 2 && this.bitsPerPixel == 8 && allSamplesAreOneByte) {
            void b;
            void samples;
            int k = 0;
            void nRows = samples / this.width;
            if (this.y + nRows > b) {
                nRows = b - this.y;
            }
            int i0 = this.y;
            i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            int[] samples2 = new int[1];
            for (int i = i0; i < i1; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    samples2[0] = bytes[k++] & 0xFF;
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples2, j, i);
                }
            }
            return;
        }
        if ((this.bitsPerPixel == 24 || this.bitsPerPixel == 32) && allSamplesAreOneByte && this.photometricInterpreter instanceof PhotometricInterpreterRgb) {
            int j;
            int i;
            void samples2;
            int k = 0;
            void nRows = i1 / this.width;
            if (this.y + nRows > samples2) {
                nRows = samples2 - this.y;
            }
            int i0 = this.y;
            i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            if (this.predictor == 2) {
                DataReaderStrips.applyPredictorToBlock(this.width, (int)nRows, this.samplesPerPixel, bytes);
            }
            if (this.bitsPerPixel == 24) {
                for (i = i0; i < i1; ++i) {
                    j = 0;
                    while (j < this.width) {
                        int rgb = 0xFF000000 | bytes[k] << 16 | (bytes[k + 1] & 0xFF) << 8 | bytes[k + 2] & 0xFF;
                        imageBuilder.setRgb(j, i, rgb);
                        ++j;
                        k += 3;
                    }
                }
                return;
            }
            for (i = i0; i < i1; ++i) {
                j = 0;
                while (j < this.width) {
                    int rgb = (bytes[k] & 0xFF) << 16 | (bytes[k + 1] & 0xFF) << 8 | bytes[k + 2] & 0xFF | bytes[k + 3] << 24;
                    imageBuilder.setRgb(j, i, rgb);
                    ++j;
                    k += 4;
                }
            }
            return;
        }
        try (BitInputStream bis = new BitInputStream(new ByteArrayInputStream((byte[])var2_2), this.byteOrder);){
            int n;
            int[] samples = Allocator.intArray(this.bitsPerSampleLength);
            this.resetPredictor();
            for (int i = 0; i < n; ++i) {
                void var4_5;
                this.getSamplesAsBytes(bis, samples);
                if (this.x < this.width) {
                    samples = this.applyPredictor(samples);
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, this.x, this.y);
                }
                ++this.x;
                if (this.x < this.width) continue;
                this.x = 0;
                this.resetPredictor();
                ++this.y;
                bis.flushCache();
                if (this.y >= var4_5) break;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImageBuilder readImageData(Rectangle subImageSpecification, boolean hasAlpha, boolean isAlphaPreMultiplied) throws IOException, ImagingException {
        void var1_1;
        void var2_3;
        Rectangle subImage;
        if (subImageSpecification == null) {
            subImage = new Rectangle(0, 0, this.width, this.height);
        }
        int strip0 = subImage.y / this.rowsPerStrip;
        int strip1 = (subImage.y + subImage.height - 1) / this.rowsPerStrip;
        int workingHeight = (strip1 - strip0 + 1) * this.rowsPerStrip;
        int y0 = strip0 * this.rowsPerStrip;
        int yLimit = subImage.y - y0 + subImage.height;
        ImageBuilder workingBuilder = new ImageBuilder(this.width, workingHeight, hasAlpha, isAlphaPreMultiplied);
        isAlphaPreMultiplied = this.planarConfiguration != TiffPlanarConfiguration.PLANAR;
        if (isAlphaPreMultiplied) {
            for (int strip = strip0; strip <= strip1; ++strip) {
                long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
                long l = (long)this.height - (long)strip * rowsPerStripLong;
                long rowsInThisStrip = Math.min(l, rowsPerStripLong);
                long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
                long bytesPerStrip = rowsInThisStrip * bytesPerRow;
                long pixelsPerStrip = rowsInThisStrip * (long)this.width;
                byte[] compressed = this.imageData.getImageData(strip).getData();
                if (this.compression == 7) {
                    strip0 = strip * this.rowsPerStrip;
                    int yWork = strip0 - y0;
                    DataInterpreterJpeg.intepretBlock(this.directory, workingBuilder, 0, yWork, this.width, (int)rowsInThisStrip, compressed);
                    continue;
                }
                byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
                this.interpretStrip(workingBuilder, decompressed, (int)pixelsPerStrip, yLimit);
            }
        } else {
            if (this.compression == 7) {
                throw new ImagingException("TIFF file in non-supported configuration: JPEG compression used in planar configuration.");
            }
            int nStripsInPlane = this.imageData.getImageDataLength() / 3;
            for (void strip = decompressed; strip <= strip1; ++strip) {
                long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
                long l = (long)this.height - (long)strip * rowsPerStripLong;
                long rowsInThisStrip = Math.min(l, rowsPerStripLong);
                long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
                long bytesPerStrip = rowsInThisStrip * bytesPerRow;
                long pixelsPerStrip = rowsInThisStrip * (long)this.width;
                byte[] b = Allocator.byteArray((int)bytesPerStrip);
                for (int iPlane = 0; iPlane < 3; ++iPlane) {
                    int planeStrip = iPlane * nStripsInPlane + strip;
                    byte[] compressed = this.imageData.getImageData(planeStrip).getData();
                    byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
                    int index = iPlane;
                    byte[] byArray = decompressed;
                    int n = decompressed.length;
                    for (int i = 0; i < n; ++i) {
                        byte element;
                        b[index] = element = byArray[i];
                        index += 3;
                    }
                }
                this.interpretStrip(workingBuilder, b, (int)pixelsPerStrip, this.height);
            }
        }
        if (subImage.x == 0 && subImage.y == y0 && subImage.width == this.width && subImage.height == workingHeight) {
            return workingBuilder;
        }
        return var2_3.getSubset(subImage.x, subImage.y - y0, subImage.width, var1_1.height);
    }
}

