/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.psd.ImageResourceBlock;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.PsdImageContents;
import org.apache.commons.imaging.formats.psd.PsdImagingParameters;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserBitmap;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserCmyk;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserGrayscale;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserIndexed;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserLab;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParserRgb;
import org.apache.commons.imaging.formats.psd.datareaders.CompressedDataReader;
import org.apache.commons.imaging.formats.psd.datareaders.UncompressedDataReader;

public final class PsdImageParser
extends AbstractImageParser<PsdImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.PSD.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.PSD.getExtensions();

    @Override
    protected final String[] getAcceptedExtensions() {
        return (String[])ACCEPTED_EXTENSIONS.clone();
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.PSD};
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    private BufferedImage getBufferedImage(ByteSource byteSource, PsdImagingParameters params) throws ImagingException, IOException {
        void var2_3;
        PsdImageContents imageContents = this.readImageContents(byteSource);
        PsdHeaderInfo psdHeaderInfo = imageContents.header;
        if (psdHeaderInfo == null) {
            throw new ImagingException("PSD: Couldn't read Header");
        }
        this.readImageResourceBlocks(byteSource, null, -1);
        int width = psdHeaderInfo.columns;
        int n = psdHeaderInfo.rows;
        BufferedImage result22 = PsdImageParser.getBufferedImageFactory(params).getColorBufferedImage(width, n, false);
        switch (imageContents.header.mode) {
            case 0: {
                DataParserBitmap dataParserBitmap = new DataParserBitmap();
                break;
            }
            case 1: 
            case 8: {
                DataParserGrayscale dataParserGrayscale = new DataParserGrayscale();
                break;
            }
            case 3: {
                DataParserRgb dataParserRgb = new DataParserRgb();
                break;
            }
            case 4: {
                DataParserCmyk dataParserCmyk = new DataParserCmyk();
                break;
            }
            case 9: {
                DataParserLab dataParserLab = new DataParserLab();
                break;
            }
            case 2: {
                byte[] byArray = this.getData(byteSource, 1);
                DataParserIndexed dataParserIndexed = new DataParserIndexed(byArray);
                break;
            }
            default: {
                throw new ImagingException("Unknown Mode: " + imageContents.header.mode);
            }
        }
        switch (imageContents.compression) {
            case 0: {
                void var4_15;
                UncompressedDataReader uncompressedDataReader = new UncompressedDataReader((DataParser)var4_15);
                break;
            }
            case 1: {
                void var4_15;
                CompressedDataReader compressedDataReader = new CompressedDataReader((DataParser)var4_15);
                break;
            }
            default: {
                throw new ImagingException("Unknown Compression: " + imageContents.compression);
            }
        }
        InputStream is = this.getInputStream(byteSource, 4);
        try {
            void var3_5;
            void var4_18;
            var4_18.readData$7f865488(is, result22, (PsdImageContents)var3_5, this);
            if (is == null) return var2_3;
        }
        catch (Throwable result22) {
            if (is == null) throw result22;
            try {
                void var1_1;
                var1_1.close();
                throw result22;
            }
            catch (Throwable throwable) {
                result22.addSuppressed(throwable);
            }
            throw result22;
        }
        is.close();
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getData(ByteSource byteSource, int section) throws ImagingException, IOException {
        byte[] byArray;
        block5: {
            InputStream is = byteSource.getInputStream();
            try {
                void var2_2;
                BinaryFunctions.skipBytes(is, 26L);
                int colorModeDataLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
                byArray = BinaryFunctions.readBytes("ColorModeData", is, (int)var2_2, "Not a Valid PSD File");
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStream(ByteSource byteSource, int section) throws ImagingException, IOException {
        void var1_1;
        void var2_3;
        void var3_5;
        InputStream is;
        block10: {
            int imageResourcesLength;
            block9: {
                int colorModeDataLength;
                block8: {
                    block7: {
                        is = byteSource.getInputStream();
                        if (section != 0) break block7;
                        return is;
                    }
                    BinaryFunctions.skipBytes(is, 26L);
                    colorModeDataLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
                    if (section != 1) break block8;
                    return is;
                }
                BinaryFunctions.skipBytes(is, colorModeDataLength);
                imageResourcesLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
                if (section != 2) break block9;
                return is;
            }
            BinaryFunctions.skipBytes(is, imageResourcesLength);
            int layerAndMaskDataLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
            if (section != 3) break block10;
            return is;
        }
        BinaryFunctions.skipBytes(is, (long)var3_5);
        BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        if (section == 4) {
            return is;
        }
        if (is == null) throw new ImagingException("getInputStream: Unknown Section: " + (int)var2_3);
        var1_1.close();
        throw new ImagingException("getInputStream: Unknown Section: " + (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private PsdHeaderInfo readHeader(InputStream is) throws ImagingException, IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        BinaryFunctions.readAndVerifyBytes(is, new byte[]{56, 66, 80, 83}, "Not a Valid PSD File");
        int version = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        byte[] reserved = BinaryFunctions.readBytes("Reserved", is, 6, "Not a Valid PSD File");
        int channels = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        int rows = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        int columns = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        int depth = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        int mode = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        return new PsdHeaderInfo((int)var2_3, (byte[])var3_4, channels, rows, columns, depth, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private PsdImageContents readImageContents(ByteSource byteSource) throws ImagingException, IOException {
        PsdImageContents psdImageContents;
        block5: {
            InputStream is = byteSource.getInputStream();
            try {
                psdImageContents = this.readImageContents(is);
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return psdImageContents;
    }

    /*
     * WARNING - void declaration
     */
    private PsdImageContents readImageContents(InputStream is) throws ImagingException, IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        PsdHeaderInfo header = this.readHeader(is);
        int colorModeDataLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        BinaryFunctions.skipBytes(is, colorModeDataLength);
        int imageResourcesLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        BinaryFunctions.skipBytes(is, imageResourcesLength);
        int layerAndMaskDataLength = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        BinaryFunctions.skipBytes(is, layerAndMaskDataLength);
        int compression = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid PSD File", this.getByteOrder());
        return new PsdImageContents((PsdHeaderInfo)var2_3, (int)var3_4, imageResourcesLength, layerAndMaskDataLength, (int)var1_2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private List<ImageResourceBlock> readImageResourceBlocks(ByteSource byteSource, int[] imageResourceIDs, int maxBlocksToRead) throws ImagingException, IOException {
        Object object;
        InputStream resourceStream;
        InputStream imageStream;
        block19: {
            block18: {
                imageStream = byteSource.getInputStream();
                resourceStream = this.getInputStream(byteSource, 2);
                PsdImageContents imageContents = this.readImageContents(imageStream);
                byte[] ImageResources = BinaryFunctions.readBytes("ImageResources", resourceStream, ((PsdImageContents)object).imageResourcesLength, "Not a Valid PSD File");
                int n = -1;
                Object var5_11 = null;
                Object object2 = ImageResources;
                object = this;
                int n2 = ((byte[])object2).length;
                object2 = new ByteArrayInputStream((byte[])object2);
                ArrayList<ImageResourceBlock> arrayList = new ArrayList<ImageResourceBlock>();
                while (n2 > 0) {
                    boolean bl;
                    byte[] byArray;
                    byte[] byArray2;
                    int n3;
                    block17: {
                        BinaryFunctions.readAndVerifyBytes((InputStream)object2, new byte[]{56, 66, 73, 77}, "Not a Valid PSD File");
                        n2 -= 4;
                        n3 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object2, "Not a Valid PSD File", ((BinaryFileParser)object).getByteOrder());
                        n2 -= 2;
                        int n4 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid PSD File");
                        --n2;
                        byArray2 = BinaryFunctions.readBytes("NameData", (InputStream)object2, n4, "Not a Valid PSD File");
                        n2 -= n4;
                        if ((n4 + 1) % 2 != 0) {
                            BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid PSD File");
                            --n2;
                        }
                        n4 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object2, "Not a Valid PSD File", ((BinaryFileParser)object).getByteOrder());
                        n2 -= 4;
                        byArray = BinaryFunctions.readBytes("Data", (InputStream)object2, n4, "Not a Valid PSD File");
                        n2 -= n4;
                        if (n4 % 2 != 0) {
                            BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid PSD File");
                            --n2;
                        }
                        Object var13_18 = var5_11;
                        n4 = n3;
                        if (var13_18 == null) {
                            bl = true;
                        } else {
                            for (void var16_21 : var13_18) {
                                if (n4 != var16_21) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    arrayList.add(new ImageResourceBlock(n3, byArray2, byArray));
                    if (n < 0 || arrayList.size() < n) continue;
                }
                object = arrayList;
                if (resourceStream == null) break block18;
                resourceStream.close();
            }
            if (imageStream == null) break block19;
            imageStream.close();
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            void var1_1;
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (imageStream != null) {
                        try {
                            void var2_3;
                            var2_3.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }
}

