/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

final class PpmFileInfo
extends AbstractFileInfo {
    private final int max;
    private final float scale;
    private final int bytesPerSample;

    /*
     * WARNING - void declaration
     */
    PpmFileInfo(int width, int height, boolean rawBits, int max) throws ImagingException {
        super((int)var1_1, (int)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        if (max <= 0) {
            throw new ImagingException("PPM maxVal " + max + " is out of range [1;65535]");
        }
        if (max <= 255) {
            this.scale = 255.0f;
            this.bytesPerSample = 1;
        } else if (max <= 65535) {
            this.scale = 65535.0f;
            this.bytesPerSample = 2;
        } else {
            throw new ImagingException("PPM maxVal " + max + " is out of range [1;65535]");
        }
        this.max = max;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(InputStream is) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int red = PpmFileInfo.readSample(is, this.bytesPerSample);
        int green = PpmFileInfo.readSample(is, this.bytesPerSample);
        int blue = PpmFileInfo.readSample(is, this.bytesPerSample);
        red = PpmFileInfo.scaleSample(red, this.scale, this.max);
        green = PpmFileInfo.scaleSample(green, this.scale, this.max);
        blue = PpmFileInfo.scaleSample(blue, this.scale, this.max);
        return 0xFF000000 | (0xFF & var2_3) << 16 | (0xFF & var3_4) << 8 | (0xFF & var1_2) << 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(WhiteSpaceReader wsr) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int red = Integer.parseInt(wsr.readtoWhiteSpace());
        int green = Integer.parseInt(wsr.readtoWhiteSpace());
        int blue = Integer.parseInt(wsr.readtoWhiteSpace());
        red = PpmFileInfo.scaleSample(red, this.scale, this.max);
        green = PpmFileInfo.scaleSample(green, this.scale, this.max);
        blue = PpmFileInfo.scaleSample(blue, this.scale, this.max);
        return 0xFF000000 | (0xFF & var2_3) << 16 | (0xFF & var3_4) << 8 | (0xFF & var1_2) << 0;
    }

    @Override
    public final boolean hasAlpha() {
        return false;
    }
}

