/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.PamFileInfo;
import org.apache.commons.imaging.formats.pnm.PbmFileInfo;
import org.apache.commons.imaging.formats.pnm.PgmFileInfo;
import org.apache.commons.imaging.formats.pnm.PnmImagingParameters;
import org.apache.commons.imaging.formats.pnm.PpmFileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

public final class PnmImageParser
extends AbstractImageParser<PnmImagingParameters> {
    private static final ImageFormat[] IMAGE_FORMATS;
    private static final String DEFAULT_EXTENSION;
    private static final String[] ACCEPTED_EXTENSIONS;

    public PnmImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    private static void check(boolean value, String type) throws ImagingException {
        if (!value) {
            void var1_1;
            throw new ImagingException("PAM header has no " + (String)var1_1 + " value");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkFound(int value, String type) throws ImagingException {
        void var2_2;
        PnmImageParser.check(value != -1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String checkNextTokens(StringTokenizer tokenizer, String type) throws ImagingException {
        void var1_1;
        void var2_2;
        PnmImageParser.check(tokenizer.hasMoreTokens(), (String)var2_2);
        return var1_1.nextToken();
    }

    /*
     * WARNING - void declaration
     */
    private int checkNextTokensAsInt(StringTokenizer tokenizer, String type) throws ImagingException {
        void var2_2;
        void var1_1;
        return Integer.parseInt(this.checkNextTokens((StringTokenizer)var1_1, (String)var2_2));
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return (String[])ACCEPTED_EXTENSIONS.clone();
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return (ImageFormat[])IMAGE_FORMATS.clone();
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage getBufferedImage$7ffbeca3(ByteSource byteSource) throws ImagingException, IOException {
        BufferedImage bufferedImage;
        block11: {
            InputStream is = byteSource.getInputStream();
            try {
                void var3_5;
                AbstractFileInfo info = this.readHeader(is);
                int width = info.width;
                int height = info.height;
                boolean hasAlpha = info.hasAlpha();
                ImageBuilder imageBuilder = new ImageBuilder(width, height, hasAlpha);
                InputStream inputStream = is;
                ImageBuilder imageBuilder2 = imageBuilder;
                if (!((AbstractFileInfo)((Object)bufferedImage)).rawBits) {
                    WhiteSpaceReader whiteSpaceReader = new WhiteSpaceReader(inputStream);
                    for (int i = 0; i < ((AbstractFileInfo)((Object)bufferedImage)).height; ++i) {
                        for (int j = 0; j < ((AbstractFileInfo)((Object)bufferedImage)).width; ++j) {
                            int n = ((AbstractFileInfo)((Object)bufferedImage)).getRgb(whiteSpaceReader);
                            imageBuilder2.setRgb(j, i, n);
                        }
                        ((AbstractFileInfo)((Object)bufferedImage)).newline();
                    }
                } else {
                    for (int i = 0; i < ((AbstractFileInfo)((Object)bufferedImage)).height; ++i) {
                        for (int j = 0; j < ((AbstractFileInfo)((Object)bufferedImage)).width; ++j) {
                            int n = ((AbstractFileInfo)((Object)bufferedImage)).getRgb(inputStream);
                            imageBuilder2.setRgb(j, i, n);
                        }
                        ((AbstractFileInfo)((Object)bufferedImage)).newline();
                    }
                }
                bufferedImage = var3_5.getBufferedImage();
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFileInfo readHeader(InputStream inputStream) throws ImagingException, IOException {
        int max;
        int width;
        byte identifier1 = BinaryFunctions.readByte$74534d56(inputStream, "Not a Valid PNM File");
        byte identifier2 = BinaryFunctions.readByte$74534d56(inputStream, "Not a Valid PNM File");
        if (identifier1 != 80) {
            throw new ImagingException("PNM file has invalid prefix byte 1");
        }
        WhiteSpaceReader wsReader = new WhiteSpaceReader(inputStream);
        if (identifier2 == 49 || identifier2 == 52 || identifier2 == 50 || identifier2 == 53 || identifier2 == 51 || identifier2 == 54) {
            int height;
            try {
                width = Integer.parseInt(wsReader.readtoWhiteSpace());
            }
            catch (NumberFormatException e) {
                throw new ImagingException("Invalid width specified.", e);
            }
            try {
                height = Integer.parseInt(wsReader.readtoWhiteSpace());
            }
            catch (NumberFormatException e) {
                throw new ImagingException("Invalid height specified.", e);
            }
            switch (e) {
                case 49: {
                    return new PbmFileInfo(width, height, false);
                }
                case 52: {
                    return new PbmFileInfo(width, height, true);
                }
                case 50: {
                    int maxgray = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PgmFileInfo(width, height, false, maxgray);
                }
                case 53: {
                    int maxgray = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PgmFileInfo(width, height, true, maxgray);
                }
                case 51: {
                    max = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PpmFileInfo(width, height, false, max);
                }
                case 54: {
                    max = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PpmFileInfo(width, height, true, max);
                }
            }
        } else if (max == 55) {
            void var3_3;
            void var2_2;
            String line;
            width = -1;
            int height = -1;
            int depth = -1;
            int maxVal = -1;
            StringBuilder tupleType = new StringBuilder();
            wsReader.readLine();
            while ((line = wsReader.readLine()) != null) {
                String type;
                if ((line = line.trim()).charAt(0) == '#') continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ", false);
                switch (type = tokenizer.nextToken()) {
                    case "WIDTH": {
                        width = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "HEIGHT": {
                        height = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "DEPTH": {
                        depth = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "MAXVAL": {
                        maxVal = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "TUPLTYPE": {
                        tupleType.append(this.checkNextTokens(tokenizer, type));
                        break;
                    }
                    case "ENDHDR": {
                        break;
                    }
                    default: {
                        throw new ImagingException("Invalid PAM file header type " + type);
                    }
                }
                if (!"ENDHDR".equals(type)) continue;
            }
            this.checkFound(width, "WIDTH");
            this.checkFound(height, "HEIGHT");
            this.checkFound(depth, "DEPTH");
            this.checkFound(maxVal, "MAXVAL");
            PnmImageParser.check(tupleType.length() > 0, "TUPLTYPE");
            return new PamFileInfo((int)var2_2, height, (int)var3_3, maxVal, tupleType.toString());
        }
        throw new ImagingException("PNM file has invalid prefix byte 2");
    }

    static {
        DEFAULT_EXTENSION = ImageFormats.PNM.getDefaultExtension();
        IMAGE_FORMATS = new ImageFormat[]{ImageFormats.PAM, ImageFormats.PBM, ImageFormats.PGM, ImageFormats.PNM, ImageFormats.PPM};
        ACCEPTED_EXTENSIONS = (String[])Stream.of(IMAGE_FORMATS).map(ImageFormat::getDefaultExtension).toArray(String[]::new);
    }
}

