/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

final class PgmFileInfo
extends AbstractFileInfo {
    private final int max;
    private final float scale;
    private final int bytesPerSample;

    /*
     * WARNING - void declaration
     */
    PgmFileInfo(int width, int height, boolean rawbits, int max) throws ImagingException {
        super((int)var1_1, (int)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        if (max <= 0) {
            throw new ImagingException("PGM maxVal " + max + " is out of range [1;65535]");
        }
        if (max <= 255) {
            this.scale = 255.0f;
            this.bytesPerSample = 1;
        } else if (max <= 65535) {
            this.scale = 65535.0f;
            this.bytesPerSample = 2;
        } else {
            throw new ImagingException("PGM maxVal " + max + " is out of range [1;65535]");
        }
        this.max = max;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(InputStream is2) throws IOException {
        void var1_2;
        int is2 = PgmFileInfo.readSample(is2, this.bytesPerSample);
        int sample = PgmFileInfo.scaleSample(is2, this.scale, this.max);
        return 0xFF000000 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & var1_2) << 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(WhiteSpaceReader wsr2) throws IOException {
        void var1_2;
        int wsr2 = Integer.parseInt(wsr2.readtoWhiteSpace());
        int sample = PgmFileInfo.scaleSample(wsr2, this.scale, this.max);
        return 0xFF000000 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & var1_2) << 0;
    }

    @Override
    public final boolean hasAlpha() {
        return false;
    }
}

