/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public final class PngChunkScal
extends PngChunk {
    private final double unitsPerPixelXAxis;
    private final double unitsPerPixelYAxis;
    private final int unitSpecifier;

    /*
     * WARNING - void declaration
     */
    public PngChunkScal(int length, int chunkType2, int crc, byte[] bytes) throws ImagingException {
        super(length, chunkType2, crc, bytes);
        void var1_2;
        void var2_5;
        void var3_7;
        this.unitSpecifier = bytes[0];
        PngChunkScal chunkType2 = this;
        if (chunkType2.unitSpecifier != 1) {
            chunkType2 = this;
            if (chunkType2.unitSpecifier != 2) {
                chunkType2 = this;
                throw new ImagingException("PNG sCAL invalid unit specifier: " + chunkType2.unitSpecifier);
            }
        }
        int separator = BinaryFunctions.findNull(bytes, "PNG sCAL x and y axis value separator not found.");
        String xStr = new String(bytes, 1, separator - 1, StandardCharsets.ISO_8859_1);
        this.unitsPerPixelXAxis = PngChunkScal.toDouble((String)var3_7);
        int yIndex = separator + 1;
        if (yIndex >= length) {
            throw new ImagingException("PNG sCAL chunk missing the y axis value.");
        }
        String yStr = new String(bytes, yIndex, length - var2_5, StandardCharsets.ISO_8859_1);
        this.unitsPerPixelYAxis = PngChunkScal.toDouble((String)var1_2);
    }

    private static double toDouble(String str) throws ImagingException {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            throw new ImagingException("PNG sCAL error reading axis value - " + string);
        }
    }
}

