/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;
import org.apache.commons.io.IOUtils;

public class PngChunkIccp
extends PngChunk {
    private static final Logger LOGGER = Logger.getLogger(PngChunkIccp.class.getName());
    private final String profileName;
    private final int compressionMethod;
    private final byte[] compressedProfile;
    private final byte[] uncompressedProfile;

    /*
     * WARNING - void declaration
     */
    public PngChunkIccp(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, (int)var3_5, bytes);
        void var1_1;
        void var3_5;
        int index = BinaryFunctions.findNull(bytes, "PngChunkIccp: No Profile Name");
        byte[] nameBytes = Arrays.copyOf(bytes, index);
        this.profileName = new String(nameBytes, StandardCharsets.ISO_8859_1);
        this.compressionMethod = bytes[index + 1];
        int compressedProfileLength = bytes.length - (index + 1 + 1);
        this.compressedProfile = Allocator.byteArray(compressedProfileLength);
        System.arraycopy(bytes, (int)(var1_1 + true + true), this.compressedProfile, 0, compressedProfileLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            void var2_4;
            LOGGER.finest("ProfileName: " + this.profileName);
            LOGGER.finest("ProfileName.length(): " + this.profileName.length());
            LOGGER.finest("CompressionMethod: " + this.compressionMethod);
            LOGGER.finest("CompressedProfileLength: " + (int)var2_4);
            LOGGER.finest("bytes.length: " + bytes.length);
        }
        this.uncompressedProfile = IOUtils.toByteArray((InputStream)new InflaterInputStream(new ByteArrayInputStream(this.compressedProfile)));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("UncompressedProfile: " + bytes.length);
        }
    }

    public final byte[] getUncompressedProfile() {
        return (byte[])this.uncompressedProfile.clone();
    }
}

