/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.png.AbstractScanExpediter;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.transparencyfilters.AbstractTransparencyFilter;

final class ScanExpediterInterlaced
extends AbstractScanExpediter {
    private static final int[] STARTING_ROW = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] STARTING_COL = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] ROW_INCREMENT = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] COL_INCREMENT = new int[]{8, 8, 4, 4, 2, 2, 1};

    /*
     * WARNING - void declaration
     */
    ScanExpediterInterlaced(int width, int height, InputStream is, BufferedImage bi, PngColorType pngColorType, int bitDepth, int bitsPerPixel, PngChunkPlte pngChunkPLTE, GammaCorrection gammaCorrection, AbstractTransparencyFilter abstractTransparencyFilter) {
        super((int)var1_1, (int)var2_2, (InputStream)var3_3, bi, pngColorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, abstractTransparencyFilter);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final void drive() throws ImagingException, IOException {
        for (int pass = 1; pass <= 7; ++pass) {
            byte[] prev = null;
            for (int y = STARTING_ROW[pass - 1]; y < this.height; y += ROW_INCREMENT[pass - 1]) {
                byte[] unfiltered;
                int x;
                int pixelIndexInScanline = 0;
                if (x >= this.width) continue;
                int columnsInRow = 1 + (this.width - STARTING_COL[pass - 1] - 1) / COL_INCREMENT[pass - 1];
                int n = this.bitsPerPixel * columnsInRow;
                columnsInRow = n;
                columnsInRow = n;
                int pixelBytesPerScanLine = (n + 7) / 8;
                ScanExpediterInterlaced scanExpediterInterlaced = this;
                prev = unfiltered = scanExpediterInterlaced.getNextScanline(scanExpediterInterlaced.is, pixelBytesPerScanLine, prev, this.bytesPerPixel);
                BitParser fBitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
                for (x = STARTING_COL[pass - 1]; x < this.width; x += COL_INCREMENT[pass - 1]) {
                    int n2 = pixelIndexInScanline++;
                    BitParser bitParser = fBitParser;
                    BufferedImage bufferedImage = this.bi;
                    int n3 = y;
                    int n4 = x;
                    ScanExpediterInterlaced scanExpediterInterlaced2 = this;
                    int n5 = scanExpediterInterlaced2.getRgb(bitParser, n2);
                    bufferedImage.setRGB(n4, n3, n5);
                }
            }
        }
    }
}

