/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ColorTools;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.AbstractScanExpediter;
import org.apache.commons.imaging.formats.png.ChunkType;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.PngConstants;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.png.ScanExpediterInterlaced;
import org.apache.commons.imaging.formats.png.ScanExpediterSimple;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;
import org.apache.commons.imaging.formats.png.chunks.PngChunkGama;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIccp;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIdat;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIhdr;
import org.apache.commons.imaging.formats.png.chunks.PngChunkItxt;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPhys;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.chunks.PngChunkScal;
import org.apache.commons.imaging.formats.png.chunks.PngChunkText;
import org.apache.commons.imaging.formats.png.chunks.PngChunkZtxt;
import org.apache.commons.imaging.formats.png.transparencyfilters.AbstractTransparencyFilter;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterGrayscale;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterIndexedColor;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilterTrueColor;
import org.apache.commons.imaging.icc.IccProfileParser;

public class PngImageParser
extends AbstractImageParser<PngImagingParameters> {
    private static final Logger LOGGER = Logger.getLogger(PngImageParser.class.getName());
    private static final String DEFAULT_EXTENSION = ImageFormats.PNG.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.PNG.getExtensions();

    /*
     * WARNING - void declaration
     */
    private static List<PngChunk> filterChunks(List<PngChunk> chunks, ChunkType type) {
        void var2_2;
        Iterator<PngChunk> iterator;
        ArrayList<void> result = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            PngChunk chunk = (PngChunk)iterator.next();
            if (chunk.getChunkType() != type.value) continue;
            result.add(var3_3);
        }
        return var2_2;
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return (String[])ACCEPTED_EXTENSIONS.clone();
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.PNG};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private BufferedImage getBufferedImage(ByteSource byteSource, PngImagingParameters params) throws ImagingException, IOException {
        void var2_4;
        Object object;
        AbstractScanExpediter abstractScanExpediter;
        BufferedImage result;
        PngChunk pngChunk;
        Object object2;
        Object IDATs;
        List<PngChunk> chunks = this.readChunks(byteSource, new ChunkType[]{ChunkType.IHDR, ChunkType.PLTE, ChunkType.IDAT, ChunkType.tRNS, ChunkType.iCCP, ChunkType.gAMA, ChunkType.sRGB}, false);
        if (chunks.isEmpty()) {
            throw new ImagingException("PNG: no chunks");
        }
        List<PngChunk> IHDRs = PngImageParser.filterChunks(chunks, ChunkType.IHDR);
        if (IHDRs.size() != 1) {
            throw new ImagingException("PNG contains more than one Header");
        }
        Object pngChunkIHDR = (PngChunkIhdr)IHDRs.get(0);
        List<PngChunk> PLTEs = PngImageParser.filterChunks(chunks, ChunkType.PLTE);
        if (PLTEs.size() > 1) {
            throw new ImagingException("PNG contains more than one Palette");
        }
        PngChunkPlte pngChunkPLTE = null;
        if (PLTEs.size() == 1) {
            pngChunkPLTE = (PngChunkPlte)PLTEs.get(0);
        }
        if ((IDATs = PngImageParser.filterChunks(chunks, ChunkType.IDAT)).isEmpty()) {
            throw new ImagingException("PNG missing image data");
        }
        Object baos = new ByteArrayOutputStream();
        IDATs = IDATs.iterator();
        while (IDATs.hasNext()) {
            object2 = (PngChunk)IDATs.next();
            PngChunkIdat pngChunkIdat = (PngChunkIdat)object2;
            byte[] bytes = pngChunkIdat.getBytes();
            ((OutputStream)baos).write(bytes);
        }
        byte[] compressed = ((ByteArrayOutputStream)baos).toByteArray();
        BinaryFileParser abstractTransparencyFilter = null;
        List<PngChunk> tRNSs = PngImageParser.filterChunks(chunks, ChunkType.tRNS);
        if (!tRNSs.isEmpty()) {
            AbstractTransparencyFilter abstractTransparencyFilter2;
            PngChunk pngChunktRNS;
            abstractTransparencyFilter = pngChunktRNS = tRNSs.get(0);
            baos = ((PngChunkIhdr)pngChunkIHDR).getPngColorType();
            switch (1.$SwitchMap$org$apache$commons$imaging$formats$png$PngColorType[((Enum)baos).ordinal()]) {
                case 1: {
                    abstractTransparencyFilter2 = new TransparencyFilterGrayscale(abstractTransparencyFilter.getBytes());
                    break;
                }
                case 3: {
                    abstractTransparencyFilter2 = new TransparencyFilterTrueColor(abstractTransparencyFilter.getBytes());
                    break;
                }
                case 4: {
                    abstractTransparencyFilter2 = new TransparencyFilterIndexedColor(abstractTransparencyFilter.getBytes());
                    break;
                }
                default: {
                    throw new ImagingException("Simple Transparency not compatible with ColorType: " + baos);
                }
            }
            abstractTransparencyFilter = abstractTransparencyFilter2;
        }
        ICC_Profile iccProfile = null;
        GammaCorrection gammaCorrection = null;
        List<PngChunk> sRGBs = PngImageParser.filterChunks(chunks, ChunkType.sRGB);
        List<PngChunk> gAMAs = PngImageParser.filterChunks(chunks, ChunkType.gAMA);
        List<PngChunk> iCCPs = PngImageParser.filterChunks(chunks, ChunkType.iCCP);
        if (sRGBs.size() > 1) {
            throw new ImagingException("PNG: unexpected sRGB chunk");
        }
        if (gAMAs.size() > 1) {
            throw new ImagingException("PNG: unexpected gAMA chunk");
        }
        if (iCCPs.size() > 1) {
            throw new ImagingException("PNG: unexpected iCCP chunk");
        }
        if (sRGBs.size() == 1) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("sRGB, no color management necessary.");
            }
        } else if (iCCPs.size() == 1) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("iCCP.");
            }
            pngChunk = (PngChunkIccp)iCCPs.get(0);
            byte[] bytes = pngChunk.getUncompressedProfile();
            try {
                iccProfile = ICC_Profile.getInstance(bytes);
            }
            catch (IllegalArgumentException iae) {
                throw new ImagingException("The image data does not correspond to a valid ICC Profile", iae);
            }
        } else if (gAMAs.size() == 1) {
            double d;
            pngChunk = (PngChunkGama)gAMAs.get(0);
            double gamma = ((PngChunkGama)pngChunk).getGamma();
            double d2 = Math.abs(1.0 - gamma);
            if (d >= 0.5) {
                gammaCorrection = new GammaCorrection(gamma, 1.0);
            }
            if (gammaCorrection != null && pngChunkPLTE != null) {
                pngChunkPLTE.correct(gammaCorrection);
            }
        }
        int width = ((PngChunkIhdr)pngChunkIHDR).getWidth();
        int height = ((PngChunkIhdr)pngChunkIHDR).getHeight();
        PngColorType pngColorType = ((PngChunkIhdr)pngChunkIHDR).getPngColorType();
        int bitDepth = ((PngChunkIhdr)pngChunkIHDR).getBitDepth();
        if (((PngChunkIhdr)pngChunkIHDR).getFilterMethod() != 0) {
            throw new ImagingException("PNG: unknown FilterMethod: " + ((PngChunkIhdr)pngChunkIHDR).getFilterMethod());
        }
        int bitsPerPixel = bitDepth * pngColorType.getSamplesPerPixel();
        boolean hasAlpha = pngColorType.hasAlpha() || abstractTransparencyFilter != null;
        result = pngColorType.isGreyscale() ? PngImageParser.getBufferedImageFactory(params).getGrayscaleBufferedImage(width, height, hasAlpha) : PngImageParser.getBufferedImageFactory(result).getColorBufferedImage(width, height, hasAlpha);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        InflaterInputStream iis = new InflaterInputStream(bais);
        switch (((PngChunkIhdr)pngChunkIHDR).getInterlaceMethod()) {
            case NONE: {
                abstractScanExpediter = new ScanExpediterSimple(width, height, iis, result, pngColorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, (AbstractTransparencyFilter)abstractTransparencyFilter);
                break;
            }
            case ADAM7: {
                abstractScanExpediter = new ScanExpediterInterlaced(width, height, iis, result, pngColorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, (AbstractTransparencyFilter)abstractTransparencyFilter);
                break;
            }
            default: {
                throw new ImagingException("Unknown InterlaceMethod: " + (Object)((Object)((PngChunkIhdr)pngChunkIHDR).getInterlaceMethod()));
            }
        }
        abstractScanExpediter.drive();
        if (iccProfile != null && !(pngColorType = ((IccProfileParser)(object = new IccProfileParser())).isSrgb(ByteSource.array(((ICC_Profile)(object2 = iccProfile)).getData())))) {
            BufferedImage bufferedImage;
            Object object3;
            ICC_ColorSpace cs = new ICC_ColorSpace(iccProfile);
            pngChunkIHDR = ColorModel.getRGBdefault();
            ColorSpace csSrgb = ((ColorModel)pngChunkIHDR).getColorSpace();
            BufferedImage bufferedImage2 = result;
            result = object3;
            object2 = bufferedImage2;
            object = new ColorTools();
            object3 = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ((RenderingHints)object3).put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            ((RenderingHints)object3).put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            object3 = new ColorConvertOp((ColorSpace)((Object)bufferedImage), (ColorSpace)((Object)result), (RenderingHints)object3);
            object2 = ((ColorTools)object).relabelColorSpace((BufferedImage)object2, (ColorSpace)((Object)bufferedImage));
            bufferedImage = ((ColorConvertOp)object3).filter((BufferedImage)object2, null);
            result = ((ColorTools)object).relabelColorSpace(bufferedImage, (ColorSpace)((Object)result));
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    private List<PngChunk> readChunks(ByteSource byteSource, ChunkType[] chunkTypes, boolean returnAfterFirst) throws ImagingException, IOException {
        Object object;
        block35: {
            InputStream is = byteSource.getInputStream();
            try {
                int n;
                Object object2 = is;
                BinaryFunctions.readAndVerifyBytes((InputStream)object2, PngConstants.PNG_SIGNATURE, "Not a Valid PNG Segment: Incorrect Signature");
                boolean bl = false;
                void var4_8 = object;
                object = is;
                object2 = this;
                ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
                do {
                    int n2;
                    int n3;
                    byte[] byArray;
                    int n4;
                    block34: {
                        if ((n4 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid PNG File", ((BinaryFileParser)object2).getByteOrder())) < 0) {
                            throw new ImagingException("Invalid PNG chunk length: " + n4);
                        }
                        n = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid PNG File", ((BinaryFileParser)object2).getByteOrder());
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            BinaryFunctions.logCharQuad("ChunkType", n);
                            ((BinaryFileParser)object2).debugNumber("Length", n4, 4);
                        }
                        byArray = var4_8;
                        n3 = n;
                        if (byArray == null) {
                            n2 = 1;
                        } else {
                            for (byte by : byArray) {
                                if (by.value != n3) continue;
                                n2 = 1;
                                break block34;
                            }
                            n2 = 0;
                        }
                    }
                    n3 = n2;
                    byArray = null;
                    if (n3 != 0) {
                        byArray = BinaryFunctions.readBytes("Chunk Data", (InputStream)object, n4, "Not a Valid PNG File: Couldn't read Chunk Data.");
                    } else {
                        BinaryFunctions.skipBytes((InputStream)object, n4, "Not a Valid PNG File");
                    }
                    if (LOGGER.isLoggable(Level.FINEST) && byArray != null) {
                        ((BinaryFileParser)object2).debugNumber("bytes", byArray.length, 4);
                    }
                    int n5 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid PNG File", ((BinaryFileParser)object2).getByteOrder());
                    if (n3 == 0) continue;
                    if (n == ChunkType.iCCP.value) {
                        arrayList.add(new PngChunkIccp(n4, n, n5, byArray));
                    } else if (n == ChunkType.tEXt.value) {
                        arrayList.add(new PngChunkText(n4, n, n5, byArray));
                    } else if (n == ChunkType.zTXt.value) {
                        arrayList.add(new PngChunkZtxt(n4, n, n5, byArray));
                    } else if (n == ChunkType.IHDR.value) {
                        arrayList.add(new PngChunkIhdr(n4, n, n5, byArray));
                    } else if (n == ChunkType.PLTE.value) {
                        arrayList.add(new PngChunkPlte(n4, n, n5, byArray));
                    } else if (n == ChunkType.pHYs.value) {
                        arrayList.add(new PngChunkPhys(n4, n, n5, byArray));
                    } else if (n == ChunkType.sCAL.value) {
                        arrayList.add(new PngChunkScal(n4, n, n5, byArray));
                    } else if (n == ChunkType.IDAT.value) {
                        arrayList.add(new PngChunkIdat(n4, n, n5, byArray));
                    } else if (n == ChunkType.gAMA.value) {
                        arrayList.add(new PngChunkGama(n4, n, n5, byArray));
                    } else if (n == ChunkType.iTXt.value) {
                        arrayList.add(new PngChunkItxt(n4, n, n5, byArray));
                    } else {
                        arrayList.add(new PngChunk(n4, n, n5, byArray));
                    }
                    if (bl) break;
                } while (n != ChunkType.IEND.value);
                object = arrayList;
                if (is == null) break block35;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return object;
    }
}

