/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import org.apache.commons.imaging.ImagingException;

final class BitParser {
    private final byte[] bytes;
    private final int bitsPerPixel;
    private final int bitDepth;

    /*
     * WARNING - void declaration
     */
    BitParser(byte[] bytes, int bitsPerPixel, int bitDepth) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bytes = (byte[])var1_1.clone();
        this.bitsPerPixel = var2_2;
        this.bitDepth = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSample(int pixelIndexInScanline, int sampleIndex) throws ImagingException {
        void var2_2;
        int pixelIndexBits = this.bitsPerPixel * pixelIndexInScanline;
        sampleIndex = pixelIndexBits + sampleIndex * this.bitDepth;
        int sampleIndexBytes = sampleIndex >> 3;
        if (this.bitDepth == 8) {
            return 0xFF & this.bytes[sampleIndexBytes];
        }
        if (this.bitDepth < 8) {
            void var1_1;
            int b = 0xFF & this.bytes[sampleIndexBytes];
            int bitsToShift = 8 - ((pixelIndexBits & 7) + this.bitDepth);
            b >>= bitsToShift;
            int bitmask = (1 << this.bitDepth) - 1;
            return var2_2 & var1_1;
        }
        if (this.bitDepth == 16) {
            return (0xFF & this.bytes[var2_2]) << 8 | 0xFF & this.bytes[var2_2 + true];
        }
        throw new ImagingException("PNG: bad BitDepth: " + this.bitDepth);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSampleAsByte(int pixelIndexInScanline, int sampleIndex) throws ImagingException {
        void var1_1;
        int sample = this.getSample(pixelIndexInScanline, sampleIndex);
        int rot = 8 - this.bitDepth;
        if (rot > 0) {
            sample = sample * 255 / ((1 << this.bitDepth) - 1);
        } else if (rot < 0) {
            void var2_2;
            sample >>= -var2_2;
        }
        return 0xFF & var1_1;
    }
}

