/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.FilterType;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilter;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterAverage;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterNone;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterPaeth;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterSub;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterUp;
import org.apache.commons.imaging.formats.png.transparencyfilters.AbstractTransparencyFilter;

abstract class AbstractScanExpediter {
    final int width;
    final int height;
    final InputStream is;
    final BufferedImage bi;
    final PngColorType pngColorType;
    final int bitDepth;
    final int bytesPerPixel;
    final int bitsPerPixel;
    final PngChunkPlte pngChunkPlte;
    final GammaCorrection gammaCorrection;
    final AbstractTransparencyFilter abstractTransparencyFilter;

    /*
     * WARNING - void declaration
     */
    AbstractScanExpediter(int width, int height, InputStream is, BufferedImage bi, PngColorType pngColorType, int bitDepth, int bitsPerPixel, PngChunkPlte pngChunkPLTE, GammaCorrection gammaCorrection, AbstractTransparencyFilter abstractTransparencyFilter) {
        void var3_3;
        void var2_2;
        int n;
        this.width = n;
        this.height = var2_2;
        this.is = var3_3;
        this.bi = bi;
        this.pngColorType = pngColorType;
        this.bitDepth = bitDepth;
        n = bitsPerPixel;
        this.bytesPerPixel = (n + 7) / 8;
        this.bitsPerPixel = bitsPerPixel;
        this.pngChunkPlte = pngChunkPLTE;
        this.gammaCorrection = gammaCorrection;
        this.abstractTransparencyFilter = abstractTransparencyFilter;
    }

    public abstract void drive() throws ImagingException, IOException;

    /*
     * WARNING - void declaration
     */
    final byte[] getNextScanline(InputStream is, int length, byte[] prev, int bytesPerPixel) throws ImagingException, IOException {
        ScanlineFilter scanlineFilter;
        Object object;
        void var3_6;
        void var2_2;
        int filterType = is.read();
        if (filterType < 0) {
            throw new ImagingException("PNG: missing filter type");
        }
        if (filterType >= FilterType.values().length) {
            throw new ImagingException("PNG: unknown filterType: " + filterType);
        }
        byte[] scanline = BinaryFunctions.readBytes("scanline", is, (int)var2_2, "PNG: missing image data");
        int n = bytesPerPixel;
        void var4_8 = var3_6;
        var3_6 = object;
        FilterType filterType2 = FilterType.values()[filterType];
        object = this;
        int n2 = n;
        object = filterType2;
        switch (1.$SwitchMap$org$apache$commons$imaging$formats$png$FilterType[((Enum)object).ordinal()]) {
            case 1: {
                scanlineFilter = new ScanlineFilterNone();
                break;
            }
            case 2: {
                scanlineFilter = new ScanlineFilterSub(n2);
                break;
            }
            case 3: {
                scanlineFilter = new ScanlineFilterUp();
                break;
            }
            case 4: {
                scanlineFilter = new ScanlineFilterAverage(n2);
                break;
            }
            case 5: {
                scanlineFilter = new ScanlineFilterPaeth(n2);
                break;
            }
            default: {
                scanlineFilter = null;
            }
        }
        object = scanlineFilter;
        byte[] byArray = Allocator.byteArray(((void)var3_6).length);
        object.unfilter((byte[])var3_6, byArray, (byte[])var4_8);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int getPixelArgb(int alpha, int red, int green, int blue) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return (0xFF & n) << 24 | (0xFF & var1_1) << 16 | (0xFF & var2_2) << 8 | (0xFF & var3_3) << 0;
    }

    /*
     * WARNING - void declaration
     */
    private int getPixelRgb(int red, int green, int blue) {
        void var3_3;
        void var2_2;
        void var1_1;
        return AbstractScanExpediter.getPixelArgb(255, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final int getRgb(BitParser bitParser, int pixelIndexInScanline) throws ImagingException, IOException {
        switch (this.pngColorType) {
            case GREYSCALE: {
                int sample = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                if (this.gammaCorrection != null) {
                    sample = this.gammaCorrection.correctSample(sample);
                }
                int n = sample;
                int rgb = this.getPixelRgb(n, n, sample);
                if (this.abstractTransparencyFilter != null) {
                    rgb = this.abstractTransparencyFilter.filter(rgb, sample);
                }
                return rgb;
            }
            case TRUE_COLOR: {
                int alpha;
                int red = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                int green = bitParser.getSampleAsByte(pixelIndexInScanline, 1);
                int blue = bitParser.getSampleAsByte(pixelIndexInScanline, 2);
                int rgb = this.getPixelRgb(red, green, blue);
                if (this.abstractTransparencyFilter != null) {
                    rgb = this.abstractTransparencyFilter.filter(rgb, -1);
                }
                if (this.gammaCorrection != null) {
                    alpha = (0xFF000000 & rgb) >> 24;
                    red = this.gammaCorrection.correctSample(red);
                    green = this.gammaCorrection.correctSample(green);
                    blue = this.gammaCorrection.correctSample(blue);
                    alpha = AbstractScanExpediter.getPixelArgb(alpha, red, green, blue);
                }
                return alpha;
            }
            case INDEXED_COLOR: {
                void alpha;
                if (this.pngChunkPlte == null) {
                    throw new ImagingException("A PLTE chunk is required for an indexed color type.");
                }
                int index = alpha.getSample(pixelIndexInScanline, 0);
                int rgb = this.pngChunkPlte.getRgb(index);
                if (this.abstractTransparencyFilter != null) {
                    rgb = this.abstractTransparencyFilter.filter(rgb, index);
                }
                return rgb;
            }
            case GREYSCALE_WITH_ALPHA: {
                void alpha;
                int sample = alpha.getSampleAsByte(pixelIndexInScanline, 0);
                int alpha2 = alpha.getSampleAsByte(pixelIndexInScanline, 1);
                if (this.gammaCorrection != null) {
                    sample = this.gammaCorrection.correctSample(sample);
                }
                int n = sample;
                return AbstractScanExpediter.getPixelArgb(alpha2, n, n, sample);
            }
            case TRUE_COLOR_WITH_ALPHA: {
                void var3_9;
                void var1_3;
                void var2_4;
                void alpha;
                int red = alpha.getSampleAsByte(pixelIndexInScanline, 0);
                int green = alpha.getSampleAsByte(pixelIndexInScanline, 1);
                int blue = alpha.getSampleAsByte(pixelIndexInScanline, 2);
                int alpha2 = alpha.getSampleAsByte((int)var2_4, 3);
                if (this.gammaCorrection != null) {
                    red = this.gammaCorrection.correctSample(red);
                    green = this.gammaCorrection.correctSample(green);
                    blue = this.gammaCorrection.correctSample(blue);
                }
                return AbstractScanExpediter.getPixelArgb((int)var1_3, (int)var3_9, green, blue);
            }
        }
        throw new ImagingException("PNG: unknown color type: " + (Object)((Object)this.pngColorType));
    }
}

