/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public class SosSegment
extends AbstractSegment {
    private static final Logger LOGGER = Logger.getLogger(SosSegment.class.getName());
    public final int numberOfComponents;
    private final Component[] components;
    public final int startOfSpectralSelection;
    public final int endOfSpectralSelection;
    public final int successiveApproximationBitHigh;
    public final int successiveApproximationBitLow;

    /*
     * WARNING - void declaration
     */
    public SosSegment(int marker, byte[] segmentData) throws IOException {
        this((int)var1_1, segmentData.length, new ByteArrayInputStream((byte[])var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SosSegment(int marker, int markerLength, InputStream is) throws IOException {
        super(marker, markerLength);
        void var1_1;
        void var3_3;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("SosSegment markerLength: " + markerLength);
        }
        this.numberOfComponents = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
        this.components = (Component[])Allocator.array(this.numberOfComponents, Component[]::new, 24);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            void var2_2;
            byte scanComponentSelector = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            byte acDcEntropyCodingTableSelector = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            int dcCodingTableSelector = acDcEntropyCodingTableSelector >> 4 & 0xF;
            int acCodingTableSelector = acDcEntropyCodingTableSelector & 0xF;
            this.components[i] = new Component((int)var2_2, dcCodingTableSelector, acCodingTableSelector);
        }
        this.startOfSpectralSelection = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
        this.endOfSpectralSelection = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
        byte successiveApproximationBitPosition = BinaryFunctions.readByte$74534d56((InputStream)var3_3, "Not a Valid JPEG File");
        this.successiveApproximationBitHigh = successiveApproximationBitPosition >> 4 & 0xF;
        this.successiveApproximationBitLow = var1_1 & 0xF;
    }

    /*
     * WARNING - void declaration
     */
    public final Component getComponents(int index) {
        void var1_1;
        return this.components[var1_1];
    }

    @Override
    public final String getDescription() {
        return "SOS (" + this.getSegmentType() + ")";
    }

    public static final class Component {
        public final int scanComponentSelector;
        public final int dcCodingTableSelector;
        public final int acCodingTableSelector;

        /*
         * WARNING - void declaration
         */
        public Component(int scanComponentSelector, int dcCodingTableSelector, int acCodingTableSelector) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.scanComponentSelector = var1_1;
            this.dcCodingTableSelector = var2_2;
            this.acCodingTableSelector = var3_3;
        }
    }
}

