/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public final class DqtSegment
extends AbstractSegment {
    public final List<QuantizationTable> quantizationTables = new ArrayList<QuantizationTable>();

    /*
     * WARNING - void declaration
     */
    public DqtSegment(int marker, byte[] segmentData) throws ImagingException, IOException {
        this((int)var1_1, segmentData.length, new ByteArrayInputStream((byte[])var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private DqtSegment(int marker, int length, InputStream is) throws ImagingException, IOException {
        super(marker, length);
        while (length > 0) {
            void var1_1;
            byte precisionAndDestination = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            --length;
            int precision = precisionAndDestination >> 4 & 0xF;
            int destinationIdentifier = precisionAndDestination & 0xF;
            int[] elements = new int[64];
            for (int i = 0; i < 64; ++i) {
                if (precision == 0) {
                    elements[i] = 0xFF & BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
                    --length;
                    continue;
                }
                if (precision == 1) {
                    elements[i] = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid JPEG File", this.getByteOrder());
                    length -= 2;
                    continue;
                }
                throw new ImagingException("Quantization table precision '" + precision + "' is invalid");
            }
            this.quantizationTables.add(new QuantizationTable(precision, (int)var1_1, elements));
        }
    }

    @Override
    public final String getDescription() {
        return "DQT (" + this.getSegmentType() + ")";
    }

    public static final class QuantizationTable {
        public final int precision;
        public final int destinationIdentifier;
        private final int[] elements;

        /*
         * WARNING - void declaration
         */
        public QuantizationTable(int precision, int destinationIdentifier, int[] elements) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.precision = var1_1;
            this.destinationIdentifier = var2_2;
            this.elements = var3_3;
        }

        public final int[] getElements() {
            return this.elements;
        }
    }
}

