/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public final class DhtSegment
extends AbstractSegment {
    public final List<HuffmanTable> huffmanTables;

    /*
     * WARNING - void declaration
     */
    public DhtSegment(int marker, byte[] segmentData) throws IOException {
        this((int)var1_1, segmentData.length, new ByteArrayInputStream((byte[])var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private DhtSegment(int marker, int length, InputStream is) throws IOException {
        super(marker, length);
        void var1_2;
        ArrayList<HuffmanTable> huffmanTables = new ArrayList<HuffmanTable>();
        while (length > 0) {
            int tableClassAndDestinationId = 0xFF & BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            --length;
            int tableClass = tableClassAndDestinationId >> 4 & 0xF;
            int destinationIdentifier = tableClassAndDestinationId & 0xF;
            int[] bits = new int[17];
            int bitsSum = 0;
            for (int i = 1; i < bits.length; ++i) {
                bits[i] = 0xFF & BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
                --length;
                bitsSum += bits[i];
            }
            int[] huffVal = Allocator.intArray(bitsSum);
            for (int i = 0; i < bitsSum; ++i) {
                huffVal[i] = 0xFF & BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
                --length;
            }
            huffmanTables.add(new HuffmanTable(tableClass, destinationIdentifier, bits, huffVal));
        }
        this.huffmanTables = Collections.unmodifiableList(var1_2);
    }

    @Override
    public final String getDescription() {
        return "DHT (" + this.getSegmentType() + ")";
    }

    public static final class HuffmanTable {
        public final int tableClass;
        public final int destinationIdentifier;
        private final int[] huffVal;
        private final int[] huffSize = new int[4096];
        private final int[] huffCode;
        private final int[] minCode = new int[17];
        private final int[] maxCode = new int[17];
        private final int[] valPtr = new int[17];

        HuffmanTable(int tableClass, int destinationIdentifier, int[] bits, int[] huffVal) {
            int lastK;
            this.tableClass = tableClass;
            this.destinationIdentifier = destinationIdentifier;
            this.huffVal = huffVal;
            int k = 0;
            int i = 1;
            int j = 1;
            while (true) {
                if (j > bits[i]) {
                    j = 1;
                    if (++i <= 16) continue;
                    break;
                }
                this.huffSize[k] = lastK;
                ++k;
                ++j;
            }
            this.huffSize[k] = 0;
            lastK = k;
            k = 0;
            int code = 0;
            int si = this.huffSize[0];
            this.huffCode = Allocator.intArray(lastK);
            while (k < lastK) {
                this.huffCode[k] = code++;
                if (this.huffSize[++k] == si) continue;
                if (this.huffSize[k] == 0) break;
                do {
                    code <<= 1;
                } while (this.huffSize[k] != ++si);
            }
            int n = 0;
            int n2 = 0;
            while (++n <= 16) {
                if (bits[n] == 0) {
                    this.maxCode[n] = -1;
                    continue;
                }
                this.valPtr[n] = n2;
                this.minCode[n] = this.huffCode[n2];
                this.maxCode[n] = this.huffCode[n2 += bits[n] - 1];
                ++n2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int getHuffVal(int i) {
            void var1_1;
            return this.huffVal[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final int getMaxCode(int i) {
            void var1_1;
            return this.maxCode[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final int getMinCode(int i) {
            void var1_1;
            return this.minCode[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final int getValPtr(int i) {
            void var1_1;
            return this.valPtr[var1_1];
        }
    }
}

