/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;

final class JpegInputStream {
    private final int[] interval;
    private int nextPos;
    private int cnt;
    private int b;

    /*
     * WARNING - void declaration
     */
    JpegInputStream(int[] interval) {
        void var1_1;
        void v0 = var1_1;
        this.interval = Arrays.copyOf((int[])v0, ((void)v0).length);
        this.nextPos = 0;
    }

    public final boolean hasNext() {
        return this.nextPos < this.interval.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int nextBit() throws ImagingException {
        void var1_1;
        if (this.cnt == 0) {
            this.b = this.read();
            if (this.b < 0) {
                throw new ImagingException("Premature End of File");
            }
            this.cnt = 8;
            if (this.b == 255) {
                int b2 = this.read();
                if (b2 < 0) {
                    throw new ImagingException("Premature End of File");
                }
                if (b2 != 0) {
                    if (b2 == 220) {
                        throw new ImagingException("DNL not yet supported");
                    }
                    throw new ImagingException("Invalid marker found in entropy data: 0xFF " + Integer.toHexString(b2));
                }
            }
        }
        int bit = this.b >> 7 & 1;
        --this.cnt;
        this.b <<= 1;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int read() {
        void var1_1;
        if (!this.hasNext()) {
            throw new IllegalStateException("This stream hasn't any other value, all values were already read.");
        }
        int value = this.interval[this.nextPos];
        ++this.nextPos;
        return (int)var1_1;
    }
}

