/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

final class Dct {
    private static final float[] DCT_SCALING_FACTORS = new float[]{(float)(0.5 / Math.sqrt(2.0)), (float)(0.25 / Math.cos(0.19634954084936207)), (float)(0.25 / Math.cos(0.39269908169872414)), (float)(0.25 / Math.cos(0.5890486225480862)), (float)(0.25 / Math.cos(0.7853981633974483)), (float)(0.25 / Math.cos(0.9817477042468103)), (float)(0.25 / Math.cos(1.1780972450961724)), (float)(0.25 / Math.cos(1.3744467859455345))};
    private static final float[] IDCT_SCALING_FACTORS = new float[]{(float)(8.0 / Math.sqrt(2.0) * 0.0625), (float)(4.0 * Math.cos(0.19634954084936207) * 0.125), (float)(4.0 * Math.cos(0.39269908169872414) * 0.125), (float)(4.0 * Math.cos(0.5890486225480862) * 0.125), (float)(4.0 * Math.cos(0.7853981633974483) * 0.125), (float)(4.0 * Math.cos(0.9817477042468103) * 0.125), (float)(4.0 * Math.cos(1.1780972450961724) * 0.125), (float)(4.0 * Math.cos(1.3744467859455345) * 0.125)};
    private static final float A1 = (float)Math.cos(0.7853981633974483);
    private static final float A2 = (float)(Math.cos(0.39269908169872414) - Math.cos(1.1780972450961724));
    private static final float A3 = A1;
    private static final float A4 = (float)(Math.cos(0.39269908169872414) + Math.cos(1.1780972450961724));
    private static final float A5 = (float)Math.cos(1.1780972450961724);
    private static final float C2 = (float)(2.0 * Math.cos(0.39269908169872414));
    private static final float C4 = (float)(2.0 * Math.cos(0.7853981633974483));
    private static final float C6 = (float)(2.0 * Math.cos(1.1780972450961724));
    private static final float Q = C2 - C6;
    private static final float R = C2 + C6;

    /*
     * WARNING - void declaration
     */
    public static void inverseDct8x8(float[] matrix) {
        void neg_m7;
        void neg_n5;
        float m6;
        float m5;
        float m4;
        float m3;
        float n3;
        float n2;
        float n1;
        float n0;
        float tmp3;
        float b5;
        float b2;
        float b6;
        float neg_b4;
        float tmp4;
        float a7;
        float a6;
        float a5;
        float tmp2;
        float tmp1;
        float a4;
        float a3;
        float a2;
        int i;
        for (i = 0; i < 8; ++i) {
            a2 = matrix[8 * i + 2] - matrix[8 * i + 6];
            a3 = matrix[8 * i + 2] + matrix[8 * i + 6];
            a4 = matrix[8 * i + 5] - matrix[8 * i + 3];
            tmp1 = matrix[8 * i + 1] + matrix[8 * i + 7];
            tmp2 = matrix[8 * i + 3] + matrix[8 * i + 5];
            a5 = tmp1 - tmp2;
            a6 = matrix[8 * i + 1] - matrix[8 * i + 7];
            a7 = tmp1 + tmp2;
            tmp4 = C6 * (a4 + a6);
            neg_b4 = Q * a4 + tmp4;
            b6 = R * a6 - tmp4;
            b2 = a2 * C4;
            b5 = a5 * C4;
            tmp3 = b6 - a7;
            n0 = tmp3 - b5;
            n1 = matrix[8 * i] - matrix[8 * i + 4];
            n2 = b2 - a3;
            n3 = matrix[8 * i] + matrix[8 * i + 4];
            m3 = n1 + n2;
            m4 = n3 + a3;
            m5 = n1 - n2;
            m6 = n3 - a3;
            neg_m7 = neg_n5 + n0;
            matrix[8 * i] = m4 + a7;
            matrix[8 * i + 1] = m3 + tmp3;
            matrix[8 * i + 2] = m5 - n0;
            matrix[8 * i + 3] = m6 + neg_m7;
            matrix[8 * i + 4] = m6 - neg_m7;
            matrix[8 * i + 5] = m5 + n0;
            matrix[8 * i + 6] = m3 - tmp3;
            matrix[8 * i + 7] = m4 - a7;
        }
        for (i = 0; i < 8; ++i) {
            void var1_2;
            void var3_4;
            void var2_3;
            a2 = matrix[16 + i] - matrix[48 + i];
            a3 = matrix[16 + i] + matrix[48 + i];
            a4 = matrix[40 + i] - matrix[24 + i];
            tmp1 = matrix[8 + i] + matrix[56 + i];
            tmp2 = matrix[24 + i] + matrix[40 + i];
            a5 = tmp1 - tmp2;
            a6 = matrix[8 + i] - matrix[56 + i];
            a7 = tmp1 + tmp2;
            tmp4 = C6 * (a4 + a6);
            neg_b4 = Q * a4 + tmp4;
            b6 = R * a6 - tmp4;
            b2 = a2 * C4;
            b5 = a5 * C4;
            tmp3 = b6 - a7;
            n0 = tmp3 - b5;
            n1 = matrix[i] - matrix[32 + i];
            n2 = b2 - a3;
            n3 = matrix[i] + matrix[32 + i];
            m3 = n1 + n2;
            m4 = n3 + a3;
            m5 = n1 - n2;
            m6 = n3 - a3;
            neg_m7 = neg_n5 + n0;
            matrix[i] = m4 + a7;
            matrix[8 + i] = m3 + tmp3;
            matrix[16 + i] = m5 - n0;
            matrix[24 + i] = m6 + neg_m7;
            matrix[32 + i] = var2_3 - var3_4;
            matrix[40 + i] = var1_2 + n0;
            matrix[48 + i] = m3 - tmp3;
            matrix[56 + i] = m4 - a7;
        }
    }

    public static void scaleDequantizationMatrix(float[] matrix) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                int n = 8 * y + x;
                matrix[n] = matrix[n] * (IDCT_SCALING_FACTORS[y] * IDCT_SCALING_FACTORS[x]);
            }
        }
    }
}

