/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.ico;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.common.LittleEndianBinaryOutputStream;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.ico.IcoImagingParameters;

public final class IcoImageParser
extends AbstractImageParser<IcoImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.ICO.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.ICO.getExtensions();

    public IcoImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.ICO};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        void var3_3;
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        ArrayList result = Allocator.arrayList(fileHeader.iconCount);
        for (int i = 0; i < fileHeader.iconCount; ++i) {
            result.add(contents.iconDatas[i].readBufferedImage());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private BitmapIconData readBitmapIconData$258c725e(byte[] iconData, IconInfo fIconInfo) throws ImagingException, IOException {
        void var3_5;
        void var2_3;
        BufferedImage resultImage;
        byte[] transparencyMap;
        int tScanlineSize;
        BufferedImage bmpImage;
        int bitCount;
        block21: {
            ByteArrayInputStream is = new ByteArrayInputStream(iconData);
            int size = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int width = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int height = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int planes = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            bitCount = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int compression = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int sizeImage = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int xPelsPerMeter = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int yPelsPerMeter = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int colorsUsed = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int colorsImportant = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            int redMask = 0;
            int greenMask = 0;
            int blueMask = 0;
            int alphaMask = 0;
            if (compression == 3) {
                redMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
                greenMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
                blueMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid ICO File", this.getByteOrder());
            }
            ByteArrayInputStream byteArrayInputStream = is;
            byte[] restOfFile = BinaryFunctions.readBytes("RestOfFile", byteArrayInputStream, byteArrayInputStream.available());
            if (size != 40) {
                throw new ImagingException("Not a Valid ICO File: Wrong bitmap header size " + size);
            }
            if (planes != 1) {
                throw new ImagingException("Not a Valid ICO File: Planes can't be " + planes);
            }
            if (compression == 0 && bitCount == 32) {
                compression = 3;
                redMask = 0xFF0000;
                greenMask = 65280;
                blueMask = 255;
                alphaMask = -16777216;
            }
            BitmapHeader header = new BitmapHeader(size, width, height, planes, bitCount, compression, sizeImage, xPelsPerMeter, yPelsPerMeter, colorsUsed, colorsImportant);
            int bitmapPixelsOffset = 70 + 4 * (colorsUsed == 0 && bitCount <= 8 ? 1 << bitCount : colorsUsed);
            int bitmapSize = 70 + restOfFile.length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Allocator.checkByteArray(bitmapSize));
            try (LittleEndianBinaryOutputStream bos = BinaryOutputStream.littleEndian(baos);){
                bos.write(66);
                bos.write(77);
                ((BinaryOutputStream)bos).write4Bytes(bitmapSize);
                ((BinaryOutputStream)bos).write4Bytes(0);
                ((BinaryOutputStream)bos).write4Bytes(bitmapPixelsOffset);
                ((BinaryOutputStream)bos).write4Bytes(56);
                ((BinaryOutputStream)bos).write4Bytes(width);
                ((BinaryOutputStream)bos).write4Bytes(height / 2);
                ((BinaryOutputStream)bos).write2Bytes(planes);
                ((BinaryOutputStream)bos).write2Bytes(bitCount);
                ((BinaryOutputStream)bos).write4Bytes(compression);
                ((BinaryOutputStream)bos).write4Bytes(sizeImage);
                ((BinaryOutputStream)bos).write4Bytes(xPelsPerMeter);
                ((BinaryOutputStream)bos).write4Bytes(yPelsPerMeter);
                ((BinaryOutputStream)bos).write4Bytes(colorsUsed);
                ((BinaryOutputStream)bos).write4Bytes(colorsImportant);
                ((BinaryOutputStream)bos).write4Bytes(redMask);
                ((BinaryOutputStream)bos).write4Bytes(greenMask);
                ((BinaryOutputStream)bos).write4Bytes(blueMask);
                ((BinaryOutputStream)bos).write4Bytes(alphaMask);
                bos.write(restOfFile);
                bos.flush();
            }
            ByteArrayInputStream bmpInputStream = new ByteArrayInputStream(baos.toByteArray());
            bmpImage = new BmpImageParser().getBufferedImage$7190f1a6(bmpInputStream);
            tScanlineSize = (width + 7) / 8;
            if (tScanlineSize % 4 != 0) {
                tScanlineSize += 4 - tScanlineSize % 4;
            }
            int colorMapSizeBytes = tScanlineSize * (height / 2);
            transparencyMap = null;
            try {
                transparencyMap = BinaryFunctions.readBytes("transparencyMap", bmpInputStream, colorMapSizeBytes, "Not a Valid ICO File");
            }
            catch (IOException ioEx) {
                if (bitCount == 32) break block21;
                throw ioEx;
            }
        }
        boolean allAlphasZero = true;
        if (bitCount == 32) {
            block7: for (int y = 0; allAlphasZero && y < bmpImage.getHeight(); ++y) {
                for (int x = 0; x < bmpImage.getWidth(); ++x) {
                    if ((bmpImage.getRGB(x, y) & 0xFF000000) == 0) continue;
                    allAlphasZero = false;
                    continue block7;
                }
            }
        }
        if (allAlphasZero) {
            resultImage = new BufferedImage(bmpImage.getWidth(), bmpImage.getHeight(), 2);
            for (int y = 0; y < resultImage.getHeight(); ++y) {
                for (int x = 0; x < resultImage.getWidth(); ++x) {
                    int n;
                    int alpha = 255;
                    if (transparencyMap != null) {
                        int alphaByte = 0xFF & transparencyMap[tScanlineSize * (bmpImage.getHeight() - y - 1) + x / 8];
                        n = 1 & alphaByte >> 7 - x % 8;
                        n = n == 0 ? 255 : 0;
                    }
                    resultImage.setRGB(x, y, n << 24 | 0xFFFFFF & bmpImage.getRGB(x, y));
                }
            }
        } else {
            void var1_1;
            resultImage = var1_1;
        }
        return new BitmapIconData((IconInfo)var2_3, (BitmapHeader)var3_5, resultImage);
    }

    /*
     * WARNING - void declaration
     */
    private ImageContents readImage(ByteSource byteSource) throws ImagingException, IOException {
        ImageContents imageContents;
        block11: {
            InputStream is = byteSource.getInputStream();
            try {
                void var3_15;
                Object object = is;
                IcoImageParser icoImageParser = this;
                int by = BinaryFunctions.read2Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                int imageFormat = BinaryFunctions.read2Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                int n = BinaryFunctions.read2Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                if (by != 0) {
                    throw new ImagingException("Not a Valid ICO File: reserved is " + by);
                }
                if (imageFormat != 1 && imageFormat != 2) {
                    throw new ImagingException("Not a Valid ICO File: icon type is " + imageFormat);
                }
                FileHeader fileHeader = new FileHeader(by, imageFormat, n);
                IconInfo[] fIconInfos = (IconInfo[])Allocator.array(fileHeader.iconCount, IconInfo[]::new, 32);
                for (int i = 0; i < fileHeader.iconCount; ++i) {
                    object = is;
                    icoImageParser = this;
                    byte iconInfo = BinaryFunctions.readByte$74534d56((InputStream)object, "Not a Valid ICO File");
                    byte by2 = BinaryFunctions.readByte$74534d56((InputStream)object, "Not a Valid ICO File");
                    byte by3 = BinaryFunctions.readByte$74534d56((InputStream)object, "Not a Valid ICO File");
                    byte by4 = BinaryFunctions.readByte$74534d56((InputStream)object, "Not a Valid ICO File");
                    int n2 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                    int n3 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                    int n4 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                    int n42 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid ICO File", icoImageParser.getByteOrder());
                    fIconInfos[i] = new IconInfo(iconInfo, by2, by3, by4, n2, n3, n4, n42);
                }
                IconData[] fIconDatas = (IconData[])Allocator.array(fileHeader.iconCount, IconData[]::new, 16);
                for (int i = 0; i < fileHeader.iconCount; ++i) {
                    IconData iconData;
                    byte[] iconData2 = byteSource.getByteArray(fIconInfos[i].imageOffset, fIconInfos[i].imageSize);
                    IconInfo iconInfo = fIconInfos[i];
                    object = iconData2;
                    icoImageParser = this;
                    ImageFormat imageFormat2 = Imaging.guessFormat((byte[])object);
                    if (imageFormat2.equals(ImageFormats.PNG)) {
                        BufferedImage bufferedImage = Imaging.getBufferedImage((byte[])object);
                        iconData = new PngIconData(iconInfo, bufferedImage);
                    } else {
                        iconData = icoImageParser.readBitmapIconData$258c725e((byte[])object, iconInfo);
                    }
                    fIconDatas[i] = iconData;
                }
                imageContents = new ImageContents((FileHeader)var3_15, fIconDatas);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var2_2;
                        var2_2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return imageContents;
    }

    private static final class ImageContents {
        public final FileHeader fileHeader;
        public final IconData[] iconDatas;

        /*
         * WARNING - void declaration
         */
        ImageContents(FileHeader fileHeader, IconData[] iconDatas) {
            void var2_2;
            void var1_1;
            this.fileHeader = var1_1;
            this.iconDatas = var2_2;
        }
    }

    private static final class FileHeader {
        public final int reserved;
        public final int iconType;
        public final int iconCount;

        /*
         * WARNING - void declaration
         */
        FileHeader(int reserved, int iconType, int iconCount) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.reserved = var1_1;
            this.iconType = var2_2;
            this.iconCount = var3_3;
        }
    }

    static abstract class IconData {
        public final IconInfo iconInfo;

        /*
         * WARNING - void declaration
         */
        IconData(IconInfo iconInfo) {
            void var1_1;
            this.iconInfo = var1_1;
        }

        public abstract BufferedImage readBufferedImage() throws ImagingException;
    }

    private static final class BitmapHeader {
        public final int size;
        public final int width;
        public final int height;
        public final int planes;
        public final int bitCount;
        public final int compression;
        public final int sizeImage;
        public final int xPelsPerMeter;
        public final int yPelsPerMeter;
        public final int colorsUsed;
        public final int colorsImportant;

        /*
         * WARNING - void declaration
         */
        BitmapHeader(int size, int width, int height, int planes, int bitCount, int compression, int sizeImage, int pelsPerMeter, int pelsPerMeter2, int colorsUsed, int colorsImportant) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.size = var1_1;
            this.width = var2_2;
            this.height = var3_3;
            this.planes = planes;
            this.bitCount = bitCount;
            this.compression = compression;
            this.sizeImage = sizeImage;
            this.xPelsPerMeter = pelsPerMeter;
            this.yPelsPerMeter = pelsPerMeter2;
            this.colorsUsed = colorsUsed;
            this.colorsImportant = colorsImportant;
        }
    }

    private static final class BitmapIconData
    extends IconData {
        public final BitmapHeader header;
        public final BufferedImage bufferedImage;

        /*
         * WARNING - void declaration
         */
        BitmapIconData(IconInfo iconInfo, BitmapHeader header, BufferedImage bufferedImage) {
            super((IconInfo)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.header = var2_2;
            this.bufferedImage = var3_3;
        }

        @Override
        public final BufferedImage readBufferedImage() throws ImagingException {
            return this.bufferedImage;
        }
    }

    static final class IconInfo {
        public final byte width;
        public final byte height;
        public final byte colorCount;
        public final byte reserved;
        public final int planes;
        public final int bitCount;
        public final int imageSize;
        public final int imageOffset;

        /*
         * WARNING - void declaration
         */
        IconInfo(byte width, byte height, byte colorCount, byte reserved, int planes, int bitCount, int imageSize, int imageOffset) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.colorCount = var3_3;
            this.reserved = reserved;
            this.planes = planes;
            this.bitCount = bitCount;
            this.imageSize = imageSize;
            this.imageOffset = imageOffset;
        }
    }

    private static final class PngIconData
    extends IconData {
        public final BufferedImage bufferedImage;

        /*
         * WARNING - void declaration
         */
        PngIconData(IconInfo iconInfo, BufferedImage bufferedImage) {
            super((IconInfo)var1_1);
            void var2_2;
            void var1_1;
            this.bufferedImage = var2_2;
        }

        @Override
        public final BufferedImage readBufferedImage() {
            return this.bufferedImage;
        }
    }
}

