/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.icns;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.icns.IcnsDecoder;
import org.apache.commons.imaging.formats.icns.IcnsImagingParameters;
import org.apache.commons.imaging.formats.icns.IcnsType;

public final class IcnsImageParser
extends AbstractImageParser<IcnsImagingParameters> {
    static final int ICNS_MAGIC = IcnsType.typeAsInt("icns");
    private static final String DEFAULT_EXTENSION = ImageFormats.ICNS.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.ICNS.getExtensions();

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.ICNS};
    }

    @Override
    public final List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        IcnsContents icnsContents;
        icnsContents = this.readImage((ByteSource)((Object)icnsContents));
        return IcnsDecoder.decodeAllImages(icnsContents.icnsElements);
    }

    /*
     * WARNING - void declaration
     */
    private IcnsContents readImage(ByteSource byteSource) throws ImagingException, IOException {
        IcnsContents icnsContents;
        block8: {
            InputStream is = byteSource.getInputStream();
            try {
                void var3_9;
                void var2_7;
                IcnsElement icnsElement;
                Object object = is;
                IcnsImageParser icnsImageParser = this;
                int n = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid ICNS File", icnsImageParser.getByteOrder());
                int n2 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a Valid ICNS File", icnsImageParser.getByteOrder());
                if (n != ICNS_MAGIC) {
                    throw new ImagingException("Not a Valid ICNS File: magic is 0x" + Integer.toHexString(n));
                }
                IcnsHeader icnsHeader = new IcnsHeader(n, n2);
                ArrayList<IcnsElement> icnsElementList = new ArrayList<IcnsElement>();
                for (int remainingSize = icnsHeader.fileSize - 8; remainingSize > 0; remainingSize -= icnsElement.elementSize) {
                    n = remainingSize;
                    object = is;
                    icnsImageParser = this;
                    n2 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a valid ICNS file", icnsImageParser.getByteOrder());
                    int n3 = BinaryFunctions.read4Bytes$47efdc82((InputStream)object, "Not a valid ICNS file", icnsImageParser.getByteOrder());
                    if (n3 > n) {
                        throw new IOException(String.format("Corrupted ICNS file: element size %d is greater than remaining size %d", n3, n));
                    }
                    object = BinaryFunctions.readBytes("Data", (InputStream)object, n3 - 8, "Not a valid ICNS file");
                    icnsElement = new IcnsElement(n2, n3, (byte[])object);
                    icnsElementList.add(icnsElement);
                }
                icnsContents = new IcnsContents((IcnsHeader)var2_7, var3_9.toArray(IcnsElement.EMPTY_ARRAY));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return icnsContents;
    }

    private static final class IcnsContents {
        public final IcnsHeader icnsHeader;
        public final IcnsElement[] icnsElements;

        /*
         * WARNING - void declaration
         */
        IcnsContents(IcnsHeader icnsHeader, IcnsElement[] icnsElements) {
            void var2_2;
            void var1_1;
            this.icnsHeader = var1_1;
            this.icnsElements = var2_2;
        }
    }

    private static final class IcnsHeader {
        public final int magic;
        public final int fileSize;

        /*
         * WARNING - void declaration
         */
        IcnsHeader(int magic, int fileSize) {
            void var2_2;
            void var1_1;
            this.magic = var1_1;
            this.fileSize = var2_2;
        }
    }

    static final class IcnsElement {
        static final IcnsElement[] EMPTY_ARRAY = new IcnsElement[0];
        public final int type;
        public final int elementSize;
        public final byte[] data;

        /*
         * WARNING - void declaration
         */
        IcnsElement(int type, int elementSize, byte[] data) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.type = var1_1;
            this.elementSize = var2_2;
            this.data = var3_3;
        }
    }
}

