/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.AbstractPixelParser;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

final class PixelParserRle
extends AbstractPixelParser {
    private static final Logger LOGGER = Logger.getLogger(PixelParserRle.class.getName());

    /*
     * WARNING - void declaration
     */
    PixelParserRle(BmpHeaderInfo bhi, byte[] colorTable, byte[] imageData) {
        super((BmpHeaderInfo)var1_1, (byte[])var2_2, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int[] convertDataToSamples(int data) throws ImagingException {
        void var2_2;
        int[] rgbs;
        if (this.bhi.bitsPerPixel == 8) {
            int[] nArray = new int[1];
            rgbs = nArray;
            nArray[0] = this.getColorTableRgb(data);
        } else if (this.bhi.bitsPerPixel == 4) {
            void var1_1;
            void var3_3;
            rgbs = new int[2];
            int sample1 = data >> 4;
            int sample2 = 0xF & data;
            rgbs[0] = this.getColorTableRgb((int)var3_3);
            rgbs[1] = this.getColorTableRgb((int)var1_1);
        } else {
            throw new ImagingException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        return var2_2;
    }

    private static int processByteOfData(int[] rgbs, int repeat, int x, int y, int width, int height, ImageBuilder imageBuilder) {
        int pixelsWritten = 0;
        for (int i = 0; i < repeat; ++i) {
            if (x >= 0 && x < width && y >= 0 && y < height) {
                int rgb = rgbs[i % rgbs.length];
                imageBuilder.setRgb(x, y, rgb);
            } else {
                LOGGER.fine("skipping bad pixel (" + x + "," + y + ")");
            }
            ++x;
            ++pixelsWritten;
        }
        return pixelsWritten;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void processImage(ImageBuilder imageBuilder) throws ImagingException, IOException {
        int width = this.bhi.width;
        int height = this.bhi.height;
        int x = 0;
        int y = height - 1;
        boolean done = false;
        block5: while (!done) {
            void var7_7;
            void var8_11;
            new StringBuilder("RLE (").append(x).append(",").append(y).append(") a");
            int a = 0xFF & BinaryFunctions.readByte$74534d56(this.is, "BMP: Bad RLE");
            new StringBuilder("RLE (").append(x).append(",").append(y).append(") b");
            int b = 0xFF & BinaryFunctions.readByte$74534d56(this.is, "BMP: Bad RLE");
            if (a == 0) {
                int n;
                switch (b) {
                    case 0: {
                        --y;
                        x = 0;
                        continue block5;
                    }
                    case 1: {
                        done = true;
                        continue block5;
                    }
                    case 2: {
                        int deltaX = 0xFF & BinaryFunctions.readByte$74534d56(this.is, "BMP: Bad RLE");
                        int deltaY = 0xFF & BinaryFunctions.readByte$74534d56(this.is, "BMP: Bad RLE");
                        x += deltaX;
                        y -= deltaY;
                        continue block5;
                    }
                }
                PixelParserRle deltaY = this;
                if (deltaY.bhi.bitsPerPixel == 8) {
                    n = 1;
                } else if (deltaY.bhi.bitsPerPixel == 4) {
                    n = 2;
                } else {
                    throw new ImagingException("BMP RLE: bad BitsPerPixel: " + deltaY.bhi.bitsPerPixel);
                }
                int samplesPerByte = n;
                int size = b / samplesPerByte;
                if (b % samplesPerByte > 0) {
                    ++size;
                }
                if (size % 2 != 0) {
                    ++size;
                }
                byte[] bytes = BinaryFunctions.readBytes("bytes", this.is, size, "RLE: Absolute Mode");
                int remaining = b;
                int i = 0;
                while (remaining > 0) {
                    int[] samples = this.convertDataToSamples(0xFF & bytes[i]);
                    int towrite = Math.min(remaining, samplesPerByte);
                    int written = PixelParserRle.processByteOfData(samples, towrite, x, y, width, height, imageBuilder);
                    x += written;
                    remaining -= written;
                    ++i;
                }
                continue;
            }
            int[] rgbs = this.convertDataToSamples((int)var8_11);
            x += PixelParserRle.processByteOfData(rgbs, (int)var7_7, x, y, width, height, imageBuilder);
        }
    }
}

