/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.bmp.AbstractPixelParserSimple;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

final class PixelParserBitFields
extends AbstractPixelParserSimple {
    private final int redShift;
    private final int greenShift;
    private final int blueShift;
    private final int alphaShift;
    private final int redMask;
    private final int greenMask;
    private final int blueMask;
    private final int alphaMask;
    private int byteCount;

    /*
     * WARNING - void declaration
     */
    PixelParserBitFields(BmpHeaderInfo bhi, byte[] colorTable, byte[] imageData) {
        super(bhi, (byte[])var2_2, (byte[])var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.redMask = bhi.redMask;
        this.greenMask = bhi.greenMask;
        this.blueMask = bhi.blueMask;
        this.alphaMask = var1_1.alphaMask;
        this.redShift = PixelParserBitFields.getMaskShift(this.redMask);
        this.greenShift = PixelParserBitFields.getMaskShift(this.greenMask);
        this.blueShift = PixelParserBitFields.getMaskShift(this.blueMask);
        this.alphaShift = this.alphaMask != 0 ? PixelParserBitFields.getMaskShift(this.alphaMask) : 0;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMaskShift(int mask) {
        void var2_2;
        void var1_1;
        if (mask == 0) {
            return 0;
        }
        int trailingZeroes = 0;
        while ((1 & mask) == 0) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++trailingZeroes;
        }
        int maskLength = 0;
        while ((1 & mask) == 1) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++maskLength;
        }
        return (int)(var1_1 - (8 - var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getNextRgb() throws ImagingException, IOException {
        void var3_3;
        void var2_2;
        int n;
        int data;
        switch (this.bhi.bitsPerPixel) {
            case 8: {
                data = 0xFF & this.imageData[this.byteCount + 0];
                ++this.byteCount;
                break;
            }
            case 24: {
                data = BinaryFunctions.read3Bytes$47efdc82(this.is, "BMP Image Data", ByteOrder.LITTLE_ENDIAN);
                this.byteCount += 3;
                break;
            }
            case 32: {
                data = BinaryFunctions.read4Bytes$47efdc82(this.is, "BMP Image Data", ByteOrder.LITTLE_ENDIAN);
                this.byteCount += 4;
                break;
            }
            case 16: {
                data = BinaryFunctions.read2Bytes$47efdc82(this.is, "BMP Image Data", ByteOrder.LITTLE_ENDIAN);
                this.byteCount += 2;
                break;
            }
            default: {
                throw new ImagingException("Unknown BitsPerPixel: " + this.bhi.bitsPerPixel);
            }
        }
        int red = this.redMask & data;
        int green = this.greenMask & data;
        int blue = this.blueMask & data;
        int alpha = this.alphaMask != 0 ? this.alphaMask & data : 255;
        red = this.redShift >= 0 ? red >> this.redShift : red << -this.redShift;
        green = this.greenShift >= 0 ? green >> this.greenShift : green << -this.greenShift;
        blue = this.blueShift >= 0 ? blue >> this.blueShift : blue << -this.blueShift;
        n = this.alphaShift >= 0 ? alpha >> this.alphaShift : n << -this.alphaShift;
        return n << 24 | var2_2 << 16 | var3_3 << 8 | blue << 0;
    }

    @Override
    public final void newline() throws ImagingException, IOException {
        while (this.byteCount % 4 != 0) {
            BinaryFunctions.readByte$74534d56(this.is, "BMP Image Data");
            ++this.byteCount;
        }
    }
}

