/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

abstract class AbstractPixelParser {
    final BmpHeaderInfo bhi;
    final byte[] colorTable;
    final byte[] imageData;
    final InputStream is;

    /*
     * WARNING - void declaration
     */
    AbstractPixelParser(BmpHeaderInfo bmpHeaderInfo, byte[] colorTable, byte[] imageData) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bhi = (BmpHeaderInfo)Objects.requireNonNull(var1_1, "bmpHeaderInfo");
        this.colorTable = var2_2;
        this.imageData = Objects.requireNonNull(imageData, "imageData");
        this.is = new ByteArrayInputStream((byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final int getColorTableRgb(int index) {
        void var2_2;
        void var3_3;
        void var1_1;
        int actual = index * 4;
        int blue = 0xFF & this.colorTable[actual + 0];
        int green = 0xFF & this.colorTable[actual + 1];
        int red = 0xFF & this.colorTable[actual + 2];
        return 0xFF000000 | var1_1 << 16 | var3_3 << 8 | var2_2 << 0;
    }

    public abstract void processImage(ImageBuilder var1) throws ImagingException, IOException;
}

