/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.util.Properties;
import org.apache.commons.imaging.common.Allocator;

public final class ImageBuilder {
    private final int[] data;
    private final int width;
    private final int height;
    private final boolean hasAlpha;
    private final boolean isAlphaPremultiplied;

    /*
     * WARNING - void declaration
     */
    public ImageBuilder(int width, int height, boolean hasAlpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        ImageBuilder.checkDimensions(width, height);
        this.data = Allocator.intArray(width * height);
        this.width = var1_1;
        this.height = var2_2;
        this.hasAlpha = var3_3;
        this.isAlphaPremultiplied = false;
    }

    /*
     * WARNING - void declaration
     */
    public ImageBuilder(int width, int height, boolean hasAlpha, boolean isAlphaPremultiplied) {
        void var3_3;
        void var2_2;
        void var1_1;
        ImageBuilder.checkDimensions(width, height);
        this.data = Allocator.intArray(width * height);
        this.width = var1_1;
        this.height = var2_2;
        this.hasAlpha = var3_3;
        this.isAlphaPremultiplied = isAlphaPremultiplied;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkDimensions(int width, int height) {
        void var1_1;
        if (width <= 0) {
            throw new RasterFormatException("zero or negative width value");
        }
        if (var1_1 <= 0) {
            throw new RasterFormatException("zero or negative height value");
        }
    }

    public final BufferedImage getBufferedImage() {
        ImageBuilder imageBuilder = this;
        boolean bl = this.hasAlpha;
        int n = this.height;
        int n2 = this.width;
        Object object = imageBuilder.data;
        Object object2 = imageBuilder;
        object = new DataBufferInt((int[])object, n2 * n);
        if (bl) {
            object2 = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, ((ImageBuilder)object2).isAlphaPremultiplied, 3);
            object = Raster.createPackedRaster((DataBuffer)object, n2, n, n2, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        } else {
            object2 = new DirectColorModel(24, 0xFF0000, 65280, 255);
            object = Raster.createPackedRaster((DataBuffer)object, n2, n, n2, new int[]{0xFF0000, 65280, 255}, null);
        }
        return new BufferedImage((ColorModel)object2, (WritableRaster)object, ((ColorModel)object2).isAlphaPremultiplied(), new Properties());
    }

    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public final int getRgb(int x, int y) {
        void var1_1;
        void var2_2;
        int rowOffset = y * this.width;
        return this.data[var2_2 + var1_1];
    }

    public final ImageBuilder getSubset(int x, int y, int w, int h) {
        int n = h;
        int n2 = w;
        int n3 = y;
        int n4 = x;
        ImageBuilder imageBuilder = this;
        if (n2 <= 0) {
            throw new RasterFormatException("negative or zero subimage width");
        }
        if (n <= 0) {
            throw new RasterFormatException("negative or zero subimage height");
        }
        if (n4 < 0 || n4 >= imageBuilder.width) {
            throw new RasterFormatException("subimage x is outside raster");
        }
        if (n4 + n2 > imageBuilder.width) {
            throw new RasterFormatException("subimage (x+width) is outside raster");
        }
        if (n3 < 0 || n3 >= imageBuilder.height) {
            throw new RasterFormatException("subimage y is outside raster");
        }
        if (n3 + n > imageBuilder.height) {
            throw new RasterFormatException("subimage (y+height) is outside raster");
        }
        ImageBuilder b = new ImageBuilder(w, h, this.hasAlpha, this.isAlphaPremultiplied);
        for (int i = 0; i < h; ++i) {
            int srcDex = (i + y) * this.width + x;
            int outDex = i * w;
            System.arraycopy(this.data, srcDex, b.data, outDex, w);
        }
        return b;
    }

    public final int getWidth() {
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRgb(int x, int y, int argb) {
        void var3_3;
        int n = Math.multiplyExact(y, this.width);
        int index = Math.addExact(n, x);
        if (index > this.data.length) {
            throw new IllegalArgumentException("setRGB: Illegal array index.");
        }
        this.data[var1_1] = var3_3;
    }
}

