/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.RationalNumber;

public final class ByteConversions {
    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(short value, ByteOrder byteOrder) {
        void var2_2;
        void var1_1;
        short s;
        byte[] result = new byte[2];
        short s2 = s;
        s = 0;
        byte[] byArray = result;
        s = s2;
        if (var1_1 == ByteOrder.BIG_ENDIAN) {
            byArray[0] = (byte)(s >> 8);
            byArray[1] = (byte)(s >> 0);
        } else {
            byArray[1] = (byte)(s >> 8);
            byArray[0] = (byte)(s >> 0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double toDouble(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteConversions.toDouble(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static double toDouble(byte[] bytes, int offset, ByteOrder byteOrder) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        long byte0 = 0xFFL & (long)bytes[offset + 0];
        long byte1 = 0xFFL & (long)bytes[offset + 1];
        long byte2 = 0xFFL & (long)bytes[offset + 2];
        long byte3 = 0xFFL & (long)bytes[offset + 3];
        long byte4 = 0xFFL & (long)bytes[offset + 4];
        long byte5 = 0xFFL & (long)bytes[offset + 5];
        long byte6 = 0xFFL & (long)bytes[offset + 6];
        long byte7 = 0xFFL & (long)byArray[var1_1 + 7];
        long bits = var2_2 == ByteOrder.BIG_ENDIAN ? byte0 << 56 | byte1 << 48 | byte2 << 40 | byte3 << 32 | byte4 << 24 | byte5 << 16 | byte6 << 8 | byte7 << 0 : byte7 << 56 | byte6 << 48 | byte5 << 40 | byte4 << 32 | byte3 << 24 | byte2 << 16 | byte1 << 8 | var3_3 << 0;
        return Double.longBitsToDouble(bits);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toDoubles(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        double[] dArray = Allocator.doubleArray(n / 8);
        Arrays.setAll(dArray, arg_0 -> ByteConversions.lambda$toDoubles$0(byArray2, 0, (ByteOrder)var2_6, arg_0));
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float toFloat(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteConversions.toFloat(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static float toFloat(byte[] bytes, int offset, ByteOrder byteOrder) {
        void var0_1;
        void var3_4;
        int bits;
        void var2_3;
        void var1_2;
        int byte0 = 0xFF & bytes[offset + 0];
        int byte1 = 0xFF & bytes[offset + 1];
        int byte2 = 0xFF & bytes[offset + 2];
        int byte3 = 0xFF & bytes[var1_2 + 3];
        bits = var2_3 == ByteOrder.BIG_ENDIAN ? byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3 << 0 : bits << 24 | byte2 << 16 | byte1 << 8 | var3_4 << 0;
        return Float.intBitsToFloat((int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toFloats(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        float[] fArray = Allocator.floatArray(n / 4);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ByteConversions.toFloat(byArray2, 0 + 4 * i, (ByteOrder)var2_6);
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(byte[] bytes, int offset, ByteOrder byteOrder) {
        void var3_4;
        void var0_1;
        void var2_3;
        void var1_2;
        int byte0 = 0xFF & bytes[offset + 0];
        int byte1 = 0xFF & bytes[offset + 1];
        int byte2 = 0xFF & bytes[offset + 2];
        int byte3 = 0xFF & bytes[var1_2 + 3];
        if (var2_3 == ByteOrder.BIG_ENDIAN) {
            return byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
        }
        return var0_1 << 24 | byte2 << 16 | byte1 << 8 | var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toInts(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        int[] nArray = Allocator.intArray(n / 4);
        Arrays.setAll(nArray, arg_0 -> ByteConversions.lambda$toInts$1(byArray2, 0, (ByteOrder)var2_6, arg_0));
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static long toLong(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteConversions.toLong(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static long toLong(byte[] bytes, int offset, ByteOrder byteOrder) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        long byte0 = 0xFFL & (long)bytes[offset + 0];
        long byte1 = 0xFFL & (long)bytes[offset + 1];
        long byte2 = 0xFFL & (long)bytes[offset + 2];
        long byte3 = 0xFFL & (long)bytes[offset + 3];
        long byte4 = 0xFFL & (long)bytes[offset + 4];
        long byte5 = 0xFFL & (long)bytes[offset + 5];
        long byte6 = 0xFFL & (long)bytes[offset + 6];
        long byte7 = 0xFFL & (long)byArray[var1_1 + 7];
        if (var2_2 == ByteOrder.BIG_ENDIAN) {
            return byte0 << 56 | byte1 << 48 | byte2 << 40 | byte3 << 32 | byte4 << 24 | byte5 << 16 | byte6 << 8 | byte7;
        }
        return byte7 << 56 | byte6 << 48 | byte5 << 40 | byte4 << 32 | byte3 << 24 | byte2 << 16 | byte1 << 8 | var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toLongs(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        long[] lArray = Allocator.longArray(n / 8);
        Arrays.setAll(lArray, arg_0 -> ByteConversions.lambda$toLongs$2(byArray2, 0, (ByteOrder)var2_6, arg_0));
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    public static RationalNumber toRational(byte[] bytes, ByteOrder byteOrder, boolean unsignedType) {
        void var2_2;
        void var1_1;
        return ByteConversions.toRational(bytes, 0, (ByteOrder)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static RationalNumber toRational(byte[] bytes, int offset, ByteOrder byteOrder, boolean unsignedType) {
        void var3_4;
        void var0_1;
        void var1_2;
        int divisor;
        int numerator;
        void var2_3;
        int byte0 = 0xFF & bytes[offset + 0];
        int byte1 = 0xFF & bytes[offset + 1];
        int byte2 = 0xFF & bytes[offset + 2];
        int byte3 = 0xFF & bytes[offset + 3];
        int byte4 = 0xFF & bytes[offset + 4];
        int byte5 = 0xFF & bytes[offset + 5];
        int byte6 = 0xFF & bytes[offset + 6];
        int byte7 = 0xFF & bytes[offset + 7];
        if (var2_3 == ByteOrder.BIG_ENDIAN) {
            numerator = byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
            divisor = byte4 << 24 | byte5 << 16 | byte6 << 8 | byte7;
        } else {
            numerator = byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0;
            divisor = divisor << 24 | byte6 << 16 | byte5 << 8 | byte4;
        }
        return new RationalNumber((int)var1_2, (int)var0_1, (boolean)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static RationalNumber[] toRationals(byte[] bytes, ByteOrder byteOrder, boolean unsignedType) {
        byte[] byArray;
        void var1_3;
        void var2_6;
        void var3_8 = var2_6;
        void var2_7 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        RationalNumber[] rationalNumberArray = new RationalNumber[n / 8];
        Arrays.setAll(rationalNumberArray, arg_0 -> ByteConversions.lambda$toRationals$3(byArray2, 0, (ByteOrder)var2_7, (boolean)var3_8, arg_0));
        return rationalNumberArray;
    }

    /*
     * WARNING - void declaration
     */
    public static short toShort(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        void var2_3 = var1_1;
        int n = 0;
        byte[] byArray = bytes;
        return (short)ByteConversions.toUInt16(bytes, n, (ByteOrder)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toShorts(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        short[] sArray = Allocator.shortArray(n / 2);
        for (int i = 0; i < sArray.length; ++i) {
            void var6_10 = var2_6;
            int n2 = 0 + 2 * i;
            byte[] byArray3 = byArray2;
            sArray[i] = (short)ByteConversions.toUInt16(byArray2, n2, (ByteOrder)var6_10);
        }
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int toUInt16(byte[] bytes, int offset, ByteOrder byteOrder) {
        void var3_4;
        void var0_1;
        void var2_3;
        void var1_2;
        int byte0 = 0xFF & bytes[offset + 0];
        int byte1 = 0xFF & bytes[var1_2 + true];
        if (var2_3 == ByteOrder.BIG_ENDIAN) {
            return byte0 << 8 | byte1;
        }
        return var0_1 << 8 | var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toUInt16s(byte[] bytes, ByteOrder byteOrder) {
        byte[] byArray;
        void var1_3;
        void var2_6 = var1_3;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        int[] nArray = Allocator.intArray(n / 2);
        Arrays.setAll(nArray, arg_0 -> ByteConversions.lambda$toUInt16s$4(byArray2, 0, (ByteOrder)var2_6, arg_0));
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$toUInt16s$4(byte[] bytes, int offset, ByteOrder byteOrder, int i) {
        void var2_2;
        void var3_3;
        void var1_1;
        return ByteConversions.toUInt16(bytes, (int)(var1_1 + 2 * var3_3), (ByteOrder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ RationalNumber lambda$toRationals$3(byte[] bytes, int offset, ByteOrder byteOrder, boolean unsignedType, int i) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ByteConversions.toRational(bytes, (int)(var1_1 + 8 * i), (ByteOrder)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$toLongs$2(byte[] bytes, int offset, ByteOrder byteOrder, int i) {
        void var2_2;
        void var3_3;
        void var1_1;
        return ByteConversions.toLong(bytes, (int)(var1_1 + 8 * var3_3), (ByteOrder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$toInts$1(byte[] bytes, int offset, ByteOrder byteOrder, int i) {
        void var2_2;
        void var3_3;
        void var1_1;
        return ByteConversions.toInt(bytes, (int)(var1_1 + 4 * var3_3), (ByteOrder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ double lambda$toDoubles$0(byte[] bytes, int offset, ByteOrder byteOrder, int i) {
        void var2_2;
        void var3_3;
        void var1_1;
        return ByteConversions.toDouble(bytes, (int)(var1_1 + 8 * var3_3), (ByteOrder)var2_2);
    }
}

