/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Map;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;

public final class BasicCParser {
    private final PushbackInputStream is;

    /*
     * WARNING - void declaration
     */
    private static int appendHex(int i, StringBuilder stringBuilder, String string) throws ImagingException {
        int n;
        void var2_4;
        void var1_2;
        if (i + 2 >= string.length()) {
            throw new ImagingException("Parsing XPM file failed, hex constant in string too short");
        }
        char hex1 = string.charAt(i + 1);
        char hex2 = string.charAt(i + 2);
        i += 2;
        try {
            void var3_5;
            int constant = Integer.parseInt((char)var3_5 + Character.toString(hex2), 16);
        }
        catch (NumberFormatException nfe) {
            void var0_1;
            throw new ImagingException("Parsing XPM file failed, hex constant invalid", (Throwable)var0_1);
        }
        var1_2.append((char)var2_4);
        return n;
    }

    public static ByteArrayOutputStream preprocess(InputStream is, StringBuilder firstComment, Map<String, String> defines) throws IOException, ImagingException {
        boolean inSingleQuotes = false;
        boolean inString = false;
        boolean inComment = false;
        boolean inDirective = false;
        boolean hadSlash = false;
        boolean hadStar = false;
        boolean hadBackSlash = false;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean seenFirstComment = firstComment == null;
        StringBuilder directiveBuffer = new StringBuilder();
        int c = is.read();
        while (c != -1) {
            int n;
            if (inComment) {
                if (c == 42) {
                    if (hadStar && !seenFirstComment) {
                        firstComment.append('*');
                    }
                    hadStar = true;
                } else if (c == 47) {
                    if (hadStar) {
                        hadStar = false;
                        inComment = false;
                        seenFirstComment = true;
                    } else if (!seenFirstComment) {
                        firstComment.append((char)c);
                    }
                } else {
                    if (hadStar && !seenFirstComment) {
                        firstComment.append('*');
                    }
                    hadStar = false;
                    if (!seenFirstComment) {
                        firstComment.append((char)c);
                    }
                }
            } else if (inSingleQuotes) {
                switch (c) {
                    case 92: {
                        if (hadBackSlash) {
                            out.write(92);
                            out.write(92);
                            hadBackSlash = false;
                            break;
                        }
                        hadBackSlash = true;
                        break;
                    }
                    case 39: {
                        if (hadBackSlash) {
                            out.write(92);
                            hadBackSlash = false;
                        } else {
                            inSingleQuotes = false;
                        }
                        out.write(39);
                        break;
                    }
                    case 10: 
                    case 13: {
                        throw new ImagingException("Unterminated single quote in file");
                    }
                    default: {
                        if (hadBackSlash) {
                            out.write(92);
                            hadBackSlash = false;
                        }
                        out.write(c);
                        break;
                    }
                }
            } else if (inString) {
                switch (c) {
                    case 92: {
                        if (hadBackSlash) {
                            out.write(92);
                            out.write(92);
                            hadBackSlash = false;
                            break;
                        }
                        hadBackSlash = true;
                        break;
                    }
                    case 34: {
                        if (hadBackSlash) {
                            out.write(92);
                            hadBackSlash = false;
                        } else {
                            inString = false;
                        }
                        out.write(34);
                        break;
                    }
                    case 10: 
                    case 13: {
                        throw new ImagingException("Unterminated string in file");
                    }
                    default: {
                        if (hadBackSlash) {
                            out.write(92);
                            hadBackSlash = false;
                        }
                        out.write(c);
                        break;
                    }
                }
            } else if (inDirective) {
                if (c == 13 || c == 10) {
                    inDirective = false;
                    String[] tokens = BasicCParser.tokenizeRow(directiveBuffer.toString());
                    if (tokens.length < 2 || tokens.length > 3) {
                        throw new ImagingException("Bad preprocessor directive");
                    }
                    if (!tokens[0].equals("define")) {
                        throw new ImagingException("Invalid/unsupported preprocessor directive '" + tokens[0] + "'");
                    }
                    defines.put(tokens[1], tokens.length == 3 ? tokens[2] : null);
                    directiveBuffer.setLength(0);
                } else {
                    directiveBuffer.append((char)n);
                }
            } else {
                switch (n) {
                    case 47: {
                        if (hadSlash) {
                            out.write(47);
                        }
                        hadSlash = true;
                        break;
                    }
                    case 42: {
                        if (hadSlash) {
                            inComment = true;
                            hadSlash = false;
                            break;
                        }
                        out.write(n);
                        break;
                    }
                    case 39: {
                        if (hadSlash) {
                            out.write(47);
                        }
                        hadSlash = false;
                        out.write(n);
                        inSingleQuotes = true;
                        break;
                    }
                    case 34: {
                        if (hadSlash) {
                            out.write(47);
                        }
                        hadSlash = false;
                        out.write(n);
                        inString = true;
                        break;
                    }
                    case 35: {
                        if (defines == null) {
                            throw new ImagingException("Unexpected preprocessor directive");
                        }
                        inDirective = true;
                        break;
                    }
                    default: {
                        if (hadSlash) {
                            out.write(47);
                        }
                        hadSlash = false;
                        out.write(n);
                        if (n == 32 || n == 9 || n == 13 || n == 10) break;
                        seenFirstComment = true;
                    }
                }
            }
            n = is.read();
        }
        if (hadSlash) {
            out.write(47);
        }
        if (hadStar) {
            out.write(42);
        }
        if (inString) {
            throw new ImagingException("Unterminated string at the end of file");
        }
        if (inComment) {
            throw new ImagingException("Unterminated comment at the end of file");
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] tokenizeRow(String row) {
        String[] stringArray;
        String[] tokens = row.split("[ \t]");
        int numLiveTokens = 0;
        String[] stringArray2 = tokens;
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            String token = stringArray2[i];
            if (token == null || token.isEmpty()) continue;
            ++numLiveTokens;
        }
        String[] liveTokens = (String[])Allocator.array(numLiveTokens, String[]::new, 24);
        int next = 0;
        String[] stringArray3 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            String token = stringArray3[i];
            if (token == null || token.isEmpty()) continue;
            liveTokens[next++] = var1_3;
        }
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static void unescapeString(StringBuilder stringBuilder, String string) throws ImagingException {
        void var2_2;
        block27: {
            block26: {
                if (string.length() < 2) {
                    throw new ImagingException("Parsing XPM file failed, string is too short");
                }
                if (string.charAt(0) != '\"') break block26;
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == '\"') break block27;
            }
            throw new ImagingException("Parsing XPM file failed, string not surrounded by '\"'");
        }
        int hadBackSlash = 0;
        for (int i22 = 1; i22 < string.length() - 1; ++i22) {
            char c2 = string.charAt(i22);
            if (hadBackSlash != 0) {
                String c2 = string;
                StringBuilder i22 = stringBuilder;
                hadBackSlash = i22;
                int n = c2.charAt(hadBackSlash);
                switch (n) {
                    case 92: {
                        i22.append('\\');
                        break;
                    }
                    case 34: {
                        i22.append('\"');
                        break;
                    }
                    case 39: {
                        i22.append('\'');
                        break;
                    }
                    case 120: {
                        hadBackSlash = BasicCParser.appendHex(hadBackSlash, i22, c2);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        n = 1;
                        if (hadBackSlash + 1 < c2.length() && '0' <= c2.charAt(hadBackSlash + 1) && c2.charAt(hadBackSlash + 1) <= '7') {
                            ++n;
                        }
                        if (hadBackSlash + 2 < c2.length() && '0' <= c2.charAt(hadBackSlash + 2) && c2.charAt(hadBackSlash + 2) <= '7') {
                            ++n;
                        }
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            n2 *= 8;
                            n2 += c2.charAt(hadBackSlash + i) - 48;
                        }
                        hadBackSlash += n - 1;
                        i22.append((char)n2);
                        break;
                    }
                    case 97: {
                        i22.append('\u0007');
                        break;
                    }
                    case 98: {
                        i22.append('\b');
                        break;
                    }
                    case 102: {
                        i22.append('\f');
                        break;
                    }
                    case 110: {
                        i22.append('\n');
                        break;
                    }
                    case 114: {
                        i22.append('\r');
                        break;
                    }
                    case 116: {
                        i22.append('\t');
                        break;
                    }
                    case 118: {
                        i22.append('\u000b');
                        break;
                    }
                    default: {
                        throw new ImagingException("Parsing XPM file failed, invalid escape sequence");
                    }
                }
                i22 = hadBackSlash;
                hadBackSlash = 0;
                continue;
            }
            if (c2 == '\\') {
                hadBackSlash = 1;
                continue;
            }
            if (c2 == '\"') {
                throw new ImagingException("Parsing XPM file failed, extra '\"' found in string");
            }
            stringBuilder.append(c2);
        }
        if (var2_2 != false) {
            throw new ImagingException("Parsing XPM file failed, unterminated escape sequence found in string");
        }
    }

    /*
     * WARNING - void declaration
     */
    public BasicCParser(ByteArrayInputStream is) {
        void var1_1;
        this.is = new PushbackInputStream((InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String nextToken() throws IOException, ImagingException {
        void var1_1;
        void var2_2;
        boolean inString = false;
        boolean inIdentifier = false;
        boolean hadBackSlash = false;
        StringBuilder token = new StringBuilder();
        int c = this.is.read();
        while (c != -1) {
            if (inString) {
                switch (c) {
                    case 92: {
                        token.append('\\');
                        hadBackSlash = !hadBackSlash;
                        break;
                    }
                    case 34: {
                        token.append('\"');
                        if (!hadBackSlash) {
                            return token.toString();
                        }
                        hadBackSlash = false;
                        break;
                    }
                    case 10: 
                    case 13: {
                        throw new ImagingException("Unterminated string in XPM file");
                    }
                    default: {
                        token.append((char)c);
                        hadBackSlash = false;
                        break;
                    }
                }
            } else if (inIdentifier) {
                if (!Character.isLetterOrDigit(c) && c != 95) {
                    this.is.unread(c);
                    return token.toString();
                }
                token.append((char)c);
            } else if (c == 34) {
                token.append('\"');
                inString = true;
            } else if (Character.isLetterOrDigit(c) || c == 95) {
                token.append((char)c);
                inIdentifier = true;
            } else {
                if (c == 123 || c == 125 || c == 91 || c == 93 || c == 42 || c == 59 || c == 61 || c == 44) {
                    token.append((char)c);
                    return token.toString();
                }
                if (c != 32 && c != 9 && c != 13 && c != 10) {
                    throw new ImagingException("Unhandled/invalid character '" + (char)c + "' found in XPM file");
                }
            }
            c = this.is.read();
        }
        if (var2_2 != false) {
            return token.toString();
        }
        if (var1_1 != false) {
            throw new ImagingException("Unterminated string ends XMP file");
        }
        return null;
    }
}

