/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.commons.imaging.common.AllocationRequestException;

public class Allocator {
    private static final String CANONICAL_NAME = Allocator.class.getCanonicalName();
    private static final int LIMIT = Integer.getInteger(CANONICAL_NAME, 0x40000000);

    /*
     * WARNING - void declaration
     */
    public static <T> T[] array(int request, IntFunction<T[]> factory, int eltShallowByteSize) {
        int n;
        void var1_1;
        void var2_2;
        Allocator.check(request * var2_2);
        return (Object[])var1_1.apply(n);
    }

    public static <T> ArrayList<T> arrayList(int request) {
        int n;
        Allocator.check(24 + request * 4);
        IntFunction<ArrayList> intFunction = ArrayList::new;
        return intFunction.apply(Allocator.check(n));
    }

    public static byte[] byteArray(int request) {
        int n = request;
        return new byte[Allocator.check(n, 1)];
    }

    public static int check(int request) {
        int n;
        if (request > LIMIT) {
            throw new AllocationRequestException(LIMIT, request);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int check(int request, int elementSize) {
        int n;
        void var2_2;
        try {
            int multiplyExact = Math.multiplyExact(request, elementSize);
        }
        catch (ArithmeticException e) {
            void var1_1;
            throw new AllocationRequestException(LIMIT, BigInteger.valueOf(request).multiply(BigInteger.valueOf((long)var1_1)), e);
        }
        if (var2_2 > LIMIT) {
            throw new AllocationRequestException(LIMIT, request);
        }
        return n;
    }

    public static int checkByteArray(int request) {
        return Allocator.check(request, 1);
    }

    public static double[] doubleArray(int request) {
        return new double[Allocator.check(request, 8)];
    }

    public static float[] floatArray(int request) {
        return new float[Allocator.check(request, 4)];
    }

    public static int[] intArray(int request) {
        return new int[Allocator.check(request, 4)];
    }

    public static long[] longArray(int request) {
        return new long[Allocator.check(request, 8)];
    }

    public static short[] shortArray(int request) {
        return new short[Allocator.check(request, 2)];
    }
}

