/*
 * Decompiled with CFR 0.152.
 */
package application.shared.ui.theme;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import application.core.settings.UiMode;
import application.shared.ui.theme.LinuxFreeDesktopKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.SystemTheme;
import org.jetbrains.skiko.SystemTheme_awtKt;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;

@SourceDebugExtension(value={"SMAP\nAppTheme.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppTheme.desktop.kt\napplication/shared/ui/theme/AppTheme_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class AppTheme_desktopKt {
    public static final UiMode platformUiMode() {
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                return AppTheme_desktopKt.linuxUiMode();
            }
            case 2: {
                return AppTheme_desktopKt.skikoUiMode();
            }
            case 3: {
                return AppTheme_desktopKt.skikoUiMode();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final UiMode linuxUiMode() {
        UiMode uiMode;
        try {
            UiMode uiMode2 = uiMode = (UiMode)LinuxFreeDesktopKt.readFreeDesktopSetting("org.freedesktop.appearance", "color-scheme", AppTheme_desktopKt::freeDesktopUiMode$lambda$1);
            Object object = uiMode != UiMode.Unknown ? uiMode : null;
            if (object == null) {
                object = AppTheme_desktopKt.skikoUiMode();
            }
            uiMode = object;
        }
        catch (Exception exception) {
            uiMode = AppTheme_desktopKt.skikoUiMode();
        }
        return uiMode;
    }

    private static final UiMode skikoUiMode() {
        switch (WhenMappings.$EnumSwitchMapping$1[SystemTheme_awtKt.getCurrentSystemTheme().ordinal()]) {
            case 1: {
                return UiMode.Dark;
            }
            case 2: {
                return UiMode.Light;
            }
            case 3: {
                return UiMode.Unknown;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final void PlatformAppTheme(boolean isDark, Composer $composer, int $changed) {
        void var1_1;
        $composer = $composer.startRestartGroup(158500913);
        if (($changed & 1) != 0 || !$composer.getSkipping()) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)158500913, (int)$changed, (int)-1, (String)"application.shared.ui.theme.PlatformAppTheme (AppTheme.desktop.kt:44)");
            }
            if (ComposerKt.isTraceInProgress()) {
                // empty if block
            }
        } else {
            $composer.skipToGroupEnd();
        }
        ScopeUpdateScope scopeUpdateScope = var1_1.endRestartGroup();
        if (scopeUpdateScope != null) {
            void var2_2;
            boolean bl;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> AppTheme_desktopKt.PlatformAppTheme$lambda$2(bl, (int)var2_2, arg_0, arg_1));
            return;
        }
    }

    private static final UiMode freeDesktopUiMode$lambda$1(String output) {
        String string;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (Intrinsics.areEqual((Object)string, (Object)"(<<uint32 1>>,)")) {
            return UiMode.Dark;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"(<<uint32 2>>,)")) {
            return UiMode.Light;
        }
        return UiMode.Unknown;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit PlatformAppTheme$lambda$2(boolean $isDark, int $$changed, Composer $composer, int $force) {
        void var1_1;
        void var2_2;
        AppTheme_desktopKt.PlatformAppTheme($isDark, (Composer)var2_2, RecomposeScopeImplKt.updateChangedFlags((int)(var1_1 | 1)));
        return Unit.INSTANCE;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SystemTheme.values().length];
            try {
                nArray[SystemTheme.DARK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SystemTheme.LIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SystemTheme.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

