/*
 * Decompiled with CFR 0.152.
 */
package application.shared.ui.system;

import androidx.compose.runtime.internal.StabilityInferred;
import application.core.i18n.I18N;
import application.core.notifications.Notifications;
import application.presentation.system.DefaultBrowserHandler;
import application.shared.ui.system.LinuxDefaultBrowserHandler;
import application.shared.ui.system.MacDefaultBrowserHandler;
import application.shared.ui.system.WindowsDefaultBrowserHandler;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;

@StabilityInferred(parameters=0)
public final class DesktopDefaultBrowserHandler
implements DefaultBrowserHandler {
    private final DefaultBrowserHandler delegate;
    public static final int $stable = 8;

    public DesktopDefaultBrowserHandler(String appQualifiedName, Notifications notifications, I18N i18n) {
        Intrinsics.checkNotNullParameter((Object)appQualifiedName, (String)"appQualifiedName");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.delegate = switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1 -> new LinuxDefaultBrowserHandler();
            case 2 -> {
                void var1_1;
                yield new MacDefaultBrowserHandler((String)var1_1, notifications, i18n, null, 8, null);
            }
            case 3 -> {
                void var3_3;
                void var2_2;
                yield new WindowsDefaultBrowserHandler((Notifications)var2_2, (I18N)var3_3, null, 4, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Object queryCanBeSetAsDefaultBrowser(Continuation<? super Boolean> $completion) {
        void var1_1;
        return this.delegate.queryCanBeSetAsDefaultBrowser((Continuation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Object queryIsDefaultBrowser(Continuation<? super Boolean> $completion) {
        void var1_1;
        return this.delegate.queryIsDefaultBrowser((Continuation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Object requestSetAsDefaultBrowser(Function0<Unit> onDone, Continuation<? super Unit> $completion) {
        void var2_2;
        void var1_1;
        Object object = this.delegate.requestSetAsDefaultBrowser((Function0)var1_1, (Continuation)var2_2);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

