/*
 * Decompiled with CFR 0.152.
 */
package application.shared.desktop.platform;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import shared.system.process.DesktopSystemKt;

@SourceDebugExtension(value={"SMAP\nWindowsInstallation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsInstallation.kt\napplication/shared/desktop/platform/WindowsInstallationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n669#2,11:56\n1611#2,9:67\n1863#2:76\n1864#2:78\n1620#2:79\n1#3:77\n*S KotlinDebug\n*F\n+ 1 WindowsInstallation.kt\napplication/shared/desktop/platform/WindowsInstallationKt\n*L\n20#1:56,11\n37#1:67,9\n37#1:76\n37#1:78\n37#1:79\n37#1:77\n*E\n"})
public final class WindowsInstallationKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(WindowsInstallationKt::logger$lambda$0);
    private static final Lazy isManagedWindowsInstallation$delegate = LazyKt.lazy(WindowsInstallationKt::isManagedWindowsInstallation_delegate$lambda$1);
    private static final Lazy windowsAUMID$delegate = LazyKt.lazy(WindowsInstallationKt::windowsAUMID_delegate$lambda$6);
    private static final Lazy windowsRegistryProgramIdentifiers$delegate = LazyKt.lazy(WindowsInstallationKt::windowsRegistryProgramIdentifiers_delegate$lambda$10);

    public static final boolean isManagedWindowsInstallation() {
        Lazy lazy = isManagedWindowsInstallation$delegate;
        return (Boolean)lazy.getValue();
    }

    public static final String getWindowsAUMID() {
        Lazy lazy = windowsAUMID$delegate;
        return (String)lazy.getValue();
    }

    public static final List<String> getWindowsRegistryProgramIdentifiers() {
        Lazy lazy = windowsRegistryProgramIdentifiers$delegate;
        return (List)lazy.getValue();
    }

    public static final String getWindowsRegistryProgramIdentifier() {
        return (String)CollectionsKt.first(WindowsInstallationKt.getWindowsRegistryProgramIdentifiers());
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean isManagedWindowsInstallation_delegate$lambda$1() {
        String string = System.getenv("APPDATA");
        if (string != null) {
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"\\Packages\\Flechette_", (boolean)false, (int)2, null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final String windowsAUMID_delegate$lambda$6$lambda$3(String output) {
        Object object;
        Iterable iterable;
        block3: {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Iterable $this$singleOrNull$iv = StringsKt.lines((CharSequence)output);
            Object single$iv = null;
            boolean found$iv = false;
            iterable = iterable.iterator();
            while (iterable.hasNext()) {
                void var3_3;
                Object element$iv = iterable.next();
                String string = (String)element$iv;
                if (!StringsKt.startsWith$default((String)string, (String)"Flechette", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    object = null;
                    break block3;
                }
                single$iv = var3_3;
                found$iv = true;
            }
            object = var2_2 == false ? null : var1_1;
        }
        iterable = (String)object;
        if (iterable != null && (iterable = StringsKt.substringAfter$default((String)((Object)iterable), (String)"Flechette", null, (int)2, null)) != null) {
            return ((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)iterable)))).toString();
        }
        return null;
    }

    private static final Object windowsAUMID_delegate$lambda$6$lambda$5$lambda$4(String $aumid) {
        return "Windows AUMID = " + $aumid;
    }

    /*
     * WARNING - void declaration
     */
    private static final String windowsAUMID_delegate$lambda$6() {
        void var1_1;
        String[] stringArray = new String[3];
        Object object = stringArray;
        stringArray[0] = "powershell.exe";
        object[1] = "-Command";
        object[2] = "Get-StartApps Flechette";
        object = DesktopSystemKt.systemCommandLineOutputOf((String[])object, WindowsInstallationKt::windowsAUMID_delegate$lambda$6$lambda$3);
        String aumid = (String)object;
        logger.info(() -> WindowsInstallationKt.windowsAUMID_delegate$lambda$6$lambda$5$lambda$4((String)var1_1));
        return (String)object;
    }

    private static final Object windowsRegistryProgramIdentifiers_delegate$lambda$10$lambda$9$lambda$8(List $progIDs) {
        return "Windows Registry Valid Program IDs " + $progIDs;
    }

    /*
     * WARNING - void declaration
     */
    private static final List windowsRegistryProgramIdentifiers_delegate$lambda$10() {
        void var1_1;
        List list;
        List list2;
        String aumid = WindowsInstallationKt.getWindowsAUMID();
        if (aumid == null) {
            list2 = CollectionsKt.listOf((Object)"Flechette");
        } else {
            void var3_3;
            String classesKey = "Software\\Classes";
            String[] stringArray = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)classesKey);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"registryGetKeys(...)");
            Object object = ArraysKt.toList((Object[])stringArray);
            object = (Iterable)object;
            Collection destination$iv$iv = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                String string;
                String valueName;
                Object e;
                Object e2 = object.next();
                e2 = e2;
                String className = (String)e;
                String appKey = classesKey + "\\" + className + "\\Application";
                if ((Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)appKey, (String)(valueName = "AppUserModelID")) ? (Intrinsics.areEqual((Object)(string = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)appKey, (String)valueName)), (Object)aumid) ? className : null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)var3_3;
            list2 = CollectionsKt.sorted((Iterable)list);
        }
        list = list2;
        List progIDs = list2;
        logger.info(() -> WindowsInstallationKt.windowsRegistryProgramIdentifiers_delegate$lambda$10$lambda$9$lambda$8((List)var1_1));
        return list;
    }
}

