/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import java.io.IOException;
import java.lang.reflect.Field;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.CNRLinkFlags;

public final class CNRLink
implements Serializable {
    private CNRLinkFlags flags;
    private int nptype;
    private String netname;
    private String devname;

    public CNRLink() {
        this.flags = new CNRLinkFlags(0).setValidNetType();
        this.nptype = 131072;
        this.netname = "";
    }

    /*
     * WARNING - void declaration
     */
    public CNRLink(ByteReader data) throws ShellLinkException, IOException {
        int dnoffset;
        int nnoffset;
        int size;
        int pos;
        block10: {
            pos = data.getPosition();
            size = (int)data.read4bytes();
            if (size < 20) {
                throw new ShellLinkException();
            }
            this.flags = new CNRLinkFlags(data);
            nnoffset = (int)data.read4bytes();
            dnoffset = (int)data.read4bytes();
            if (!this.flags.isValidDevice()) {
                dnoffset = 0;
            }
            this.nptype = (int)data.read4bytes();
            if (this.flags.isValidNetType()) {
                int n = this.nptype;
                Field[] fieldArray = this;
                for (Field field : fieldArray.getClass().getFields()) {
                    try {
                        if ((field.getModifiers() & 0x19) != 25 || n != (Integer)field.get(null)) continue;
                        break block10;
                    }
                    catch (Exception exception) {}
                }
                throw new ShellLinkException("incorrect network type");
            }
            this.nptype = 0;
        }
        int nnoffset_u = 0;
        int dnoffset_u = 0;
        if (nnoffset > 20) {
            nnoffset_u = (int)data.read4bytes();
            dnoffset_u = (int)data.read4bytes();
        }
        data.seek(pos + nnoffset - data.getPosition());
        this.netname = data.readString(pos + size - data.getPosition());
        if (dnoffset != 0) {
            data.seek(pos + dnoffset - data.getPosition());
            this.devname = data.readString(pos + size - data.getPosition());
        }
        if (nnoffset_u != 0) {
            this.netname = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        if (dnoffset_u != 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.devname = data.readUnicodeString((int)(var2_2 + var3_3 - var1_1.getPosition() >> 1));
        }
    }

    public final String getNetName() {
        return this.netname;
    }
}

