/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class ByteReader
extends InputStream {
    private boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private InputStream stream;
    private int pos = 0;

    /*
     * WARNING - void declaration
     */
    public ByteReader(InputStream in) {
        void var1_1;
        this.stream = var1_1;
    }

    public final int getPosition() {
        return this.pos;
    }

    public final ByteReader changeEndiannes() {
        this.le = !this.le;
        return this;
    }

    public final boolean seek(int n) throws IOException {
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            this.read();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int result = this.stream.read(b, (int)var2_3, (int)var3_4);
        this.pos += result;
        return (int)var1_2;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    /*
     * WARNING - void declaration
     */
    public final long read2bytes() throws IOException {
        void var1_1;
        void var3_2;
        long b0 = this.read();
        long b1 = this.read();
        if (this.le) {
            return b0 | b1 << 8;
        }
        return (long)(var3_2 | var1_1 << 8);
    }

    /*
     * WARNING - void declaration
     */
    public final long read4bytes() throws IOException {
        void var1_1;
        void var3_2;
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24;
        }
        return b3 | b2 << 8 | var3_2 << 16 | var1_1 << 24;
    }

    /*
     * WARNING - void declaration
     */
    public final long read6bytes() throws IOException {
        void var1_1;
        void var3_2;
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40;
        }
        return b5 | b4 << 8 | b3 << 16 | b2 << 24 | var3_2 << 32 | var1_1 << 40;
    }

    /*
     * WARNING - void declaration
     */
    public final long read8bytes() throws IOException {
        void var1_1;
        void var3_2;
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        long b6 = this.read();
        long b7 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40 | b6 << 48 | b7 << 56;
        }
        return b7 | b6 << 8 | b5 << 16 | b4 << 24 | b3 << 32 | b2 << 40 | var3_2 << 48 | var1_1 << 56;
    }

    /*
     * WARNING - void declaration
     */
    public final String readString(int sz) throws IOException {
        void var3_3;
        void var2_2;
        int b;
        int i;
        if (sz == 0) {
            return null;
        }
        byte[] buf = new byte[sz];
        for (i = 0; i < sz && (b = this.read()) != 0; ++i) {
            buf[i] = (byte)b;
        }
        if (i == 0) {
            return null;
        }
        return new String((byte[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String readUnicodeString(int sz) throws IOException {
        void var3_3;
        void var2_2;
        char c;
        int i;
        if (sz == 0) {
            return null;
        }
        char[] buf = new char[sz];
        for (i = 0; i < sz && (c = (char)this.read2bytes()) != '\u0000'; ++i) {
            buf[i] = c;
        }
        if (i == 0) {
            return null;
        }
        return new String((char[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String readUnicodeString() throws IOException {
        void var2_2;
        int c = (int)this.read2bytes();
        char[] buf = new char[c];
        for (int i = 0; i < c; ++i) {
            buf[i] = (char)this.read2bytes();
        }
        return new String((char[])var2_2);
    }
}

