/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSNull;
import com.dd.plist.NSObject;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class NSSet
extends NSObject {
    private final Set<NSObject> set;
    private boolean ordered = false;

    public NSSet() {
        this.set = new LinkedHashSet<NSObject>();
    }

    /*
     * WARNING - void declaration
     */
    public NSSet(boolean ordered) {
        void var1_1;
        this.ordered = ordered;
        this.set = var1_1 != false ? new TreeSet() : new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private NSSet(boolean ordered, NSObject ... objects) {
        this((boolean)var1_1);
        void var2_2;
        void var1_1;
        this.set.addAll(Arrays.stream(var2_2).map(NSNull::wrap).collect(Collectors.toCollection(ArrayList::new)));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addObject(NSObject obj) {
        void var1_1;
        this.set.add(NSNull.wrap((NSObject)var1_1));
    }

    public final synchronized NSObject[] allObjects() {
        return (NSObject[])this.set.stream().map(NSNull::unwrap).toArray(NSObject[]::new);
    }

    public final int hashCode() {
        int n = 203 + (this.set != null ? this.set.hashCode() : 0);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((NSObject)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private int compareTo(NSObject o) {
        void var1_1;
        Objects.requireNonNull(o);
        if (o == this) {
            return 0;
        }
        if (o instanceof NSSet) {
            NSSet other = (NSSet)o;
            if (other.count() != this.count()) {
                return Integer.compare(this.count(), other.count());
            }
            NSObject[] thisObjects = this.allObjects();
            NSObject[] otherObjects = other.allObjects();
            for (int i = 0; i < this.count(); ++i) {
                int itemDiff = NSNull.wrap(thisObjects[i]).compareTo(NSNull.wrap(otherObjects[i]));
                if (itemDiff == 0) continue;
                return itemDiff;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(var1_1.getClass().getName());
    }

    public final synchronized int count() {
        return this.set.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private NSSet clone() {
        void var1_1;
        NSObject[] clonedSet = new NSObject[this.set.size()];
        int i = 0;
        for (NSObject element : this.set) {
            clonedSet[i++] = element != null ? element.clone() : null;
        }
        return new NSSet(this.ordered, (NSObject[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object toJavaObject() {
        void var1_1;
        AbstractSet clonedSet = this.ordered ? new TreeSet() : new LinkedHashSet(this.set.size());
        for (NSObject o : this.set) {
            void var3_3;
            clonedSet.add(var3_3.toJavaObject());
        }
        return var1_1;
    }
}

