/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.LocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNull;
import com.dd.plist.NSNumber;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class NSObject
implements Cloneable,
Comparable<NSObject> {
    static final String NEWLINE = System.lineSeparator();
    private LocationInformation locationInformation;

    /*
     * WARNING - void declaration
     */
    final void setLocationInformation(LocationInformation locationInformation) {
        void var1_1;
        this.locationInformation = var1_1;
    }

    public abstract NSObject clone();

    public abstract Object toJavaObject();

    /*
     * WARNING - void declaration
     */
    public final <T> T toJavaObject(Class<T> clazz) {
        void var1_1;
        NSObject nSObject = this;
        return (T)nSObject.toJavaObject(nSObject, (Class<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static NSObject fromJavaObject(Object object) {
        void var1_1;
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof NSObject) {
            return (NSObject)object;
        }
        Object objClass2 = object.getClass();
        if (objClass2.isArray()) {
            Class<?> clazz = objClass2.getComponentType();
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                int objClass2 = Array.getLength(object);
                clazz = (Class<?>)new byte[objClass2];
                for (int i = 0; i < objClass2; ++i) {
                    clazz[i] = (Byte)Array.get(object, i);
                }
                return new NSData((byte[])clazz);
            }
            int n = Array.getLength(object);
            objClass2 = new NSObject[n];
            for (int i = 0; i < n; ++i) {
                objClass2[i] = NSObject.fromJavaObject(Array.get(object, i));
            }
            return new NSArray((NSObject)objClass2);
        }
        if (NSObject.isSimple(objClass2)) {
            if (object instanceof Long || objClass2 == Long.TYPE) {
                return new NSNumber((Long)object);
            }
            if (object instanceof Integer || objClass2 == Integer.TYPE) {
                return new NSNumber((Integer)object);
            }
            if (object instanceof Short || objClass2 == Short.TYPE) {
                return new NSNumber(((Short)object).shortValue());
            }
            if (object instanceof Byte || objClass2 == Byte.TYPE) {
                return new NSNumber(((Byte)object).byteValue());
            }
            if (object instanceof Double || objClass2 == Double.TYPE) {
                return new NSNumber((Double)object);
            }
            if (object instanceof Float || objClass2 == Float.TYPE) {
                return new NSNumber(((Float)object).floatValue());
            }
            if (object instanceof Boolean || objClass2 == Boolean.TYPE) {
                return new NSNumber((Boolean)object);
            }
            if (object instanceof Date) {
                return new NSDate((Date)object);
            }
            if (objClass2 == String.class) {
                return new NSString((String)object);
            }
            throw new IllegalArgumentException("Cannot map " + objClass2.getSimpleName() + " as a simple type.");
        }
        if (Set.class.isAssignableFrom((Class<?>)objClass2)) {
            object = (Set)object;
            objClass2 = new NSSet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                objClass2.addObject(NSObject.fromJavaObject(e));
            }
            return objClass2;
        }
        if (Map.class.isAssignableFrom((Class<?>)objClass2)) {
            object = (Map)object;
            objClass2 = new NSDictionary();
            for (Map.Entry entry : object.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Maps need a String key for mapping to NSDictionary.");
                }
                objClass2.put((String)entry.getKey(), NSObject.fromJavaObject(entry.getValue()));
            }
            return objClass2;
        }
        if (Collection.class.isAssignableFrom((Class<?>)objClass2)) {
            object = (Collection)object;
            objClass2 = new ArrayList(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                objClass2.add(NSObject.fromJavaObject(e));
            }
            return new NSArray(objClass2.toArray(new NSObject[0]));
        }
        return NSObject.fromPojo(object2, var1_1);
    }

    private static boolean isSimple(Class<?> clazz) {
        Class<?> clazz2;
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || clazz == String.class || Date.class.isAssignableFrom(clazz2);
    }

    private static Object getInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Class<?> clazz2;
            throw new IllegalArgumentException("Could not instantiate class " + clazz2.getSimpleName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> getClassForName(String className) {
        int spaceIndex = className.indexOf(32);
        if (spaceIndex != -1) {
            className = className.substring(spaceIndex + 1);
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            void var1_2;
            String string;
            throw new IllegalArgumentException("Could not load class " + string, (Throwable)var1_2);
        }
    }

    private static String makeFirstCharLowercase(String input) {
        Object object;
        char[] cArray = input.toCharArray();
        Object chars = cArray;
        cArray[0] = Character.toLowerCase((char)chars[0]);
        return new String((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    private Object toJavaObject(NSObject payload, Class<?> clazz, Type[] types) {
        void var2_2;
        if (payload == null || payload instanceof NSNull) {
            return null;
        }
        if (clazz.isArray()) {
            return this.deserializeArray(payload, clazz);
        }
        if (NSObject.isSimple(clazz)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (clazz == Object.class && !(payload instanceof NSSet) && !(payload instanceof NSArray)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (payload instanceof NSSet && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSArray && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSDictionary) {
            return this.deserializeObject((NSDictionary)payload, clazz, types);
        }
        if (payload instanceof NSData && Collection.class.isAssignableFrom(clazz)) {
            void var3_3;
            void var1_1;
            return this.deserializeCollection((NSObject)var1_1, clazz, (Type[])var3_3);
        }
        throw new IllegalArgumentException("Cannot process " + var2_2.getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    private Object deserializeObject(NSDictionary payload, Class<?> clazz, Type[] types) {
        void var3_3;
        Object object;
        Cloneable map = payload.getHashMap();
        if (Map.class.isAssignableFrom((Class<?>)((Object)clazz))) {
            Class<?> clazz2;
            HashMap<String, NSObject> object22 = map;
            map = this;
            if (((Class)((Object)clazz)).isInterface() || Modifier.isAbstract(((Class)((Object)clazz)).getModifiers())) {
                clazz = new HashMap();
            } else {
                clazz2 = (Map)NSObject.getInstance(clazz);
                clazz = clazz2;
            }
            clazz2 = Object.class;
            Object var6_10 = null;
            if (types != null && ((Object)types).length > 1) {
                if ((types = types[1]) instanceof ParameterizedType) {
                    clazz2 = NSObject.getClassForName(((ParameterizedType)types).getRawType().toString());
                    Type[] typeArray = ((ParameterizedType)types).getActualTypeArguments();
                } else {
                    clazz2 = NSObject.getClassForName(types.toString());
                }
            }
            for (Map.Entry entry : object22.entrySet()) {
                void var6_12;
                clazz.put(entry.getKey(), super.toJavaObject((NSObject)entry.getValue(), clazz2, (Type[])var6_12));
            }
            return clazz;
        }
        Object result = NSObject.getInstance(clazz);
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : ((Class)object).getMethods()) {
            String name = method.getName();
            if (name.startsWith("get")) {
                hashMap.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (name.startsWith("set")) {
                setters.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (!name.startsWith("is")) continue;
            hashMap.put(NSObject.makeFirstCharLowercase(name.substring(2)), method);
        }
        for (Map.Entry entry : map.entrySet()) {
            Method setter = (Method)setters.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            Method getter = (Method)hashMap.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            if (setter == null || getter == null) continue;
            Class<?> elemClass = getter.getReturnType();
            Type[] elemTypes = null;
            Type type = getter.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                elemTypes = ((ParameterizedType)type).getActualTypeArguments();
            }
            try {
                void var1_1;
                setter.invoke(result, this.toJavaObject((NSObject)entry.getValue(), elemClass, (Type[])var1_1));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access setter " + setter);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not invoke setter " + setter);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserializeCollection(NSObject payload22, Class<?> clazz5, Type[] types) {
        Object[] payload22;
        void var5_18;
        Collection<Byte> result;
        if (clazz5.isInterface() || Modifier.isAbstract(clazz5.getModifiers())) {
            if (List.class.isAssignableFrom((Class<?>)clazz5)) {
                result = new ArrayList();
            } else {
                if (!Set.class.isAssignableFrom((Class<?>)clazz5)) throw new IllegalArgumentException("Could not find a proper implementation for " + clazz5.getSimpleName());
                result = new HashSet();
            }
        } else {
            Collection collection = (Collection)NSObject.getInstance(clazz5);
            result = collection;
        }
        Class<Object> clazz2 = Object.class;
        Type[] elemTypes = null;
        if (types != null && ((void)types).length > 0) {
            if (types[0] instanceof ParameterizedType) {
                Class<?> clazz3 = NSObject.getClassForName(((ParameterizedType)types[0]).getRawType().toString());
                elemTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
            } else {
                void var3_9;
                Class<?> clazz4 = NSObject.getClassForName(var3_9[0].toString());
            }
        }
        if (payload22 instanceof NSArray) {
            for (NSObject nsObject : ((NSArray)payload22).getArray()) {
                result.add((Byte)this.toJavaObject(nsObject, (Class<?>)var5_18, elemTypes));
            }
            return result;
        }
        if (payload22 instanceof NSData) {
            if (var5_18 == null || !var5_18.isAssignableFrom(Byte.class)) void var2_5;
            throw new IllegalArgumentException("NSData cannot be converted to " + var2_5.getName());
            byte[] payload22 = ((NSData)payload22).bytes();
            int clazz5 = payload22.length;
            for (int i = 0; i < clazz5; ++i) {
                Byte b = payload22[i];
                result.add(b);
            }
            return result;
        }
        if (!(payload22 instanceof NSSet)) void var1_1;
        throw new IllegalArgumentException("Unknown NS* type " + var1_1.getClass().getSimpleName());
        for (NSObject nsObject : ((NSSet)payload22).allObjects()) {
            result.add((Byte)this.toJavaObject(nsObject, (Class<?>)var5_18, elemTypes));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Object deserializeArray(NSObject payload, Class<?> clazz) {
        void var2_2;
        NSObject[] nSObjectArray;
        Object result;
        NSObject[] array;
        Class<?> elementClass = NSObject.getClassForName(clazz.getComponentType().getName());
        if (payload instanceof NSArray) {
            array = ((NSArray)payload).getArray();
            result = Array.newInstance(elementClass, array.length);
            for (int i = 0; i < array.length; ++i) {
                Array.set(result, i, this.toJavaObject(array[i], elementClass, null));
            }
            return result;
        }
        if (array instanceof NSSet) {
            NSSet set = (NSSet)array;
            result = Array.newInstance(elementClass, set.count());
            int i = 0;
            for (NSObject entry : nSObjectArray.allObjects()) {
                Array.set(result, i, this.toJavaObject(entry, elementClass, null));
                ++i;
            }
            return var2_2;
        }
        if (nSObjectArray instanceof NSData) {
            void var3_3;
            return NSObject.deserializeData((NSData)nSObjectArray, var3_3);
        }
        throw new IllegalArgumentException("Unable to map " + nSObjectArray.getClass().getSimpleName() + " to " + var2_2.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static Object deserializeData(NSData payload, Class<?> elementClass) {
        if (elementClass == Byte.TYPE) {
            return payload.bytes();
        }
        if (elementClass == Byte.class) {
            void var1_1;
            Object bytes = payload.bytes();
            Object result = Array.newInstance(elementClass, ((Object)bytes).length);
            for (int i = 0; i < ((Object)bytes).length; ++i) {
                Array.set(result, i, (byte)bytes[i]);
            }
            return var1_1;
        }
        throw new IllegalArgumentException("NSData can only be mapped to byte[] or Byte[].");
    }

    /*
     * WARNING - void declaration
     */
    private static Object deserializeSimple(NSObject payload, Class<?> clazz) {
        void var1_1;
        NSObject nSObject;
        if (payload instanceof NSNumber) {
            return NSObject.deserializeNumber((NSNumber)payload, clazz);
        }
        if (payload instanceof NSDate) {
            return NSObject.deserializeDate((NSDate)payload, clazz);
        }
        if (payload instanceof NSString) {
            return ((NSString)payload).getContent();
        }
        throw new IllegalArgumentException("Cannot map " + nSObject.getClass().getSimpleName() + " to " + var1_1.getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    private static Date deserializeDate(NSDate date, Class<?> clazz) {
        void var1_1;
        NSDate nSDate;
        if (clazz == Date.class) {
            return date.getDate();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return date.getDate();
        }
        Date result = (Date)NSObject.getInstance(clazz);
        result.setTime(nSDate.getDate().getTime());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Object deserializeNumber(NSNumber number, Class<?> clazz) {
        void var1_1;
        if (number.isInteger()) {
            if (clazz == Long.TYPE || clazz == Long.class) {
                return number.longValue();
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return number.intValue();
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)number.intValue();
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)number.intValue();
            }
        }
        if (number.isInteger() || number.isReal()) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                return number.doubleValue();
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(number.floatValue());
            }
        }
        if (number.isBoolean() && (clazz == Boolean.TYPE || clazz == Boolean.class)) {
            NSNumber nSNumber;
            return nSNumber.boolValue();
        }
        throw new IllegalArgumentException("Cannot map NSNumber to " + var1_1.getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    private static NSDictionary fromPojo(Object object, Class<?> objClass) {
        void var2_2;
        void var1_1;
        NSDictionary result = new NSDictionary();
        for (Method method : objClass.getMethods()) {
            if (Modifier.isNative(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                name = NSObject.makeFirstCharLowercase(name.substring(3));
            } else {
                if (!name.startsWith("is")) continue;
                name = NSObject.makeFirstCharLowercase(name.substring(2));
            }
            try {
                result.put(name, NSObject.fromJavaObject(method.invoke(object, new Object[0])));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access getter " + method.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not invoke getter " + method.getName());
            }
        }
        for (AccessibleObject accessibleObject : var1_1.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                result.put(((Field)accessibleObject).getName(), NSObject.fromJavaObject(((Field)accessibleObject).get(object)));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access field " + ((Field)accessibleObject).getName());
            }
        }
        return var2_2;
    }
}

