/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=1)
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;

    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        this.lengthBeforeCursor = 1;
        this.lengthAfterCursor = 0;
        if (!(this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = this.lengthBeforeCursor;
        for (int i = 0; i < n; ++i) {
            if (buffer.getSelectionStart$ui_text() > ++beforeLenInChars) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionStart$ui_text() - beforeLenInChars - 1);
                EditingBuffer editingBuffer2 = buffer;
                char trail = editingBuffer2.get$ui_text(editingBuffer2.getSelectionStart$ui_text() - beforeLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = buffer.getSelectionStart$ui_text();
            break;
        }
        int afterLenInChars = 0;
        int n2 = this.lengthAfterCursor;
        for (int i = 0; i < n2; ++i) {
            if (buffer.getSelectionEnd$ui_text() + ++afterLenInChars < buffer.getLength$ui_text()) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionEnd$ui_text() + afterLenInChars - 1);
                EditingBuffer editingBuffer3 = buffer;
                char trail = editingBuffer3.get$ui_text(editingBuffer3.getSelectionEnd$ui_text() + afterLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = buffer.getLength$ui_text() - buffer.getSelectionEnd$ui_text();
            break;
        }
        EditingBuffer editingBuffer = buffer;
        editingBuffer.delete$ui_text(editingBuffer.getSelectionEnd$ui_text(), buffer.getSelectionEnd$ui_text() + var3_3);
        EditingBuffer editingBuffer4 = buffer;
        editingBuffer4.delete$ui_text(editingBuffer4.getSelectionStart$ui_text() - var2_2, var1_1.getSelectionStart$ui_text());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)var1_1).lengthAfterCursor;
    }

    public final int hashCode() {
        int n;
        int result2 = this.lengthBeforeCursor;
        n = 31 * n + this.lengthAfterCursor;
        return n;
    }

    public final String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ')';
    }
}

