/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@StabilityInferred(parameters=1)
public final class CommitTextCommand
implements EditCommand {
    private final AnnotatedString annotatedString;
    private final int newCursorPosition;

    /*
     * WARNING - void declaration
     */
    public CommitTextCommand(AnnotatedString annotatedString, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        this.annotatedString = var1_1;
        this.newCursorPosition = var2_2;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    /*
     * WARNING - void declaration
     */
    public CommitTextCommand(String text, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new AnnotatedString((String)var1_1, null, null, 6, null), (int)var2_2);
    }

    public final String getText() {
        return this.annotatedString.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_3;
        int n;
        CommitTextCommand commitTextCommand;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text()) {
            EditingBuffer editingBuffer = buffer;
            commitTextCommand = this;
            editingBuffer.replace$ui_text(editingBuffer.getCompositionStart$ui_text(), buffer.getCompositionEnd$ui_text(), commitTextCommand.annotatedString.getText());
        } else {
            EditingBuffer editingBuffer = buffer;
            commitTextCommand = this;
            editingBuffer.replace$ui_text(editingBuffer.getSelectionStart$ui_text(), buffer.getSelectionEnd$ui_text(), commitTextCommand.annotatedString.getText());
        }
        int newCursor2 = buffer.getCursor$ui_text();
        if (this.newCursorPosition > 0) {
            n = newCursor2 + this.newCursorPosition - 1;
        } else {
            CommitTextCommand newCursor2 = this;
            n = newCursor2 + this.newCursorPosition - newCursor2.annotatedString.getText().length();
        }
        int newCursorInBuffer = n;
        buffer.setCursor$ui_text(RangesKt.coerceIn((int)var2_3, (int)0, (int)var1_1.getLength$ui_text()));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommitTextCommand)) {
            return false;
        }
        CommitTextCommand commitTextCommand = this;
        CommitTextCommand commitTextCommand2 = commitTextCommand;
        commitTextCommand2 = (CommitTextCommand)other;
        if (!Intrinsics.areEqual((Object)commitTextCommand.annotatedString.getText(), (Object)commitTextCommand2.annotatedString.getText())) {
            return false;
        }
        return this.newCursorPosition == ((CommitTextCommand)var1_1).newCursorPosition;
    }

    public final int hashCode() {
        int n;
        CommitTextCommand commitTextCommand = this;
        int result2 = commitTextCommand.annotatedString.getText().hashCode();
        n = 31 * n + this.newCursorPosition;
        return n;
    }

    public final String toString() {
        CommitTextCommand commitTextCommand = this;
        return "CommitTextCommand(text='" + commitTextCommand.annotatedString.getText() + "', newCursorPosition=" + this.newCursorPosition + ')';
    }
}

