/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.SynchronizedObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n+ 2 Synchronization.kt\nandroidx/compose/ui/text/SynchronizationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n350#1:354\n350#1:363\n350#1:365\n350#1:367\n350#1:369\n350#1:371\n350#1:373\n33#2:355\n33#2:357\n33#2:358\n33#2:359\n33#2:360\n33#2:361\n33#2:362\n33#2:364\n33#2:366\n33#2:368\n33#2:370\n33#2:372\n33#2:374\n33#2:375\n33#2:376\n33#2:377\n1#3:356\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/compose/ui/text/caches/LruCache\n*L\n40#1:354\n297#1:363\n303#1:365\n309#1:367\n314#1:369\n319#1:371\n324#1:373\n40#1:355\n71#1:357\n86#1:358\n104#1:359\n142#1:360\n176#1:361\n218#1:362\n297#1:364\n303#1:366\n309#1:368\n314#1:370\n319#1:372\n324#1:374\n331#1:375\n341#1:376\n350#1:377\n*E\n"})
public final class LruCache<K, V> {
    private final SynchronizedObject monitor = new SynchronizedObject();
    private final HashMap<K, V> map = new HashMap(0, 0.75f);
    private final LinkedHashSet<K> keySet = new LinkedHashSet();
    private int size;
    private int maxSize = 16;
    private int putCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;
    public static final int $stable = 8;

    @JvmName(name="size")
    private int size() {
        LruCache lruCache = this;
        Object object = lruCache;
        object = lruCache;
        SynchronizedObject synchronizedObject = lruCache.monitor;
        object = synchronizedObject;
        object = synchronizedObject;
        synchronized (synchronizedObject) {
            int n = this.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public LruCache(int maxSize) {
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        SynchronizedObject synchronizedObject;
        SynchronizedObject synchronizedObject2 = synchronizedObject = this.monitor;
        synchronized (synchronizedObject) {
            block4: {
                void var1_1;
                V mapValue = this.map.get(key);
                if (mapValue == null) break block4;
                this.keySet.remove(key);
                this.keySet.add(var1_1);
                int n = this.hitCount;
                this.hitCount = n + 1;
                SynchronizedObject synchronizedObject3 = synchronizedObject;
                // ** MonitorExit[var3_7] (shouldn't be in output)
                return (V)synchronizedObject3;
            }
            int n = this.missCount;
            this.missCount = n + 1;
            // ** MonitorExit[var3_7] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final V put(K key, V value) {
        LruCache lruCache;
        if (key == null) throw new NullPointerException();
        if (value == null) {
            throw new NullPointerException();
        }
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        // MONITORENTER : synchronizedObject
        int n = this.putCount;
        this.putCount = n + 1;
        Object object = value;
        object = key;
        object = this;
        this.size = this.size() + 1;
        void previous = this.map.put(key, value);
        if (previous != null) {
            object = previous;
            object = key;
            object = this;
            this.size = this.size() - 1;
        }
        if (this.keySet.contains(key)) {
            this.keySet.remove(key);
        }
        this.keySet.add(lruCache);
        // MONITOREXIT : synchronizedObject2
        LruCache lruCache2 = this;
        int n2 = lruCache2.maxSize;
        lruCache = lruCache2;
        while (true) {
            Object object2 = null;
            Object var5_9 = null;
            SynchronizedObject synchronizedObject3 = lruCache.monitor;
            SynchronizedObject synchronizedObject4 = synchronizedObject3;
            synchronizedObject4 = synchronizedObject3;
            // MONITORENTER : synchronizedObject3
            if (lruCache.size() < 0) throw new IllegalStateException("map/keySet size inconsistency");
            if (lruCache.map.isEmpty()) {
                if (lruCache.size() != 0) throw new IllegalStateException("map/keySet size inconsistency");
            }
            if (lruCache.map.isEmpty() != lruCache.keySet.isEmpty()) {
                throw new IllegalStateException("map/keySet size inconsistency");
            }
            if (lruCache.size() > n2 && !lruCache.map.isEmpty()) {
                object2 = CollectionsKt.first((Iterable)lruCache.keySet);
                Object v = ((Map)lruCache.map).get(object2);
                if (v == null) {
                    throw new IllegalStateException("inconsistent state");
                }
                var5_9 = v;
                object = lruCache.map;
                Object object3 = object2;
                TypeIntrinsics.asMutableMap(object).remove(object3);
                object = lruCache.keySet;
                object3 = object2;
                TypeIntrinsics.asMutableCollection(object).remove(object3);
                int n3 = lruCache.size();
                Object object4 = object2;
                Intrinsics.checkNotNull((Object)object4);
                Object v6 = var5_9;
                Intrinsics.checkNotNull(v6);
                object = v6;
                object = object4;
                object = lruCache;
                lruCache.size = n3 - 1;
                int n4 = lruCache.evictionCount;
                lruCache.evictionCount = n4 + 1;
            }
            // MONITOREXIT : synchronizedObject4
            if (object2 == null) {
                if (var5_9 == null) void var2_2;
                return var2_2;
            }
            Intrinsics.checkNotNull((Object)object2);
            Intrinsics.checkNotNull(var5_9);
        }
    }

    public final V remove$7713a341(K key) {
        SynchronizedObject synchronizedObject;
        if (key == null) {
            throw new NullPointerException();
        }
        SynchronizedObject synchronizedObject2 = synchronizedObject = this.monitor;
        synchronized (synchronizedObject) {
            V previous = this.map.remove(key);
            this.keySet.remove(key);
            if (previous != null) {
                Object object;
                void v0 = object;
                object = previous;
                object = v0;
                object = this;
                this.size = this.size() - 1;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return (V)synchronizedObject;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        SynchronizedObject synchronizedObject = this.monitor;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            void var2_2;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + (int)var2_2 + "%]";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }
}

