/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.MultiParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMultiParagraphIntrinsics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,154:1\n916#2:155\n917#2,5:164\n151#3,3:156\n33#3,4:159\n154#3:163\n155#3:169\n38#3:170\n156#3:171\n101#3,2:172\n33#3,6:174\n103#3:180\n*S KotlinDebug\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n*L\n96#1:155\n96#1:164,5\n96#1:156,3\n96#1:159,4\n96#1:163\n96#1:169\n96#1:170\n96#1:171\n121#1:172,2\n121#1:174,6\n121#1:180\n*E\n"})
public final class MultiParagraphIntrinsics
implements ParagraphIntrinsics {
    private final AnnotatedString annotatedString;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Lazy minIntrinsicWidth$delegate;
    private final Lazy maxIntrinsicWidth$delegate;
    private final List<ParagraphIntrinsicInfo> infoList;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiParagraphIntrinsics(AnnotatedString annotatedString, TextStyle style, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void $this$mapEachParagraphStyle$iv;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.annotatedString = annotatedString;
        this.placeholders = placeholders;
        this.minIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ MultiParagraphIntrinsics this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Float invoke() {
                Object v0;
                List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this.this$0.getInfoList$ui_text();
                if ($this$fastMaxBy$iv.isEmpty()) {
                    v0 = null;
                } else {
                    void var2_2;
                    ParagraphIntrinsicInfo maxElem$iv;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo = maxElem$iv = $this$fastMaxBy$iv.get(0);
                    float maxValue$iv = maxElem$iv.getIntrinsics().getMinIntrinsicWidth();
                    int i$iv = 1;
                    int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
                    if (n > 0) {
                        while (true) {
                            ParagraphIntrinsicInfo e$iv;
                            ParagraphIntrinsicInfo paragraphIntrinsicInfo2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                            float v$iv = e$iv.getIntrinsics().getMinIntrinsicWidth();
                            if (Float.compare(maxValue$iv, v$iv) < 0) {
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            }
                            if (i$iv == n) break;
                            ++i$iv;
                        }
                    }
                    v0 = var2_2;
                }
                Object object = v0;
                return Float.valueOf(object != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMinIntrinsicWidth() : 0.0f);
            }
        }));
        this.maxIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ MultiParagraphIntrinsics this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Float invoke() {
                Object v0;
                List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this.this$0.getInfoList$ui_text();
                if ($this$fastMaxBy$iv.isEmpty()) {
                    v0 = null;
                } else {
                    void var2_2;
                    ParagraphIntrinsicInfo maxElem$iv;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo = maxElem$iv = $this$fastMaxBy$iv.get(0);
                    float maxValue$iv = maxElem$iv.getIntrinsics().getMaxIntrinsicWidth();
                    int i$iv = 1;
                    int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
                    if (n > 0) {
                        while (true) {
                            ParagraphIntrinsicInfo e$iv;
                            ParagraphIntrinsicInfo paragraphIntrinsicInfo2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                            float v$iv = e$iv.getIntrinsics().getMaxIntrinsicWidth();
                            if (Float.compare(maxValue$iv, v$iv) < 0) {
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            }
                            if (i$iv == n) break;
                            ++i$iv;
                        }
                    }
                    v0 = var2_2;
                }
                Object object = v0;
                return Float.valueOf(object != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMaxIntrinsicWidth() : 0.0f);
            }
        }));
        ParagraphStyle paragraphStyle = style.toParagraphStyle();
        MultiParagraphIntrinsics multiParagraphIntrinsics = this;
        placeholders = multiParagraphIntrinsics.annotatedString;
        MultiParagraphIntrinsics multiParagraphIntrinsics2 = multiParagraphIntrinsics;
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastMap$iv$iv = AnnotatedStringKt.normalizedParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyle);
        ArrayList target$iv$iv = new ArrayList($this$fastMap$iv$iv.size());
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastForEach$iv$iv$iv = $this$fastMap$iv$iv;
        int n = $this$fastForEach$iv$iv$iv.size();
        for (int index$iv$iv$iv = 0; index$iv$iv$iv < n; ++index$iv$iv$iv) {
            void paragraphStyleItem;
            void paragraphStyleRange$iv;
            AnnotatedString.Range<ParagraphStyle> range;
            AnnotatedString.Range<ParagraphStyle> it$iv$iv = range = $this$fastForEach$iv$iv$iv.get(index$iv$iv$iv);
            Collection collection = target$iv$iv;
            Object object = AnnotatedStringKt.access$substringWithoutParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyleRange$iv.getStart(), paragraphStyleRange$iv.getEnd());
            AnnotatedString annotatedString2 = object;
            ParagraphStyle paragraphStyle2 = paragraphStyle;
            Object object2 = (ParagraphStyle)paragraphStyleItem.getItem();
            Object object3 = this;
            ParagraphStyle paragraphStyle3 = object2;
            object2 = paragraphStyle2;
            object3 = paragraphStyle3;
            Object currentParagraphStyle = !TextDirection.equals-impl0(paragraphStyle3.getTextDirection-s_7X-co(), TextDirection.Companion.getUnspecified-s_7X-co()) ? object3 : ParagraphStyle.copy-ykzQM6k$default$5281f80c((ParagraphStyle)object3, 0, ((ParagraphStyle)object2).getTextDirection-s_7X-co(), 0L, null, null, null, 0, 0, null, 509);
            String string = annotatedString2.getText();
            object2 = currentParagraphStyle;
            object3 = style;
            Intrinsics.checkNotNullParameter((Object)object2, (String)"other");
            object = this;
            collection.add(new ParagraphIntrinsicInfo(ParagraphIntrinsicsKt.ParagraphIntrinsics(string, new TextStyle(((TextStyle)object3).toSpanStyle(), ((TextStyle)object3).toParagraphStyle().merge((ParagraphStyle)object2)), annotatedString2.getSpanStyles(), MultiParagraphIntrinsicsKt.access$getLocalPlaceholders(((MultiParagraphIntrinsics)object).placeholders, paragraphStyleItem.getStart(), paragraphStyleItem.getEnd()), density, fontFamilyResolver), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd()));
        }
        multiParagraphIntrinsics2.infoList = target$iv$iv;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public final float getMinIntrinsicWidth() {
        Lazy lazy = this.minIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        Lazy lazy = this.maxIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final List<ParagraphIntrinsicInfo> getInfoList$ui_text() {
        return this.infoList;
    }

    @Override
    public final boolean getHasStaleResolvedFonts() {
        List<ParagraphIntrinsicInfo> $this$fastForEach$iv$iv = this.infoList;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = $this$fastForEach$iv$iv.get(index$iv$iv);
            ParagraphIntrinsicInfo paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            if (!paragraphIntrinsicInfo.getIntrinsics().getHasStaleResolvedFonts()) continue;
            return true;
        }
        return false;
    }
}

