/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import java.security.SecureRandom;
import java.util.Arrays;

public interface Guid {
    public static final IID IID_NULL = new IID();

    public static class IID
    extends GUID {
        public IID() {
        }

        /*
         * WARNING - void declaration
         */
        public IID(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public IID(String iid) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public IID(byte[] data) {
            super((byte[])var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public IID(GUID guid) {
            this(var1_1.toGuidString());
            void var1_1;
        }
    }

    public static class REFIID
    extends PointerType {
        public REFIID() {
        }

        /*
         * WARNING - void declaration
         */
        public REFIID(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public REFIID(IID guid) {
            super(var1_1.getPointer());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(IID value) {
            void var1_1;
            this.setPointer(var1_1.getPointer());
        }

        public IID getValue() {
            return new IID(this.getPointer());
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            REFIID other = (REFIID)((Object)o);
            return this.getValue().equals((Object)var1_1.getValue());
        }

        public int hashCode() {
            return this.getValue().hashCode();
        }
    }

    public static class CLSID
    extends GUID {
        public CLSID() {
        }

        /*
         * WARNING - void declaration
         */
        public CLSID(String guid) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public CLSID(GUID guid) {
            super((GUID)var1_1);
            void var1_1;
        }

        public static class ByReference
        extends GUID {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(GUID guid) {
                super((GUID)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }

    @Structure.FieldOrder(value={"Data1", "Data2", "Data3", "Data4"})
    public static class GUID
    extends Structure {
        public int Data1;
        public short Data2;
        public short Data3;
        public byte[] Data4 = new byte[8];

        public GUID() {
        }

        /*
         * WARNING - void declaration
         */
        public GUID(GUID guid) {
            void var1_1;
            this.Data1 = guid.Data1;
            this.Data2 = guid.Data2;
            this.Data3 = guid.Data3;
            this.Data4 = var1_1.Data4;
            this.writeFieldsToMemory();
        }

        /*
         * WARNING - void declaration
         */
        public GUID(String guid) {
            this(GUID.fromString((String)var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public GUID(byte[] data) {
            this(GUID.fromBinary((byte[])var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public GUID(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            GUID other = (GUID)((Object)o);
            return this.Data1 == other.Data1 && this.Data2 == other.Data2 && this.Data3 == other.Data3 && Arrays.equals(this.Data4, var1_1.Data4);
        }

        public int hashCode() {
            return this.Data1 + this.Data2 & 65535 + this.Data3 & 65535 + Arrays.hashCode(this.Data4);
        }

        /*
         * WARNING - void declaration
         */
        public static GUID fromBinary(byte[] data) {
            void var1_1;
            byte[] byArray;
            void var2_3;
            if (data.length != 16) {
                throw new IllegalArgumentException("Invalid data length: " + data.length);
            }
            GUID newGuid = new GUID();
            long l = data[0] & 0xFF;
            l <<= 8;
            l |= (long)(data[1] & 0xFF);
            l <<= 8;
            l |= (long)(data[2] & 0xFF);
            long data1Temp22 = (l <<= 8) | (long)(data[3] & 0xFF);
            newGuid.Data1 = (int)data1Temp22;
            int data1Temp22 = data[4] & 0xFF;
            int data2Temp = (data1Temp22 <<= 8) | data[5] & 0xFF;
            newGuid.Data2 = (short)data2Temp;
            data2Temp = data[6] & 0xFF;
            int data3Temp = (data2Temp <<= 8) | data[7] & 0xFF;
            newGuid.Data3 = (short)var2_3;
            newGuid.Data4[0] = data[8];
            newGuid.Data4[1] = data[9];
            newGuid.Data4[2] = data[10];
            newGuid.Data4[3] = data[11];
            newGuid.Data4[4] = data[12];
            newGuid.Data4[5] = data[13];
            newGuid.Data4[6] = data[14];
            newGuid.Data4[7] = byArray[15];
            newGuid.writeFieldsToMemory();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static GUID fromString(String guid2) {
            void var0_1;
            int i;
            int y = 0;
            char[] _cnewguid = new char[32];
            char[] _cguid = guid2.toCharArray();
            byte[] bdata = new byte[16];
            GUID newGuid = new GUID();
            if (guid2.length() > 38) {
                throw new IllegalArgumentException("Invalid guid length: " + guid2.length());
            }
            for (i = 0; i < _cguid.length; ++i) {
                if (_cguid[i] == '{' || _cguid[i] == '-' || _cguid[i] == '}') continue;
                _cnewguid[y++] = _cguid[i];
            }
            for (i = 0; i < 32; i += 2) {
                bdata[i / 2] = (byte)((Character.digit(_cnewguid[i], 16) << 4) + Character.digit(_cnewguid[i + 1], 16) & 0xFF);
            }
            int cfr_ignored_0 = bdata.length;
            long i2 = bdata[0] & 0xFF;
            i2 <<= 8;
            i2 |= (long)(bdata[1] & 0xFF);
            i2 <<= 8;
            i2 |= (long)(bdata[2] & 0xFF);
            long data1Temp = (i2 <<= 8) | (long)(bdata[3] & 0xFF);
            newGuid.Data1 = (int)data1Temp;
            int guid2 = bdata[4] & 0xFF;
            int data2Temp = (guid2 <<= 8) | bdata[5] & 0xFF;
            newGuid.Data2 = (short)data2Temp;
            data2Temp = bdata[6] & 0xFF;
            int data3Temp = (data2Temp <<= 8) | bdata[7] & 0xFF;
            newGuid.Data3 = (short)var0_1;
            newGuid.Data4[0] = bdata[8];
            newGuid.Data4[1] = bdata[9];
            newGuid.Data4[2] = bdata[10];
            newGuid.Data4[3] = bdata[11];
            newGuid.Data4[4] = bdata[12];
            newGuid.Data4[5] = bdata[13];
            newGuid.Data4[6] = bdata[14];
            newGuid.Data4[7] = bdata[15];
            newGuid.writeFieldsToMemory();
            return newGuid;
        }

        /*
         * WARNING - void declaration
         */
        public static GUID newGuid() {
            void var1_1;
            void var0;
            SecureRandom ng = new SecureRandom();
            byte[] randomBytes = new byte[16];
            var0.nextBytes(randomBytes);
            randomBytes[6] = (byte)(randomBytes[6] & 0xF);
            randomBytes[6] = (byte)(randomBytes[6] | 0x40);
            randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
            randomBytes[8] = (byte)(randomBytes[8] | 0x80);
            return new GUID((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public byte[] toByteArray() {
            void var1_1;
            void var3_3;
            void var2_2;
            byte[] guid = new byte[16];
            byte[] byArray = new byte[4];
            byte[] bytes1 = byArray;
            byArray[0] = (byte)(this.Data1 >> 24);
            bytes1[1] = (byte)(this.Data1 >> 16);
            bytes1[2] = (byte)(this.Data1 >> 8);
            bytes1[3] = (byte)(this.Data1 >> 0);
            byte[] byArray2 = new byte[4];
            byte[] bytes2 = byArray2;
            byArray2[0] = (byte)(this.Data2 >> 24);
            bytes2[1] = (byte)(this.Data2 >> 16);
            bytes2[2] = (byte)(this.Data2 >> 8);
            bytes2[3] = (byte)(this.Data2 >> 0);
            byte[] byArray3 = new byte[4];
            byte[] bytes3 = byArray3;
            byArray3[0] = (byte)(this.Data3 >> 24);
            bytes3[1] = (byte)(this.Data3 >> 16);
            bytes3[2] = (byte)(this.Data3 >> 8);
            bytes3[3] = (byte)(this.Data3 >> 0);
            System.arraycopy(var2_2, 0, guid, 0, 4);
            System.arraycopy(var3_3, 2, guid, 4, 2);
            System.arraycopy(bytes3, 2, guid, 6, 2);
            System.arraycopy(this.Data4, 0, guid, 8, 8);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String toGuidString() {
            void var2_2;
            byte[] bGuid = this.toByteArray();
            StringBuilder hexStr = new StringBuilder(2 * bGuid.length);
            hexStr.append("{");
            for (int i = 0; i < bGuid.length; ++i) {
                char ch1 = "0123456789ABCDEF".charAt((bGuid[i] & 0xF0) >> 4);
                char ch2 = "0123456789ABCDEF".charAt(bGuid[i] & 0xF);
                hexStr.append(ch1).append(ch2);
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                hexStr.append("-");
            }
            hexStr.append("}");
            return var2_2.toString();
        }

        /*
         * WARNING - void declaration
         */
        protected void writeFieldsToMemory() {
            for (String name : this.getFieldOrder()) {
                void var2_2;
                this.writeField((String)var2_2);
            }
        }

        public static class ByReference
        extends GUID
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(GUID guid) {
                super(guid.getPointer());
                void var1_1;
                this.Data1 = guid.Data1;
                this.Data2 = guid.Data2;
                this.Data3 = guid.Data3;
                this.Data4 = var1_1.Data4;
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }

        public static class ByValue
        extends GUID
        implements Structure.ByValue {
            public ByValue() {
            }

            /*
             * WARNING - void declaration
             */
            public ByValue(GUID guid) {
                super(guid.getPointer());
                void var1_1;
                this.Data1 = guid.Data1;
                this.Data2 = guid.Data2;
                this.Data3 = guid.Data3;
                this.Data4 = var1_1.Data4;
            }

            /*
             * WARNING - void declaration
             */
            public ByValue(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }
}

