/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.dnd;

import com.sun.jna.platform.dnd.DragHandler;
import com.sun.jna.platform.dnd.DropTargetPainter;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DropHandler
implements DropTargetListener {
    private static final Logger LOG = Logger.getLogger(DropHandler.class.getName());
    private int acceptedActions;
    private List<DataFlavor> acceptedFlavors;
    private DropTarget dropTarget;
    private boolean active = true;
    private DropTargetPainter painter;
    private String lastAction;

    /*
     * WARNING - void declaration
     */
    public DropHandler(Component c, int acceptedActions) {
        this((Component)var1_1, (int)var2_2, new DataFlavor[0]);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DropHandler(Component c, int acceptedActions, DataFlavor[] acceptedFlavors) {
        this((Component)var1_1, (int)var2_2, (DataFlavor[])var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DropHandler(Component c, int acceptedActions, DataFlavor[] acceptedFlavors, DropTargetPainter painter) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.acceptedActions = acceptedActions;
        this.acceptedFlavors = Arrays.asList(var3_3);
        this.painter = painter;
        DropHandler dropHandler = this;
        this.dropTarget = new DropTarget((Component)var1_1, (int)var2_2, dropHandler, dropHandler.active);
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - void declaration
     */
    public void setActive(boolean active) {
        this.active = active;
        if (this.dropTarget != null) {
            void var1_1;
            this.dropTarget.setActive((boolean)var1_1);
        }
    }

    protected int getDropActionsForFlavors(DataFlavor[] dataFlavors) {
        return this.acceptedActions;
    }

    /*
     * WARNING - void declaration
     */
    protected int getDropAction(DropTargetEvent e) {
        void var1_1;
        int availableActions;
        void var3_3;
        DropTargetEvent ev;
        int currentAction = 0;
        int sourceActions = 0;
        Point location = null;
        DataFlavor[] flavors = new DataFlavor[]{};
        if (e instanceof DropTargetDragEvent) {
            ev = (DropTargetDragEvent)e;
            currentAction = ((DropTargetDragEvent)ev).getDropAction();
            sourceActions = ((DropTargetDragEvent)ev).getSourceActions();
            flavors = ((DropTargetDragEvent)ev).getCurrentDataFlavors();
            location = ((DropTargetDragEvent)ev).getLocation();
        } else if (e instanceof DropTargetDropEvent) {
            ev = (DropTargetDropEvent)e;
            currentAction = ((DropTargetDropEvent)ev).getDropAction();
            sourceActions = ((DropTargetDropEvent)ev).getSourceActions();
            flavors = ((DropTargetDropEvent)ev).getCurrentDataFlavors();
            location = ((DropTargetDropEvent)ev).getLocation();
        }
        if (this.isSupported(flavors) && (currentAction = this.getDropAction(e, currentAction, (int)var3_3, availableActions = this.getDropActionsForFlavors(flavors))) != 0 && this.canDrop((DropTargetEvent)var1_1, currentAction, location)) {
            void var2_2;
            return (int)var2_2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getDropAction(DropTargetEvent e, int currentAction, int sourceActions, int acceptedActions) {
        void var2_3;
        void var3_4;
        int action;
        int modifiersActive = this.modifiersActive(currentAction);
        if ((currentAction & acceptedActions) == 0 && modifiersActive == 0) {
            currentAction = modifiersActive = acceptedActions & sourceActions;
        } else if (modifiersActive != 0 && (action = currentAction & acceptedActions & var3_4) != currentAction) {
            void var1_2;
            currentAction = var1_2;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean modifiersActive(int dropAction) {
        void var2_2;
        int mods = DragHandler.getModifiers();
        if (mods == -1) {
            void var1_1;
            return dropAction == 0x40000000 || var1_1 == true;
        }
        return var2_2 != false;
    }

    /*
     * WARNING - void declaration
     */
    private void describe(String type, DropTargetEvent e) {
        if (LOG.isLoggable(Level.FINE)) {
            void var3_3;
            DropTargetEvent ev;
            Serializable dt;
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("drop: ");
            msgBuilder.append((String)type);
            if (e instanceof DropTargetDragEvent) {
                type = e.getDropTargetContext();
                dt = ((DropTargetContext)type).getDropTarget();
                ev = (DropTargetDragEvent)e;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(((DropTargetDragEvent)ev).getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(((DropTarget)dt).getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(((DropTargetDragEvent)ev).getDropAction()));
            } else if (ev instanceof DropTargetDropEvent) {
                void var2_2;
                dt = ev.getDropTargetContext();
                dt = ((DropTargetContext)dt).getDropTarget();
                ev = (DropTargetDropEvent)ev;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(((DropTargetDropEvent)ev).getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(((DropTarget)dt).getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(var2_2.getDropAction()));
            }
            String msg = var3_3.toString();
            if (!msg.equals(this.lastAction)) {
                void var1_1;
                LOG.log(Level.FINE, msg);
                this.lastAction = var1_1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int acceptOrReject(DropTargetDragEvent e) {
        void var2_2;
        int action = this.getDropAction(e);
        if (action != 0) {
            e.acceptDrag(action);
        } else {
            void var1_1;
            var1_1.rejectDrag();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragEnter(DropTargetDragEvent e) {
        void var1_1;
        void var2_2;
        this.describe("enter(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, (int)var2_2, var1_1.getLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragOver(DropTargetDragEvent e) {
        void var1_1;
        void var2_2;
        this.describe("over(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, (int)var2_2, var1_1.getLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragExit(DropTargetEvent e) {
        void var1_1;
        this.describe("exit(tgt)", e);
        this.paintDropTarget((DropTargetEvent)var1_1, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        void var1_1;
        void var2_2;
        this.describe("change(tgt)", e);
        int action = this.acceptOrReject(e);
        this.paintDropTarget(e, (int)var2_2, var1_1.getLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drop(DropTargetDropEvent e) {
        void var1_1;
        this.describe("drop(tgt)", e);
        int action = this.getDropAction(e);
        if (action != 0) {
            e.acceptDrop(action);
            try {
                void var2_2;
                this.drop(e, (int)var2_2);
                e.dropComplete(true);
            }
            catch (Exception exception) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
        this.paintDropTarget(e, 0, var1_1.getLocation());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSupported(DataFlavor[] flavors) {
        void var1_1;
        HashSet<DataFlavor> set = new HashSet<DataFlavor>(Arrays.asList(flavors));
        set.retainAll(this.acceptedFlavors);
        return !var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    protected void paintDropTarget(DropTargetEvent e, int action, Point location) {
        if (this.painter != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.painter.paintDropTarget((DropTargetEvent)var1_1, (int)var2_2, (Point)var3_3);
        }
    }

    protected boolean canDrop(DropTargetEvent e, int action, Point location) {
        return true;
    }

    protected abstract void drop(DropTargetDropEvent var1, int var2) throws UnsupportedFlavorException, IOException;
}

