/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.util.LevelUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import ch.qos.logback.core.util.StringUtil;
import java.util.Map;
import java.util.function.Supplier;

public class TylerConfiguratorBase
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    public static final String SET_CONTEXT_METHOD_NAME = "setContext";
    public static final String SET_CONTEXT_NAME_METHOD_NAME = "setContextName";
    public static final String SETUP_LOGGER_METHOD_NAME = "setupLogger";
    public static final String VARIABLE_SUBSTITUTIONS_HELPER_FIELD_NAME = "variableSubstitutionsHelper";
    public static final String PROPERTY_MODEL_HANDLER_HELPER_FIELD_NAME = "propertyModelHandlerHelper";
    protected VariableSubstitutionsHelper variableSubstitutionsHelper;
    protected PropertyModelHandlerHelper propertyModelHandlerHelper = new PropertyModelHandlerHelper((ContextAware)this);

    /*
     * WARNING - void declaration
     */
    protected Logger setupLogger(String loggerName, String levelString, Boolean additivity) {
        void var1_1;
        LoggerContext loggerContext = (LoggerContext)this.context;
        Logger logger = loggerContext.getLogger(loggerName);
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)levelString)) {
            void var2_2;
            Level level = LevelUtil.levelStringToLevel(levelString);
            logger.setLevel((Level)var2_2);
        }
        if (additivity != null) {
            void var3_3;
            logger.setAdditive(var3_3.booleanValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(Context context) {
        void var1_1;
        super.setContext(context);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
        this.propertyModelHandlerHelper.setContext((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void setContextName(String name) {
        if (StringUtil.isNullOrEmpty((String)name)) {
            this.addError("Cannot set context name to null or empty string");
            return;
        }
        try {
            void var2_2;
            String substName = this.subst(name);
            this.addInfo("Setting context name to [" + substName + "]");
            this.context.setName((String)var2_2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            void var1_1;
            this.addError("Failed to rename context as [" + (String)var1_1 + "]");
            return;
        }
    }

    protected void addOnConsoleStatusListener() {
        StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
    }

    /*
     * WARNING - void declaration
     */
    public String subst(String ref) {
        void var1_1;
        return this.variableSubstitutionsHelper.subst((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addSubstitutionProperty(String key, String value) {
        void var2_2;
        void var1_1;
        this.variableSubstitutionsHelper.addSubstitutionProperty((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String getProperty(String key) {
        void var1_1;
        return this.variableSubstitutionsHelper.getProperty((String)var1_1);
    }

    public Map<String, String> getCopyOfPropertyMap() {
        return this.variableSubstitutionsHelper.getCopyOfPropertyMap();
    }

    public boolean isNull(String k) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        String string = OptionHelper.propertyLookup((String)k, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context);
        return string == null;
    }

    public boolean isDefined(String k) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        String string = OptionHelper.propertyLookup((String)k, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context);
        return string != null;
    }

    /*
     * WARNING - void declaration
     */
    public String p(String k) {
        void var1_1;
        return this.property((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String property(String k) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        String val = OptionHelper.propertyLookup((String)k, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context);
        if (val != null) {
            void var1_1;
            return var1_1;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private JoranConfigurator makeAnotherInstance() {
        void var1_1;
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext(this.context);
        return var1_1;
    }

    public Supplier<? extends GenericXMLConfigurator> getConfiguratorSupplier() {
        Supplier<GenericXMLConfigurator> supplier = () -> this.makeAnotherInstance();
        return supplier;
    }

    /*
     * WARNING - void declaration
     */
    protected void processModelFromIncludedFile(Model modelFromIncludedFile) {
        void var3_3;
        void var1_1;
        Supplier<? extends GenericXMLConfigurator> supplier = this.getConfiguratorSupplier();
        GenericXMLConfigurator genericXMLConfigurator = supplier.get();
        ConfigurationModel configururationModel = new ConfigurationModel();
        configururationModel.addSubModel((Model)var1_1);
        supplier.processModel((Model)var3_3);
    }
}

