/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.EventArgUtil;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.StringUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.MDCAdapter;

public class LoggingEvent
implements ILoggingEvent {
    public static final String VIRTUAL_THREAD_NAME_PREFIX = "virtual-";
    public static final String REGULAR_UNNAMED_THREAD_PREFIX = "unnamed-";
    transient String fqnOfLoggerClass;
    private String threadName;
    private String loggerName;
    private LoggerContext loggerContext;
    private LoggerContextVO loggerContextVO;
    private transient Level level;
    private String message;
    transient String formattedMessage;
    private transient Object[] argumentArray;
    private ThrowableProxy throwableProxy;
    private StackTraceElement[] callerDataArray;
    private List<Marker> markerList;
    private Map<String, String> mdcPropertyMap;
    List<KeyValuePair> keyValuePairs;
    private Instant instant;
    private long timeStamp;
    private int nanoseconds;
    private long sequenceNumber;

    public LoggingEvent() {
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray) {
        SequenceNumberGenerator sequenceNumberGenerator;
        void var3_3;
        void var2_2;
        this.fqnOfLoggerClass = fqcn;
        this.loggerName = logger.getName();
        this.loggerContext = var2_2.getLoggerContext();
        this.loggerContextVO = this.loggerContext.getLoggerContextRemoteView();
        this.level = var3_3;
        this.message = message;
        this.argumentArray = argArray;
        Instant instant = Clock.systemUTC().instant();
        this.initTmestampFields(instant);
        if (this.loggerContext != null && (sequenceNumberGenerator = this.loggerContext.getSequenceNumberGenerator()) != null) {
            void var1_1;
            this.sequenceNumber = var1_1.nextSequenceNumber();
        }
        if (throwable == null) {
            throwable = this.extractThrowableAnRearrangeArguments(argArray);
        }
        if (throwable != null) {
            this.throwableProxy = new ThrowableProxy(throwable);
            if (this.loggerContext != null && this.loggerContext.isPackagingDataEnabled()) {
                this.throwableProxy.calculatePackagingData();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void initTmestampFields(Instant instant) {
        void var2_2;
        void var1_1;
        this.instant = instant;
        long epochSecond = instant.getEpochSecond();
        this.nanoseconds = var1_1.getNano();
        long milliseconds = this.nanoseconds / 1000000;
        this.timeStamp = var2_2 * 1000L + milliseconds;
    }

    /*
     * WARNING - void declaration
     */
    private Throwable extractThrowableAnRearrangeArguments(Object[] argArray) {
        void var2_2;
        Throwable extractedThrowable = EventArgUtil.extractThrowable(argArray);
        if (EventArgUtil.successfulExtraction(extractedThrowable)) {
            void var1_1;
            this.argumentArray = EventArgUtil.trimmedCopy((Object[])var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setArgumentArray(Object[] argArray) {
        void var1_1;
        if (this.argumentArray != null) {
            throw new IllegalStateException("argArray has been already set");
        }
        this.argumentArray = var1_1;
    }

    @Override
    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    /*
     * WARNING - void declaration
     */
    public void addKeyValuePair(KeyValuePair kvp) {
        void var1_1;
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new ArrayList<KeyValuePair>(4);
        }
        this.keyValuePairs.add((KeyValuePair)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyValuePairs(List<KeyValuePair> kvpList) {
        void var1_1;
        this.keyValuePairs = var1_1;
    }

    @Override
    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoggerName(String loggerName) {
        void var1_1;
        this.loggerName = var1_1;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = this.extractThreadName(Thread.currentThread());
        }
        return this.threadName;
    }

    /*
     * WARNING - void declaration
     */
    private String extractThreadName(Thread aThread) {
        void var1_1;
        if (aThread == null) {
            return "?";
        }
        String threadName = aThread.getName();
        if (StringUtil.notNullNorEmpty((String)threadName)) {
            return threadName;
        }
        Long virtualThreadId = this.getVirtualThreadId(aThread);
        if (virtualThreadId != null) {
            void var2_2;
            return VIRTUAL_THREAD_NAME_PREFIX + (Long)var2_2;
        }
        return REGULAR_UNNAMED_THREAD_PREFIX + var1_1.getId();
    }

    /*
     * WARNING - void declaration
     */
    Long getVirtualThreadId(Thread aThread) {
        if (EnvUtil.isJDK21OrHigher()) {
            try {
                Method method = Thread.class.getMethod("isVirtual", new Class[0]);
                boolean bl = (Boolean)method.invoke((Object)aThread, new Object[0]);
                if (bl) {
                    void var1_1;
                    return var1_1.getId();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadName(String threadName) throws IllegalStateException {
        void var1_1;
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = var1_1;
    }

    @Override
    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    /*
     * WARNING - void declaration
     */
    public void setThrowableProxy(ThrowableProxy tp) {
        void var1_1;
        if (this.throwableProxy != null) {
            throw new IllegalStateException("ThrowableProxy has been already set.");
        }
        this.throwableProxy = var1_1;
    }

    @Override
    public void prepareForDeferredProcessing() {
        this.getFormattedMessage();
        this.getThreadName();
        this.getMDCPropertyMap();
    }

    /*
     * WARNING - void declaration
     */
    public void setLoggerContext(LoggerContext lc) {
        void var1_1;
        this.loggerContext = var1_1;
    }

    @Override
    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoggerContextRemoteView(LoggerContextVO loggerContextVO) {
        void var1_1;
        this.loggerContextVO = var1_1;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessage(String message) {
        void var1_1;
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set already.");
        }
        this.message = var1_1;
    }

    @Override
    public Instant getInstant() {
        return this.instant;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstant(Instant instant) {
        void var1_1;
        this.initTmestampFields((Instant)var1_1);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getNanoseconds() {
        return this.nanoseconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long timeStamp) {
        void var1_2;
        Instant instant = Instant.ofEpochMilli(timeStamp);
        this.setInstant((Instant)var1_2);
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /*
     * WARNING - void declaration
     */
    public void setSequenceNumber(long sn) {
        void var1_1;
        this.sequenceNumber = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        void var1_1;
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = var1_1;
    }

    @Override
    public StackTraceElement[] getCallerData() {
        if (this.callerDataArray == null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass, this.loggerContext.getMaxCallerDataDepth(), this.loggerContext.getFrameworkPackages());
        }
        return this.callerDataArray;
    }

    @Override
    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setCallerData(StackTraceElement[] callerDataArray) {
        void var1_1;
        this.callerDataArray = var1_1;
    }

    @Override
    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    /*
     * WARNING - void declaration
     */
    public void addMarker(Marker marker) {
        void var1_1;
        if (marker == null) {
            return;
        }
        if (this.markerList == null) {
            this.markerList = new ArrayList<Marker>(4);
        }
        this.markerList.add((Marker)var1_1);
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? (this.throwableProxy == null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray, null).getMessage()) : this.message;
        return this.formattedMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getMDCPropertyMap() {
        if (this.mdcPropertyMap == null) {
            void var1_1;
            MDCAdapter mdcAdapter = this.loggerContext.getMDCAdapter();
            this.mdcPropertyMap = mdcAdapter instanceof LogbackMDCAdapter ? ((LogbackMDCAdapter)mdcAdapter).getPropertyMap() : var1_1.getCopyOfContextMap();
        }
        if (this.mdcPropertyMap == null) {
            this.mdcPropertyMap = Collections.emptyMap();
        }
        return this.mdcPropertyMap;
    }

    /*
     * WARNING - void declaration
     */
    public void setMDCPropertyMap(Map<String, String> map) {
        void var1_1;
        if (this.mdcPropertyMap != null) {
            throw new IllegalStateException("The MDCPropertyMap has been already set for this event.");
        }
        this.mdcPropertyMap = var1_1;
    }

    @Override
    public Map<String, String> getMdc() {
        return this.getMDCPropertyMap();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.level).append("] ");
        sb.append(this.getFormattedMessage());
        return var1_1.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " does not support serialization. Use LoggerEventVO instance instead. See also LoggerEventVO.build method.");
    }
}

