/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.JNDIUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    /*
     * WARNING - void declaration
     */
    public ContextJNDISelector(LoggerContext context) {
        void var1_1;
        this.defaultContext = var1_1;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext detachLoggerContext(String loggerContextName) {
        void var1_1;
        return this.synchronizedContextMap.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getLoggerContext() {
        void var3_3;
        String contextName = null;
        javax.naming.Context ctx = null;
        LoggerContext lc = threadLocal.get();
        if (lc != null) {
            return lc;
        }
        try {
            ctx = JNDIUtil.getInitialContext();
            contextName = JNDIUtil.lookupString((javax.naming.Context)ctx, (String)"java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (contextName == null) {
            return this.defaultContext;
        }
        LoggerContext loggerContext = this.synchronizedContextMap.get(contextName);
        if (loggerContext == null) {
            void var2_2;
            loggerContext = new LoggerContext();
            loggerContext.setName(contextName);
            this.synchronizedContextMap.put(contextName, loggerContext);
            URL url = this.findConfigFileURL((javax.naming.Context)var2_2, loggerContext);
            if (url != null) {
                void var1_1;
                this.configureLoggerContextByURL(loggerContext, (URL)var1_1);
            } else {
                try {
                    new ContextInitializer(loggerContext).autoConfig();
                }
                catch (JoranException joranException) {}
            }
            if (!StatusUtil.contextHasStatusListener((Context)loggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
            }
        }
        return var3_3;
    }

    private String conventionalConfigFileName(String contextName) {
        return "logback-" + contextName + ".xml";
    }

    /*
     * WARNING - void declaration
     */
    private URL findConfigFileURL(javax.naming.Context ctx, LoggerContext loggerContext) {
        void var1_1;
        void var3_4;
        void var2_3;
        StatusManager sm = loggerContext.getStatusManager();
        String jndiEntryForConfigResource = null;
        try {
            jndiEntryForConfigResource = JNDIUtil.lookupString((javax.naming.Context)ctx, (String)"java:comp/env/logback/configuration-resource");
        }
        catch (NamingException e) {
            sm.add((Status)new WarnStatus("JNDI lookup failed", (Object)this, (Throwable)e));
        }
        if (jndiEntryForConfigResource != null) {
            sm.add((Status)new InfoStatus("Searching for [" + jndiEntryForConfigResource + "]", (Object)this));
            URL url = this.urlByResourceName(sm, jndiEntryForConfigResource);
            if (url == null) {
                String msg = "The jndi resource [" + jndiEntryForConfigResource + "] for context [" + loggerContext.getName() + "] does not lead to a valid file";
                sm.add((Status)new WarnStatus((String)var2_3, (Object)this));
            }
            return url;
        }
        String resourceByConvention = this.conventionalConfigFileName(var2_3.getName());
        return this.urlByResourceName((StatusManager)var3_4, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private URL urlByResourceName(StatusManager sm, String resourceName) {
        void var2_2;
        sm.add((Status)new InfoStatus("Searching for [" + resourceName + "]", (Object)this));
        URL url = Loader.getResource((String)resourceName, (ClassLoader)Loader.getTCL());
        if (url != null) {
            void var1_1;
            return var1_1;
        }
        return Loader.getResourceBySelfClassLoader((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void configureLoggerContextByURL(LoggerContext context, URL url) {
        void var1_1;
        try {
            void var2_2;
            void var3_3;
            JoranConfigurator configurator = new JoranConfigurator();
            context.reset();
            configurator.setContext((Context)context);
            var3_3.doConfigure((URL)var2_2);
        }
        catch (JoranException joranException) {}
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getContextNames() {
        void var1_1;
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.synchronizedContextMap.keySet());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getLoggerContext(String name) {
        void var1_1;
        return this.synchronizedContextMap.get(var1_1);
    }

    public int getCount() {
        return this.synchronizedContextMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalContext(LoggerContext context) {
        void var1_1;
        threadLocal.set((LoggerContext)var1_1);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

