/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.KeyValuePairConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.event.KeyValuePair;

public class MaskedKeyValuePairConverter
extends ClassicConverter {
    public static final String MASK = "XXX";
    List<String> optionList;
    List<String> maskList = new ArrayList<String>();
    KeyValuePairConverter.ValueQuoteSpecification valueQuoteSpec = KeyValuePairConverter.ValueQuoteSpecification.DOUBLE;

    /*
     * WARNING - void declaration
     */
    public void start() {
        this.optionList = this.getOptionList();
        MaskedKeyValuePairConverter maskedKeyValuePairConverter = this;
        KeyValuePairConverter.ValueQuoteSpecification extractedSpec = maskedKeyValuePairConverter.extractSpec(maskedKeyValuePairConverter.optionList);
        if (extractedSpec == null) {
            this.maskList = this.optionList;
        } else {
            void var1_1;
            this.valueQuoteSpec = var1_1;
            this.maskList = this.optionList.subList(1, this.optionList.size());
        }
        MaskedKeyValuePairConverter maskedKeyValuePairConverter2 = this;
        maskedKeyValuePairConverter2.checkMaskListForExtraQuoteSpecs(maskedKeyValuePairConverter2.maskList);
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    private void checkMaskListForExtraQuoteSpecs(List<String> maskList) {
        void var1_1;
        if (maskList == null || maskList.isEmpty()) {
            return;
        }
        if (maskList.contains("DOUBLE")) {
            this.addWarn("quote spec DOUBLE found in the wrong order");
        }
        if (maskList.contains("SINGLE")) {
            this.addWarn("extra quote spec SINGLE found in the wrong order");
        }
        if (var1_1.contains("NONE")) {
            this.addWarn("extra quote spec NONE found in the wrong order");
        }
    }

    /*
     * WARNING - void declaration
     */
    KeyValuePairConverter.ValueQuoteSpecification extractSpec(List<String> optionList) {
        void var1_1;
        if (optionList == null || optionList.isEmpty()) {
            return null;
        }
        String firstOption = optionList.get(0);
        if ("DOUBLE".equalsIgnoreCase(firstOption)) {
            return KeyValuePairConverter.ValueQuoteSpecification.DOUBLE;
        }
        if ("SINGLE".equalsIgnoreCase(firstOption)) {
            return KeyValuePairConverter.ValueQuoteSpecification.SINGLE;
        }
        if ("NONE".equalsIgnoreCase((String)var1_1)) {
            return KeyValuePairConverter.ValueQuoteSpecification.NONE;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String convert(ILoggingEvent event) {
        void var2_2;
        List<KeyValuePair> kvpList = event.getKeyValuePairs();
        if (kvpList == null || kvpList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < kvpList.size(); ++i) {
            KeyValuePair kvp = kvpList.get(i);
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(String.valueOf(kvp.key));
            sb.append('=');
            Character quoteChar = this.valueQuoteSpec.asChar();
            if (quoteChar != null) {
                sb.append(quoteChar);
            }
            if (this.maskList.contains(kvp.key)) {
                sb.append(MASK);
            } else {
                sb.append(String.valueOf(kvp.value));
            }
            if (quoteChar == null) continue;
            sb.append(quoteChar);
        }
        return var2_2.toString();
    }
}

